<?xml version="1.0" encoding="UTF-8"?>
<!-- ctk 
	 21/10/2005 
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">


	<!--
		PORTADA
	-->
	<xsl:attribute-set name="TituloPortada">
		<xsl:attribute name="font-family">Helvetica</xsl:attribute>
		<xsl:attribute name="font-size">18pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="text-align">center</xsl:attribute>
	</xsl:attribute-set>
	<!-- 
			CRITERIOS
		-->
	<xsl:attribute-set name="EtiquetaCriterio">
		<xsl:attribute name="font-family">Helvetica</xsl:attribute>
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="font-weight">normal</xsl:attribute>
		<xsl:attribute name="text-align">end</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="ValorCriterio">
		<xsl:attribute name="text-align">start</xsl:attribute>
		<xsl:attribute name="font-family">Helvetica</xsl:attribute>
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>
	<!--
		RESULTADO CONSULTA
	-->
	<xsl:attribute-set name="EtiquetaCabecera">
		<xsl:attribute name="padding">2pt</xsl:attribute>
		<xsl:attribute name="border">none</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="font-weight">normal</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="DatoCabecera">
		<xsl:attribute name="padding">2pt</xsl:attribute>
		<xsl:attribute name="border">none</xsl:attribute>
			<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
</xsl:attribute-set>
	<xsl:attribute-set name="TbTitulo">
		<xsl:attribute name="font-size">9pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="TbTextoCabecera">
		<xsl:attribute name="font-size">7pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="TbTextoCelda">
		<xsl:attribute name="font-size">7pt</xsl:attribute>
		<xsl:attribute name="font-weight">normal</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="TbFormatoCeldaCabecera">
		<xsl:attribute name="padding">2pt</xsl:attribute>
		<xsl:attribute name="border">0.5pt solid</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="TbFormatoCeldaDato">
		<xsl:attribute name="padding">2pt</xsl:attribute>
		<xsl:attribute name="border">none</xsl:attribute>
	</xsl:attribute-set>
	<!-- No se usan, de momento. Hay que duplicar toda la línea -->
	<xsl:attribute-set name="LineaPar">
		<xsl:attribute name="background-color">white</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="LineaImpar">
		<xsl:attribute name="background-color">gray</xsl:attribute>
	</xsl:attribute-set>
	<!-- Hasta aquí los estilos que no se usan -->
	<!--
		ENCABEZADOS, PIES
		
	-->
	<xsl:attribute-set name="Encabezado">
		<xsl:attribute name="font-family">Helvetica</xsl:attribute>
		<xsl:attribute name="font-size">11pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="Pie">
		<xsl:attribute name="font-family">Helvetica</xsl:attribute>
		<xsl:attribute name="font-size">9pt</xsl:attribute>
		<xsl:attribute name="font-weight">normal</xsl:attribute>
	</xsl:attribute-set>
	<!-- FORMATO DE LOS IMPORTES -->
	<xsl:decimal-format  name = "fmtImporte"   decimal-separator = "," grouping-separator="."  minus-sign = "-"/>
	<xsl:variable name="ImpMask">#.##0,00</xsl:variable>


	<xsl:variable name="idioma_cas">es</xsl:variable>
	<xsl:variable name="idioma_eus">eu</xsl:variable>
	<xsl:template match="/">
		<xsl:apply-templates select="consulta"/>
	</xsl:template>
	<xsl:template match="consulta">
		<xsl:processing-instruction name="cocoon-format">type="text/xslfo"</xsl:processing-instruction>
		<!-- Variables Globales	-->
		<xsl:variable name="idioma" select="normalize-space(//consulta/idioma)"/>
		<!-- hasta aqui­ la declaracion de variables globales -->
		<fo:root xmlns:fo="http://www.w3.org/1999/XSL/Format">
			<fo:layout-master-set>
				<fo:simple-page-master master-name="portada" page-height="210mm" page-width="297mm">
					<fo:region-body margin-top="2cm" margin-bottom="2cm" margin-left="2cm" margin-right="2cm"/>
					<fo:region-after precedence="true" extent="10mm" overflow="auto"/>
				</fo:simple-page-master>
				<xsl:if test="string-length(//consulta/SinDatos) = 0">
					<fo:simple-page-master master-name="todas" page-height="210mm" page-width="297mm">
						<fo:region-before precedence="true" extent="20mm" border="1pt" border-color="green"/>
						<fo:region-body margin-top="20mm" margin-left="5mm" margin-bottom="15mm" margin-right="5mm"/>
						<fo:region-after precedence="true" extent="10mm" overflow="auto"/>
					</fo:simple-page-master>
				</xsl:if>
				<fo:page-sequence-master master-name="secuencia">
					<fo:single-page-master-reference master-reference="portada"/>
					<xsl:if test="string-length(//consulta/SinDatos) = 0">
						<fo:repeatable-page-master-reference master-reference="todas"/>
					</xsl:if>
				</fo:page-sequence-master>
			</fo:layout-master-set>
			<fo:page-sequence master-reference="portada">
				<fo:static-content flow-name="xsl-region-after" margin-left="10mm" margin-right="10mm">
					<fo:table table-layout="fixed" width="100%" border="1pt">
						<fo:table-column column-width="proportional-column-width(1)"/>
						<fo:table-column column-width="proportional-column-width(1)"/>
						<fo:table-column column-width="proportional-column-width(1)"/>
						<fo:table-body>
							<fo:table-row>
								<fo:table-cell>
									<fo:block xsl:use-attribute-sets="Pie">
										<xsl:value-of select="//consulta/fechaHora"/>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell/>
								<fo:table-cell>
									<fo:block text-align="end" xsl:use-attribute-sets="Pie">
										<xsl:if test="$idioma=$idioma_cas">
											<xsl:text>Pagina  </xsl:text>
											<fo:page-number/>
											<!-- <xsl:text> de </xsl:text>
											<fo:page-number-citation ref-id="final"/> -->
										</xsl:if>
										<xsl:if test="$idioma=$idioma_eus">
											<!-- <fo:page-number-citation ref-id="final"/>
											<xsl:text>.tik </xsl:text> -->
											<fo:page-number/>
											<xsl:text> orria </xsl:text>
										</xsl:if>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>
				</fo:static-content>
				<fo:flow flow-name="xsl-region-body">
					<fo:table table-layout="fixed" width="100%">
						<fo:table-column column-width="proportional-column-width(1)"/>
						<fo:table-column column-width="230mm"/>
						<fo:table-column column-width="proportional-column-width(1)"/>
						<fo:table-body>
							<fo:table-row>
								<fo:table-cell/>
								<fo:table-cell text-align="center" padding="10mm">
									<fo:block xsl:use-attribute-sets="TituloPortada" space-before.optimum="6cm">
										<xsl:apply-templates select="title"/>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell/>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell/>
								<fo:table-cell>
									<fo:block>
										<xsl:apply-templates select="criterios"/>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell/>
							</fo:table-row>
							<xsl:if test="string-length(//consulta/SinDatos) &gt; 0">
								<fo:table-row>
									<fo:table-cell/>
									<fo:table-cell>
										<fo:block text-transform="uppercase" font-weight="bold" text-align="center" space-before.optimum="20pt">
											<xsl:text>***</xsl:text>
											<xsl:value-of select="SinDatos"/>
											<xsl:text>***</xsl:text>
										</fo:block>
										<fo:block id="final"/>
									</fo:table-cell>
									<fo:table-cell/>
								</fo:table-row>
							</xsl:if>
						</fo:table-body>
					</fo:table>
				</fo:flow>
			</fo:page-sequence>
			<xsl:if test="string-length(//consulta/SinDatos) = 0">
				<fo:page-sequence master-reference="todas">
					<fo:static-content flow-name="xsl-region-before">
						<fo:block text-align="center" space-before="10mm" xsl:use-attribute-sets="Encabezado">
							<xsl:apply-templates select="title"/>
						</fo:block>
					</fo:static-content>
					<fo:static-content flow-name="xsl-region-after" margin-left="10mm" margin-right="10mm">
						<fo:table table-layout="fixed" width="100%" border="1pt">
							<fo:table-column column-width="proportional-column-width(1)"/>
							<fo:table-column column-width="proportional-column-width(1)"/>
							<fo:table-column column-width="proportional-column-width(1)"/>
							<fo:table-body>
								<fo:table-row>
									<fo:table-cell>
										<fo:block xsl:use-attribute-sets="Pie">
											<xsl:value-of select="//consulta/fechaHora"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell/>
									<fo:table-cell>
										<fo:block text-align="end" xsl:use-attribute-sets="Pie">
											<xsl:if test="$idioma=$idioma_cas">
												<xsl:text>Pagina  </xsl:text>
												<fo:page-number/>
												<!-- <xsl:text> de </xsl:text>
												<fo:page-number-citation ref-id="final"/> -->
											</xsl:if>
											<xsl:if test="$idioma=$idioma_eus">
												<!-- <fo:page-number-citation ref-id="final"/>
												<xsl:text>.tik </xsl:text> -->
												<fo:page-number/>
												<xsl:text> orria </xsl:text>
											</xsl:if>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
							</fo:table-body>
						</fo:table>
					</fo:static-content>
					<fo:flow flow-name="xsl-region-body">
						<fo:table border="none" table-layout="fixed" width="100%">
							<fo:table-column column-width="287mm"/>
							<fo:table-header>
								<fo:table-row>
									<fo:table-cell border="none">
										<fo:block>
											<xsl:apply-templates select="cabecera"/>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell height="20px">
										<fo:block/>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell padding="0" text-align="center">
										<fo:block xsl:use-attribute-sets="TbTitulo">
											<xsl:apply-templates select="tabla/titulo"/>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
							</fo:table-header>
							<fo:table-body>
								<fo:table-row>
									<fo:table-cell>
										<fo:block>
											<xsl:apply-templates select="tabla/grupos"/>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell>
										<fo:block>
											<xsl:apply-templates select="final"/>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
							</fo:table-body>
						</fo:table>
						<!-- <fo:block id="final"/> -->
					</fo:flow>
				</fo:page-sequence>
			</xsl:if>
		</fo:root>
	</xsl:template>


	<!-- 
	_______________ ZONA DE CRITERIOS DE LA CONSULTA _____________
	________________ Van en la portada, debajo del título _________________
	-->
	<xsl:template match="criterios">
		<fo:table table-layout="fixed" border="none" width="100%">
			<fo:table-column column-width="proportional-column-width(1)"/>
			<fo:table-column column-width="proportional-column-width(2)"/>
			<fo:table-column column-width="proportional-column-width(1.5)"/>
			<fo:table-column column-width="proportional-column-width(1)"/>
			<fo:table-body>
				<xsl:for-each select="criterio">
					<fo:table-row>
						<fo:table-cell/>
						<fo:table-cell padding="2mm" border="none" xsl:use-attribute-sets="EtiquetaCriterio">
							<fo:block>
								<xsl:value-of select="./etiqueta"/>:
							</fo:block>
						</fo:table-cell>
						<fo:table-cell padding="2mm" border="none" xsl:use-attribute-sets="ValorCriterio">
							<fo:block>
								<xsl:value-of select="./valor"/>
							</fo:block>
						</fo:table-cell>
						<fo:table-cell/>
					</fo:table-row>
				</xsl:for-each>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	<!--
	____________  ZONA DE GESTION DE GRUPOS _________
	-->
	<xsl:template match="tabla/grupos">
		<fo:table table-layout="fixed" width="100%">
			<fo:table-column column-width="proportional-column-width(1)"/>
			<fo:table-header>
				<fo:table-row>
					<fo:table-cell>
						<fo:block>
							<xsl:apply-templates select="//tabla/cabecera">
								</xsl:apply-templates>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
				<!-- linea necesaria para que se muestre la ultima linea horizontal de la cabecera -->
				<fo:table-row xsl:use-attribute-sets="TbFormatoCeldaCabecera" border-left="none" border-right="none" border-bottom="none" height="2pt"/>
			</fo:table-header>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell>
						<fo:block>
							<xsl:apply-templates select="//tabla/lineas">
								</xsl:apply-templates>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	<!--
	____________  ZONA DE CABECERA DE LA TABLA ___________
	_____________          Títulos de las columnas            ___________
	                                    Van en la tabla general, como cabecera. Sale en todas las páginas
	-->
	<xsl:template match="tabla/cabecera">
		<fo:table table-layout="fixed" inline-progression-dimension.optimum="100%">
			<fo:table-column column-width="proportional-column-width(1)"/>
			<fo:table-column column-width="15mm"/>
			<fo:table-column column-width="70mm"/>
			<fo:table-column column-width="70mm"/>
			<fo:table-column column-width="15mm"/>
			<fo:table-column column-width="15mm"/>
			<fo:table-column column-width="50mm"/>
			<fo:table-column column-width="18mm"/>
			<fo:table-column column-width="proportional-column-width(1)"/>
			<fo:table-body>
				<fo:table-row border="0.5px solid" xsl:use-attribute-sets="TbTextoCabecera">
					<fo:table-cell/>
					<fo:table-cell xsl:use-attribute-sets="TbFormatoCeldaCabecera">
						<fo:block>
							<xsl:value-of select="columna[@id='CodReclamante']"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="TbFormatoCeldaCabecera">
						<fo:block>
							<xsl:value-of select="columna[@id='Nombre']"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="TbFormatoCeldaCabecera">
						<fo:block>
							<xsl:value-of select="columna[@id='Apellidos']"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="TbFormatoCeldaCabecera">
						<fo:block>
							<xsl:value-of select="columna[@id='NIF']"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="TbFormatoCeldaCabecera">
						<fo:block>
							<xsl:value-of select="columna[@id='CP']"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="TbFormatoCeldaCabecera">
						<fo:block>
							<xsl:value-of select="columna[@id='Poblacion']"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="TbFormatoCeldaCabecera">
						<fo:block>
							<xsl:value-of select="columna[@id='CodReprte']"/>
						</fo:block>
					</fo:table-cell>
					
					<fo:table-cell/>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	<!--
	_____________  ZONA DE DATOS DE LA TABLA _____________
	_____________          Van en la tabla general
	-->
	<xsl:template match="tabla/lineas">
		<fo:table table-layout="fixed" inline-progression-dimension.optimum="100%">
			<fo:table-column column-width="proportional-column-width(1)"/>
			<fo:table-column column-width="15mm"/>
			<fo:table-column column-width="70mm"/>
			<fo:table-column column-width="70mm"/>
			<fo:table-column column-width="15mm"/>			
			<fo:table-column column-width="15mm"/>						
			<fo:table-column column-width="50mm"/>						
			<fo:table-column column-width="18mm"/>						
			<fo:table-column column-width="proportional-column-width(1)"/>
			<fo:table-body>
				<xsl:for-each select="linea">
					<fo:table-row keep-together="always" xsl:use-attribute-sets="TbTextoCelda">
						<xsl:choose>
							<xsl:when test="number(columna[@id='NLinea']) mod 2 = 0">
								<xsl:attribute name="background-color">rgb(230,230,230)</xsl:attribute>
							</xsl:when>
							<xsl:otherwise>
								<xsl:attribute name="background-color">white</xsl:attribute>
							</xsl:otherwise>
						</xsl:choose>
						<fo:table-cell background-color="white"/>
						<fo:table-cell xsl:use-attribute-sets="TbFormatoCeldaDato">
							<fo:block>
								<xsl:value-of select="columna[@id='CodReclamante']"/>
							</fo:block>
						</fo:table-cell>
						<fo:table-cell xsl:use-attribute-sets="TbFormatoCeldaDato">
							<fo:block>
								<xsl:value-of select="columna[@id='Nombre']"/>
							</fo:block>
						</fo:table-cell>
						<fo:table-cell xsl:use-attribute-sets="TbFormatoCeldaDato">
							<fo:block>
								<xsl:value-of select="columna[@id='Apellidos']"/>
							</fo:block>
						</fo:table-cell>
						<fo:table-cell xsl:use-attribute-sets="TbFormatoCeldaDato">
							<fo:block>
								<xsl:value-of select="columna[@id='NIF']"/>
							</fo:block>
						</fo:table-cell>
						<fo:table-cell xsl:use-attribute-sets="TbFormatoCeldaDato">
							<fo:block>
								<xsl:value-of select="columna[@id='CP']"/>
							</fo:block>
						</fo:table-cell>
						<fo:table-cell xsl:use-attribute-sets="TbFormatoCeldaDato">
							<fo:block>
								<xsl:value-of select="columna[@id='Poblacion']"/>
							</fo:block>
						</fo:table-cell>
						<fo:table-cell xsl:use-attribute-sets="TbFormatoCeldaDato">
							<fo:block>
								<xsl:value-of select="columna[@id='CodReprte']"/>
							</fo:block>
						</fo:table-cell>
						
						<fo:table-cell background-color="white"/>
					</fo:table-row>
				</xsl:for-each>
			</fo:table-body>
		</fo:table>
	</xsl:template>
</xsl:stylesheet>
