package m05bDescripcionEJB;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

import javax.ejb.CreateException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.RemoveException;

import m05bBD.m05bDescripcion;


/**
 * This class is the Bean Implementation for the Entity EJB <tt>M05DescripcionEB</tt>.
 *
 * @see     m05.exe.Descripcion
 * @see     m05.exe.M05DescripcionEB
 * @see     m05.exe.M05DescripcionEBPK
 * @see     m05.exe.M05DescripcionEBHome
 * @author <a href="mailto:paco.gomez@terra.com">Paco Gomez</a>.
 *         Professional J2EE Programming with BEA WebLogic Server, 
 *         by Gomez & Zadrozny, Copyright &#169; 2000. 
 */
abstract public class m05DescripcionBean implements EntityBean {
  
  private EntityContext ctx;

  

  /** 
   * This is the primary key.
   * It is the clave, which is the primary key 
   * in table <tt>m0599t00</tt>.
   */
 /* public long des_tabla          	= 0;
  public String des_codigo        	= "";
  public String des_descripcion     = "";*/
  
  /**
   * Returns the Descripcion information of this E-EJB.
   */    
  public m05bDescripcion getDescripcion(){
    m05bDescripcion descripcion = new m05bDescripcion();
    
    descripcion.setDes_tabla(getDes_tabla());
    descripcion.setDes_codigo(getDes_codigo());
    descripcion.setDes_descripcion(getDes_descripcion());
    descripcion.setDes_descripcionEu(getDes_descripcionEu());
    
    return descripcion;	
  }    

  /**
   * Sets the Descripcion information of this E-EJB.
   * @exception P2GException 
   *              If the given Descripcion <tt>des_codigo</tt> field 
   *              does not match the primary key that is in the E-EJB.
   */   
  public void setDescripcion(m05bDescripcion descripcion)
    throws Exception{
   
    //the primary key is never modified!!
    if (getDes_tabla() != descripcion.getDes_tabla())
      throw new CreateException ("Cannot modify a different descripcion");
      
    setDes_codigo(descripcion.getDes_codigo());
    setDes_descripcion(descripcion.getDes_descripcion());
    setDes_descripcionEu(getDes_descripcionEu());
  }   	
	
  
  abstract public long getDes_tabla();
  abstract public void setDes_tabla(long n);
  
  abstract public String getDes_codigo();
  abstract public void setDes_codigo(String n);

  abstract public String getDes_descripcion();
  abstract public void setDes_descripcion(String n);
  abstract public String getDes_descripcionEu();
  abstract public void setDes_descripcionEu(String n);

  public void ejbActivate() {
  }

  public void ejbPassivate() {
  }

  public void setEntityContext(EntityContext ctx) {
    this.ctx = ctx;
  }

  public void unsetEntityContext() {
    this.ctx = null;
  }

  public void ejbLoad() {
  }
  
  public void ejbStore() {
  }

  public void ejbRemove()
    throws RemoveException
  {
  }

  /**
   * This function initializes the Descripcion 
   * information of this E-EJB.
   * It assigns a new primary key to the Descripcion.
   * @see #getNewOrderNum()
   */ 
  public m05DescripcionPK ejbCreate(m05bDescripcion descripcion) 
    throws CreateException
  {
    try {
      setDes_codigo(getNewDes_codigo());
    } catch (Exception e) {
      throw new CreateException (e.getMessage());
    }    
    setDes_tabla(descripcion.getDes_tabla());
    setDes_descripcion(descripcion.getDes_descripcion());
    setDes_descripcionEu(descripcion.getDes_descripcionEu());
    return null;      	
  }

  public void ejbPostCreate(m05bDescripcion descripcion) 
  {
  }

  /**
   * This function finds a new primary key for this EJB.
   * It uses a sequence value from the database 
   * (<tt>m0517t00_descripcions</tt>).
   * @see #ejbCreate(Descripcion descripcion)
   */
  private String getNewDes_codigo() throws Exception { 

    Connection conn     = null;
    Statement  stmt     = null;
    ResultSet  resultSet= null;
    long       orderNum = 0;

    try {
      conn = DriverManager.getConnection("jdbc20:weblogic:oracle");
      stmt = conn.createStatement();
      stmt.executeQuery("select max(cod_desc_99) + 1 from m0599t00");
      resultSet = stmt.getResultSet();
      if ((resultSet != null) && (resultSet.next())) {
        setDes_codigo(resultSet.getString(1));
      } else {
        throw new CreateException ("ejbCreate: select failed to return a value");
      }
    } 
    catch (SQLException sqe) {
      throw new CreateException (sqe.getMessage());
    } 
    finally {
      try{
        if (resultSet != null) resultSet.close();      
        if (stmt != null)      stmt.close();
        if (conn != null)      conn.close();
      }
      catch(Exception w){
        System.err.println("Warning: m05DescripcionBean.getNewDes_codigo: " + w);
      }         
    }
    String cod =getDes_codigo();
    return cod;
  }

}
