package m05bDepartamentoEJB;

import javax.ejb.*;
import m05bBD.m05bDepartamento;

/**
 * This class is the Bean Implementation for the Entity EJB
 * <tt>M05DepartamentoEB</tt>.
 * 
 * @see m05.exe.Departamento
 * @see m05.exe.M05DepartamentoEB
 * @see m05.exe.M05DepartamentoEBPK
 * @see m05.exe.M05DepartamentoEBHome
 * @author <a href="mailto:paco.gomez@terra.com">Paco Gomez</a>. Professional
 *         J2EE Programming with BEA WebLogic Server, by Gomez & Zadrozny,
 *         Copyright &#169; 2000.
 */
abstract public class m05DepartamentoBean implements EntityBean {

	private EntityContext ctx;

	/**
	 * This is the primary key. It is the clave, which is the primary key in
	 * table <tt>m0502t00</tt>.
	 */
	/*
	 * public String avi_codigo = "0"; public String avi_descripcion = "";
	 */

	/**
	 * Returns the Departamento information of this E-EJB.
	 */
	public m05bDepartamento getDepartamento() {
		m05bDepartamento departamento = new m05bDepartamento();

		departamento.setDep_codigo(getDep_codigo());
		departamento.setDep_descripcion(getDep_descripcion());
		departamento.setDep_edescripcion(getDep_edescripcion());
		departamento.setDep_cod_xlnet(getDep_cod_xlnet());
		departamento.setDep_situacion(getDep_situacion());

		return departamento;
	}

	/**
	 * Sets the Departamento information of this E-EJB.
	 * 
	 * @exception P2GException
	 *                If the given Departamento <tt>avi_codigo</tt> field does
	 *                not match the primary key that is in the E-EJB.
	 */
	public void setDepartamento(m05bDepartamento departamento) throws Exception {

		// the primary key is never modified!!
		if (getDep_codigo() != departamento.getDep_codigo())
			throw new CreateException("Cannot modify a different departamento");

		setDep_descripcion(departamento.getDep_descripcion());
		setDep_edescripcion(departamento.getDep_edescripcion());
		setDep_cod_xlnet(departamento.getDep_cod_xlnet());
		setDep_situacion(departamento.getDep_situacion());
	}

	abstract public String getDep_codigo();

	abstract public void setDep_codigo(String n);

	abstract public String getDep_descripcion();

	abstract public void setDep_descripcion(String n);

	abstract public String getDep_edescripcion();

	abstract public void setDep_edescripcion(String n);

	abstract public String getDep_cod_xlnet();

	abstract public void setDep_cod_xlnet(String n);

	abstract public String getDep_situacion();

	abstract public void setDep_situacion(String n);

	public void ejbActivate() {
	}

	public void ejbPassivate() {
	}

	public void setEntityContext(EntityContext ctx) {
		this.ctx = ctx;
	}

	public void unsetEntityContext() {
		this.ctx = null;
	}

	public void ejbLoad() {
	}

	public void ejbStore() {
	}

	public void ejbRemove() throws RemoveException {
	}

	/**
	 * This function initializes the Departamento information of this E-EJB. It
	 * assigns a new primary key to the Departamento.
	 */
	public m05DepartamentoPK ejbCreate(m05bDepartamento departamento)
			throws CreateException {
		try {
			setDep_codigo(getDep_codigo());
		} catch (Exception e) {
			throw new CreateException(e.getMessage());
		}
		setDep_descripcion(departamento.getDep_descripcion());
		setDep_edescripcion(departamento.getDep_edescripcion());
		setDep_cod_xlnet(departamento.getDep_cod_xlnet());
		setDep_situacion(departamento.getDep_situacion());
		return null;
	}

	public void ejbPostCreate(m05bDepartamento departamento) {
	}
}