package m05bCentroEJB;

import javax.ejb.CreateException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.RemoveException;

import m05bBD.m05bCentro;


/**
 * This class is the Bean Implementation for the Entity EJB <tt>M05CentroEB</tt>.
 *
 * @see     m05.exe.Centro
 * @see     m05.exe.M05CentroEB
 * @see     m05.exe.M05CentroEBPK
 * @see     m05.exe.M05CentroEBHome
 * @author <a href="mailto:paco.gomez@terra.com">Paco Gomez</a>.
 *         Professional J2EE Programming with BEA WebLogic Server, 
 *         by Gomez & Zadrozny, Copyright &#169; 2000. 
 */
abstract public class m05CentroBean implements EntityBean {
  
  private EntityContext ctx;

 

  /** 
   * This is the primary key.
   * It is the clave, which is the primary key 
   * in table <tt>m0505t00</tt>.
   */
  /*public String ctr_codigo   = "0";
  public String ctr_descripcion     = "";*/
  
  /**
   * Returns the Centro information of this E-EJB.
   */    
  public m05bCentro getCentro(){
    m05bCentro centro = new m05bCentro();
    
    centro.setCtr_codigo(getCtr_codigo());
    centro.setCtr_descripcion(getCtr_descripcion());
    centro.setCtr_descripcionEu(getCtr_descripcionEu());
    
    return centro;	
  }    

  /**
   * Sets the Centro information of this E-EJB.
   * @exception P2GException 
   *              If the given Centro <tt>ctr_codigo</tt> field 
   *              does not match the primary key that is in the E-EJB.
   */   
  public void setCentro(m05bCentro centro)
    throws Exception{
   
    //the primary key is never modified!!
    if (getCtr_codigo() != centro.getCtr_codigo())
      throw new CreateException ("Cannot modify a different centro");
      
    setCtr_descripcion(centro.getCtr_descripcion());
    setCtr_descripcionEu(centro.getCtr_descripcionEu());
  }   	
  
  abstract public String getCtr_codigo();
  abstract public void setCtr_codigo(String n);
  
  abstract public String getCtr_descripcion();
  abstract public void setCtr_descripcion(String n);
  abstract public String getCtr_descripcionEu();
  abstract public void setCtr_descripcionEu(String n);
  public void ejbActivate() {
  }

  public void ejbPassivate() {
  }

  public void setEntityContext(EntityContext ctx) {
    this.ctx = ctx;
  }

  public void unsetEntityContext() {
    this.ctx = null;
  }

  public void ejbLoad() {
  }
  
  public void ejbStore() {
  }

  public void ejbRemove()
    throws RemoveException
  {
  }

  /**
   * This function initializes the Centro 
   * information of this E-EJB.
   * It assigns a new primary key to the Centro.
   */ 
  public m05CentroPK ejbCreate(m05bCentro centro) 
    throws CreateException
  {
    try {
      setCtr_codigo(getCtr_codigo());
    } catch (Exception e) {
      throw new CreateException (e.getMessage());
    }    
    setCtr_descripcion(centro.getCtr_descripcion());
    setCtr_descripcionEu(centro.getCtr_descripcionEu());
    return null;      	
  }

  public void ejbPostCreate(m05bCentro centro) 
  {
  }

 
}
