package m05bCargoEJB;

import javax.ejb.CreateException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.RemoveException;

import m05bBD.m05bCargo;


/**
 * This class is the Bean Implementation for the Entity EJB <tt>M05CargoEB</tt>.
 *
 * @see     m05.exe.Cargo
 * @see     m05.exe.M05CargoEB
 * @see     m05.exe.M05CargoEBPK
 * @see     m05.exe.M05CargoEBHome
 * @author <a href="mailto:paco.gomez@terra.com">Paco Gomez</a>.
 *         Professional J2EE Programming with BEA WebLogic Server, 
 *         by Gomez & Zadrozny, Copyright &#169; 2000. 
 */
abstract public class m05CargoBean implements EntityBean {
  
  private EntityContext ctx;

 

  /** 
   * This is the primary key.
   * It is the clave, which is the primary key 
   * in table <tt>m0504t00</tt>.
   */
  
  /**
   * Returns the Cargo information of this E-EJB.
   */    
  public m05bCargo getCargo(){
    m05bCargo cargo = new m05bCargo();
    
    cargo.setCar_codigo(getCar_codigo());
    cargo.setCar_descripcion(getCar_descripcion());
    cargo.setCar_edescripcion(getCar_edescripcion());
    
    return cargo;	
  }    

  /**
   * Sets the Cargo information of this E-EJB.
   * @exception P2GException 
   *              If the given Cargo <tt>car_codigo</tt> field 
   *              does not match the primary key that is in the E-EJB.
   */   
  public void setCargo(m05bCargo cargo)
    throws Exception{
   
    //the primary key is never modified!!
    if (getCar_codigo() != cargo.getCar_codigo())
      throw new CreateException ("Cannot modify a different cargo");
      
    setCar_descripcion(cargo.getCar_descripcion());
    setCar_edescripcion(cargo.getCar_edescripcion());
  }   	
  
  abstract public String getCar_codigo();
  abstract public void setCar_codigo(String n);
  
  abstract public String getCar_descripcion();
  abstract public void setCar_descripcion(String n);
  
  abstract public String getCar_edescripcion();
  abstract public void setCar_edescripcion(String n);

  public void ejbActivate() {
  }

  public void ejbPassivate() {
  }

  public void setEntityContext(EntityContext ctx) {
    this.ctx = ctx;
  }

  public void unsetEntityContext() {
    this.ctx = null;
  }

  public void ejbLoad() {
  }
  
  public void ejbStore() {
  }

  public void ejbRemove()
    throws RemoveException
  {
  }

  /**
   * This function initializes the Cargo 
   * information of this E-EJB.
   * It assigns a new primary key to the Cargo.
   */ 
  public m05CargoPK ejbCreate(m05bCargo cargo) 
    throws CreateException
  {
    try {
      setCar_codigo(getCar_codigo());
    } catch (Exception e) {
      throw new CreateException (e.getMessage());
    }    
    setCar_descripcion(cargo.getCar_descripcion());
    setCar_edescripcion(cargo.getCar_edescripcion());
    return null;      	
  }

  public void ejbPostCreate(m05bCargo cargo) 
  {
  }

 
}
