package m05bBancoEJB;

import javax.ejb.CreateException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.RemoveException;

import m05bBD.m05bBanco;

/**
 * This class is the Bean Implementation for the Entity EJB <tt>M05BancoEB</tt>.
 *
 * @see     m05.exe.Banco
 * @see     m05.exe.M05BancoEB
 * @see     m05.exe.M05BancoEBPK
 * @see     m05.exe.M05BancoEBHome
 * @author <a href="mailto:paco.gomez@terra.com">Paco Gomez</a>.
 *         Professional J2EE Programming with BEA WebLogic Server, 
 *         by Gomez & Zadrozny, Copyright &#169; 2000. 
 */
abstract public class m05BancoBean implements EntityBean {
  
  private EntityContext ctx;



  /** 
   * This is the primary key.
   * It is the clave, which is the primary key 
   * in table <tt>m0503t00_bancos</tt>.
   */
  
 /* public String ban_cuenta        	= "";
  public String ban_nombre		    = "";
  public String ban_direccion      	= "";
  public String ban_telefono	    = "";*/
  
  /**
   * Returns the Banco information of this E-EJB.
   */    
  public m05bBanco getBanco(){
    m05bBanco banco = new m05bBanco();
    
    banco.setBan_cuenta(getBan_cuenta());
    banco.setBan_nombre(getBan_nombre());
    banco.setBan_direccion(getBan_direccion());
    banco.setBan_telefono(getBan_telefono());

    
    return banco;	
  }    

  /**
   * Sets the Banco information of this E-EJB.
   * @exception P2GException 
   *              If the given Banco <tt>ban_codigo</tt> field 
   *              does not match the primary key that is in the E-EJB.
   */   
  public void setBanco(m05bBanco banco)
    throws Exception{
   
    //the primary key is never modified!!
    if (getBan_cuenta() != banco.getBan_cuenta())
      throw new CreateException ("Cannot modify a different banco");
    setBan_cuenta(banco.getBan_cuenta());
    setBan_nombre(banco.getBan_nombre());
    setBan_direccion(banco.getBan_direccion());
    setBan_telefono(banco.getBan_telefono());
  }   	

  
  abstract public String getBan_cuenta();
  abstract public void setBan_cuenta(String n);
  
  abstract public String getBan_nombre();
  abstract public void setBan_nombre(String n);
    
  abstract public String getBan_direccion();
  abstract public void setBan_direccion(String n);
    
  abstract public String getBan_telefono();
  abstract public void setBan_telefono(String n);
  

  public void ejbActivate() {
  }

  public void ejbPassivate() {
  }

  public void setEntityContext(EntityContext ctx) {
    this.ctx = ctx;
  }

  public void unsetEntityContext() {
    this.ctx = null;
  }

  public void ejbLoad() {
  }
  
  public void ejbStore() {
  }

  public void ejbRemove()
    throws RemoveException
  {
  }

  /**
   * This function initializes the Banco 
   * information of this E-EJB.
   * It assigns a new primary key to the Banco.
   * @see #getNewOrderNum()
   */ 
  public m05BancoPK ejbCreate(m05bBanco banco) 
    throws CreateException
  {
    try {
      setBan_cuenta(getBan_cuenta());
    } catch (Exception e) {
      throw new CreateException (e.getMessage());
    }    
    setBan_nombre(banco.getBan_nombre());
    setBan_direccion(banco.getBan_direccion());
    setBan_telefono(banco.getBan_telefono());
    return null;      	
  }

  public void ejbPostCreate(m05bBanco banco) 
  {
  }

  

}
