package m05bAvisoEJB;

import javax.ejb.CreateException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.RemoveException;

import m05bBD.m05bAviso;


/**
 * This class is the Bean Implementation for the Entity EJB <tt>M05AvisoEB</tt>.
 *
 * @see     m05.exe.Aviso
 * @see     m05.exe.M05AvisoEB
 * @see     m05.exe.M05AvisoEBPK
 * @see     m05.exe.M05AvisoEBHome
 * @author <a href="mailto:paco.gomez@terra.com">Paco Gomez</a>.
 *         Professional J2EE Programming with BEA WebLogic Server, 
 *         by Gomez & Zadrozny, Copyright &#169; 2000. 
 */
abstract public class m05AvisoBean implements EntityBean {
  
  private EntityContext ctx;

 
  /** 
   * This is the primary key.
   * It is the clave, which is the primary key 
   * in table <tt>m0502t00</tt>.
   */
  /*public String avi_matricula   = "0";
  public String avi_texto     = "";*/
  
  /**
   * Returns the Aviso information of this E-EJB.
   */    
  public m05bAviso getAviso(){
    m05bAviso aviso = new m05bAviso();
    
    aviso.setAvi_matricula(getAvi_matricula());
    aviso.setAvi_texto(getAvi_texto());
    /*Iker: Euskera*/
    aviso.setAvi_textoEusk(getAvi_textoEusk());
    
    aviso.setAvi_vehiculo(getAvi_vehiculo());
    aviso.setAvi_asignacion(getAvi_asignacion());
    aviso.setAvi_ot(getAvi_ot());

    
    return aviso;	
  }    

  /**
   * Sets the Aviso information of this E-EJB.
   * @exception P2GException 
   *              If the given Aviso <tt>avi_matricula</tt> field 
   *              does not match the primary key that is in the E-EJB.
   */   
  public void setAviso(m05bAviso aviso)
    throws Exception{
   
    //the primary key is never modified!!
    if (getAvi_matricula() != aviso.getAvi_matricula())
      throw new CreateException ("Cannot modify a different aviso");
      
    setAvi_texto(aviso.getAvi_texto());
    
  }   	
  
  abstract public String getAvi_matricula();
  abstract public void setAvi_matricula(String n);
  
  abstract public String getAvi_texto();
  abstract public void setAvi_texto(String n);
  /*Iker: Euskera*/
  abstract public String getAvi_textoEusk();
  abstract public void setAvi_textoEusk(String n);
  /**/
  
  abstract public String getAvi_vehiculo();
  abstract public void setAvi_vehiculo(String n);

  abstract public String getAvi_asignacion();
  abstract public void setAvi_asignacion(String n);

  abstract public String getAvi_ot();
  abstract public void setAvi_ot(String n);


  public void ejbActivate() {
  }

  public void ejbPassivate() {
  }

  public void setEntityContext(EntityContext ctx) {
    this.ctx = ctx;
  }

  public void unsetEntityContext() {
    this.ctx = null;
  }

  public void ejbLoad() {
  }
  
  public void ejbStore() {
  }

  public void ejbRemove()
    throws RemoveException
  {
  }

  /**
   * This function initializes the Aviso 
   * information of this E-EJB.
   * It assigns a new primary key to the Aviso.
   */ 
  public m05AvisoPK ejbCreate(m05bAviso aviso) 
    throws CreateException
  {
    try {
      setAvi_matricula(getAvi_matricula());
    } catch (Exception e) {
      throw new CreateException (e.getMessage());
    }    
    setAvi_texto(aviso.getAvi_texto());
    setAvi_vehiculo(aviso.getAvi_vehiculo());
    setAvi_asignacion(aviso.getAvi_asignacion());
    setAvi_ot(aviso.getAvi_ot());
    /*Iker Euskera*/
    setAvi_textoEusk(aviso.getAvi_textoEusk());
    return null;      	
  }

  public void ejbPostCreate(m05bAviso aviso) 
  {
  }

 
}