package m05bAmortizacionesEJB;

import javax.ejb.CreateException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.RemoveException;

import m05bBD.m05bAmortizaciones;

/**
 * This class is the Bean Implementation for the Entity EJB <tt>M05AmortizacionesEB</tt>.
 *
 * @see     m05.exe.Amortizaciones
 * @see     m05.exe.M05AmortizacionesEB
 * @see     m05.exe.M05AmortizacionesEBPK
 * @see     m05.exe.M05AmortizacionesEBHome
 */


abstract public class m05AmortizacionesBean implements EntityBean{

  private EntityContext ctx;

  
  /**
   * Returns the Amortizaciones information of this E-EJB.
   */
  public m05bAmortizaciones getAmortizaciones(){
    m05bAmortizaciones amortizacion = new m05bAmortizaciones();

    amortizacion.setAmo_codigo(getAmo_codigo());
    amortizacion.setAmo_matricula(getAmo_matricula());
    amortizacion.setAmo_fecha(getAmo_fecha());
    amortizacion.setAmo_rango(getAmo_rango());
    amortizacion.setAmo_importe(getAmo_importe());
    amortizacion.setAmo_amortiz(getAmo_amortiz());



    return amortizacion;
  }

  /**
   * Sets the Asignacion information of this E-EJB.
   * @exception P2GException
   *              If the given Asignacion <tt>asi_codigo</tt> field
   *              does not match the primary key that is in the E-EJB.
   */
  public void setAmortizaciones(m05bAmortizaciones amortizacion)
    throws Exception{

    //the primary key is never modified!!
    if (getAmo_codigo() != amortizacion.getAmo_codigo())
      throw new CreateException ("Cannot modify a different asignacion");

    setAmo_matricula(amortizacion.getAmo_matricula());
    setAmo_fecha(amortizacion.getAmo_fecha());
    setAmo_amortiz(amortizacion.getAmo_amortiz());
    setAmo_importe(amortizacion.getAmo_importe());
    setAmo_rango(amortizacion.getAmo_rango());
    }

  abstract public String getAmo_codigo();
  abstract public void setAmo_codigo(String n);

  abstract public String getAmo_matricula();
  abstract public void setAmo_matricula(String n);

  abstract public String getAmo_rango();
  abstract public void setAmo_rango(String n);

  abstract public String getAmo_fecha();
  abstract public void setAmo_fecha(String n);

  abstract public String getAmo_importe();
  abstract public void setAmo_importe(String n);

  abstract public String getAmo_amortiz();
  abstract public void setAmo_amortiz(String n);


  public void ejbActivate() {
  }

  public void ejbPassivate() {
  }

  public void setEntityContext(EntityContext ctx) {
    this.ctx = ctx;
  }

  public void unsetEntityContext() {
    this.ctx = null;
  }

  public void ejbLoad() {
  }

  public void ejbStore() {
  }

  public void ejbRemove()
    throws RemoveException
  {
  }

  /**
   * This function initializes the Asignacion
   * information of this E-EJB.
   * It assigns a new primary key to the Asignacion.
   */
  public m05AmortizacionesPK ejbCreate(m05bAmortizaciones amortizacion)
    throws CreateException
  {
    try {
      setAmo_codigo(getAmo_codigo());
    } catch (Exception e) {
      throw new CreateException (e.getMessage());
    }
    setAmo_matricula(amortizacion.getAmo_matricula());
    setAmo_fecha(amortizacion.getAmo_fecha());
    setAmo_importe(amortizacion.getAmo_importe());
    setAmo_rango(amortizacion.getAmo_rango());
    setAmo_amortiz(amortizacion.getAmo_amortiz());
    return null;
  }

  public void ejbPostCreate(m05bAmortizaciones amortizacion)
  {
  }
}
