/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.ColorType;
import org.apache.fop.datatypes.IDReferences;
import org.apache.fop.fo.FOText;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.layout.AccessibilityProps;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.AuralProps;
import org.apache.fop.layout.BackgroundProps;
import org.apache.fop.layout.BlockArea;
import org.apache.fop.layout.BorderAndPadding;
import org.apache.fop.layout.LineArea;
import org.apache.fop.layout.MarginInlineProps;
import org.apache.fop.layout.RelativePositionProps;
import org.apache.fop.layout.TextState;

public class PageNumberCitation
extends FObj {
    float red;
    float green;
    float blue;
    int wrapOption;
    int whiteSpaceCollapse;
    Area area;
    String pageNumber;
    String refId;
    String id;
    TextState ts;

    public PageNumberCitation(FObj parent, PropertyList propertyList, String systemId, int line, int column) {
        super(parent, propertyList, systemId, line, column);
    }

    public String getName() {
        return "fo:page-number-citation";
    }

    public int layout(Area area) throws FOPException {
        if (!(area instanceof BlockArea)) {
            this.log.warn("page-number-citation outside block area");
            return 1;
        }
        IDReferences idReferences = area.getIDReferences();
        this.area = area;
        if (this.marker == -1000) {
            AccessibilityProps mAccProps = this.propMgr.getAccessibilityProps();
            AuralProps mAurProps = this.propMgr.getAuralProps();
            BorderAndPadding bap = this.propMgr.getBorderAndPadding();
            BackgroundProps bProps = this.propMgr.getBackgroundProps();
            MarginInlineProps mProps = this.propMgr.getMarginInlineProps();
            RelativePositionProps mRelProps = this.propMgr.getRelativePositionProps();
            ColorType c = this.properties.get("color").getColorType();
            this.red = c.red();
            this.green = c.green();
            this.blue = c.blue();
            this.wrapOption = this.properties.get("wrap-option").getEnum();
            this.whiteSpaceCollapse = this.properties.get("white-space-collapse").getEnum();
            this.refId = this.properties.get("ref-id").getString();
            if (this.refId.equals("")) {
                throw new FOPException("page-number-citation must contain \"ref-id\"", this.systemId, this.line, this.column);
            }
            this.id = this.properties.get("id").getString();
            try {
                idReferences.createID(this.id);
            }
            catch (FOPException e) {
                if (!e.isLocationSet()) {
                    e.setLocation(this.systemId, this.line, this.column);
                }
                throw e;
            }
            this.ts = new TextState();
            this.marker = 0;
        }
        if (this.marker == 0) {
            idReferences.configureID(this.id, area);
        }
        this.pageNumber = idReferences.getPageNumber(this.refId);
        if (this.pageNumber != null) {
            this.marker = FOText.addText((BlockArea)area, this.propMgr.getFontState(area.getFontInfo()), this.red, this.green, this.blue, this.wrapOption, null, this.whiteSpaceCollapse, this.pageNumber.toCharArray(), 0, this.pageNumber.length(), this.ts, 9);
        } else {
            BlockArea blockArea = (BlockArea)area;
            LineArea la = blockArea.getCurrentLineArea();
            if (la == null) {
                return 2;
            }
            la.changeFont(this.propMgr.getFontState(area.getFontInfo()));
            la.changeColor(this.red, this.green, this.blue);
            la.changeWrapOption(this.wrapOption);
            la.changeWhiteSpaceCollapse(this.whiteSpaceCollapse);
            la.addPageNumberCitation(this.refId, null);
            this.marker = -1;
        }
        if (this.marker == -1) {
            return 1;
        }
        return 2;
    }

    public static FObj.Maker maker() {
        return new Maker();
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj parent, PropertyList propertyList, String systemId, int line, int column) throws FOPException {
            return new PageNumberCitation(parent, propertyList, systemId, line, column);
        }
    }
}

