/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.configuration;

import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.apache.fop.apps.FOPException;
import org.apache.fop.configuration.ConfigurationParser;
import org.apache.fop.messaging.MessageHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class ConfigurationReader {
    private static boolean errorDump = false;
    private InputSource filename;

    public ConfigurationReader(InputSource filename) {
        this.filename = filename;
    }

    public static XMLReader createParser() throws FOPException {
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setNamespaceAware(true);
            XMLReader xmlReader = spf.newSAXParser().getXMLReader();
            MessageHandler.logln("Using " + xmlReader.getClass().getName() + " as SAX2 Parser");
            return xmlReader;
        }
        catch (ParserConfigurationException e) {
            throw new FOPException(e);
        }
        catch (SAXException e) {
            throw new FOPException(e);
        }
    }

    public void dumpError(Exception e) {
        if (errorDump) {
            if (e instanceof SAXException) {
                e.printStackTrace();
                if (((SAXException)e).getException() != null) {
                    ((SAXException)e).getException().printStackTrace();
                }
            } else {
                e.printStackTrace();
            }
        }
    }

    public void setDumpError(boolean dumpError) {
        errorDump = dumpError;
    }

    public void start() throws FOPException {
        XMLReader parser = ConfigurationReader.createParser();
        ConfigurationParser configurationParser = new ConfigurationParser();
        parser.setContentHandler(configurationParser);
        try {
            parser.parse(this.filename);
        }
        catch (SAXException e) {
            if (e.getException() instanceof FOPException) {
                throw (FOPException)e.getException();
            }
            throw new FOPException(e);
        }
        catch (IOException e) {
            throw new FOPException(e);
        }
    }
}

