/*
 * Decompiled with CFR 0.152.
 */
package com.izenpe.tsp;

import com.izenpe.AlgoritmosHash;
import com.izenpe.gestioncontenedorseguro.GestionContenedorSeguro;
import com.izenpe.miscelanea.Miscelanea;
import com.izenpe.tsp.HttpTSPRequest;
import iaik.asn1.ASN1;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.cms.CMSException;
import iaik.pkcs.PKCSParsingException;
import iaik.pkcs.pkcs7.SignedDataStream;
import iaik.security.provider.IAIK;
import iaik.tsa.asn1.TSTInfo;
import iaik.tsa.asn1.TimeStampReq;
import iaik.tsa.asn1.TimeStampResp;
import iaik.tsa.request.TimeStampClientManager;
import iaik.utils.ASN1InputStream;
import iaik.utils.StreamCopier;
import iaik.x509.X509Certificate;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.NoRouteToHostException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.Provider;
import java.security.Security;

public class TSP {
    public TSP() {
        IAIK iaik = new IAIK();
        Security.insertProviderAt((Provider)iaik, 2);
        IAIK.addAsProvider((boolean)false);
    }

    public int requestTSP(byte[] dataIn, ByteArrayOutputStream responseTST, ByteArrayOutputStream stampingDataOut, ByteArrayOutputStream snTSTOut, String path, String pass) {
        int error = 0;
        try {
            GestionContenedorSeguro cs = GestionContenedorSeguro.getInstance(path, pass);
            ByteArrayOutputStream uri = new ByteArrayOutputStream();
            int errortsa = cs.getURLTSA(uri);
            if (errortsa != 0) {
                int n = error = errortsa;
                return n;
            }
            URL url = new URL(uri.toString("ISO8859_1"));
            ((OutputStream)uri).close();
            TimeStampClientManager tscm = new TimeStampClientManager();
            TimeStampReq time_stamp_req = tscm.generateTimeStampReq(dataIn);
            time_stamp_req.setCertReq(true);
            HttpTSPRequest con = new HttpTSPRequest(url);
            ByteArrayOutputStream errorsalida = new ByteArrayOutputStream();
            error = con.postRequest(time_stamp_req, path, pass, errorsalida);
            if (error != 0) {
                int n = error;
                return n;
            }
            Integer errorint = new Integer(errorsalida.toString("ISO8859_1"));
            if (errorint != 0) {
                int n = error = errorint.intValue();
                return n;
            }
            TimeStampResp response = con.getTSPResponse();
            responseTST.write(response.getEncoded());
            ((OutputStream)responseTST).close();
            snTSTOut.write(con.getSerialNumber().toString().getBytes("ISO8859_1"));
            ((OutputStream)snTSTOut).close();
            stampingDataOut.write(con.getGenTime().getBytes("ISO8859_1"));
            ((OutputStream)stampingDataOut).close();
        }
        catch (UnknownHostException uhe) {
            error = 1101;
            int n = 1101;
            return n;
        }
        catch (NoRouteToHostException nrthe) {
            error = 1101;
            int n = 1101;
            return n;
        }
        catch (MalformedURLException mue) {
            error = 1102;
            int n = 1102;
            return n;
        }
        catch (CMSException cmse) {
            error = 1103;
            int n = 1103;
            return n;
        }
        catch (IOException ioe) {
            error = 1104;
            int n = 1104;
            return n;
        }
        return error;
    }

    public int requestTSP_NoVerify(byte[] dataIn, ByteArrayOutputStream responseTST, ByteArrayOutputStream stampingDataOut, ByteArrayOutputStream snTSTOut, String path, String pass) {
        int error = 0;
        try {
            GestionContenedorSeguro cs = GestionContenedorSeguro.getInstance(path, pass);
            ByteArrayOutputStream uri = new ByteArrayOutputStream();
            int errortsa = cs.getURLTSA(uri);
            if (errortsa != 0) {
                int n = error = errortsa;
                return n;
            }
            URL url = new URL(uri.toString("ISO8859_1"));
            ((OutputStream)uri).close();
            TimeStampClientManager tscm = new TimeStampClientManager();
            TimeStampReq time_stamp_req = tscm.generateTimeStampReq(dataIn);
            time_stamp_req.setCertReq(true);
            HttpTSPRequest con = new HttpTSPRequest(url);
            ByteArrayOutputStream errorsalida = new ByteArrayOutputStream();
            error = con.postRequest_NoVerify(time_stamp_req, path, pass, errorsalida);
            if (error != 0) {
                int n = error;
                return n;
            }
            Integer errorint = new Integer(errorsalida.toString("ISO8859_1"));
            if (errorint != 0) {
                int n = error = errorint.intValue();
                return n;
            }
            TimeStampResp response = con.getTSPResponse();
            responseTST.write(response.getEncoded());
            ((OutputStream)responseTST).close();
            snTSTOut.write(con.getSerialNumber().toString().getBytes("ISO8859_1"));
            ((OutputStream)snTSTOut).close();
            stampingDataOut.write(con.getGenTime().getBytes("ISO8859_1"));
            ((OutputStream)stampingDataOut).close();
        }
        catch (UnknownHostException uhe) {
            error = 1101;
            int n = 1101;
            return n;
        }
        catch (NoRouteToHostException nrthe) {
            error = 1101;
            int n = 1101;
            return n;
        }
        catch (MalformedURLException mue) {
            error = 1102;
            int n = 1102;
            return n;
        }
        catch (CMSException cmse) {
            error = 1103;
            int n = 1103;
            return n;
        }
        catch (IOException ioe) {
            error = 1104;
            int n = 1104;
            return n;
        }
        return error;
    }

    public int parseTSP(byte[] responseTST, ByteArrayOutputStream dataHashOut, ByteArrayOutputStream hashAlgorithmOut, ByteArrayOutputStream stampingDateOut, ByteArrayOutputStream snTSTOut) {
        int error = 0;
        try {
            ByteArrayInputStream baistemp = new ByteArrayInputStream(responseTST);
            ASN1 respuestaasn1 = new ASN1((InputStream)new ASN1InputStream((InputStream)baistemp));
            TimeStampResp response = new TimeStampResp(respuestaasn1.toASN1Object());
            ASN1 timeStampans1 = new ASN1((InputStream)new ASN1InputStream(response.getTimeStampToken().getContentInputStream()));
            ByteArrayInputStream bais = new ByteArrayInputStream(timeStampans1.toByteArray());
            SignedDataStream p7 = new SignedDataStream((InputStream)bais);
            ByteArrayOutputStream certstream = new ByteArrayOutputStream();
            InputStream is = p7.getInputStream();
            StreamCopier scp = new StreamCopier(is, (OutputStream)certstream);
            scp.copyStream();
            ByteArrayInputStream certificado = new ByteArrayInputStream(certstream.toByteArray());
            X509Certificate[] cadenacert = p7.getCertificates();
            ASN1InputStream tstinfostream = new ASN1InputStream((InputStream)certificado);
            ASN1Object tstinfoasn1 = DerCoder.decode((InputStream)tstinfostream);
            TSTInfo tstinfo = new TSTInfo(tstinfoasn1);
            dataHashOut.write(tstinfo.getMessageImprint().getHashedMessage());
            ((OutputStream)dataHashOut).close();
            hashAlgorithmOut.write(tstinfo.getMessageImprint().getHashAlgorithm().getName().getBytes("ISO8859_1"));
            ((OutputStream)hashAlgorithmOut).close();
            BigInteger serialnumber = tstinfo.getSerialNumber();
            stampingDateOut.write(tstinfo.getGenTime().getBytes("ISO8859_1"));
            ((OutputStream)stampingDateOut).close();
            snTSTOut.write(serialnumber.toString().getBytes("ISO8859_1"));
            ((OutputStream)snTSTOut).close();
        }
        catch (CodingException ce) {
            error = 1105;
            int n = 1105;
            return n;
        }
        catch (PKCSParsingException pkcspe) {
            error = 1106;
            int n = 1106;
            return n;
        }
        catch (IOException ioe) {
            error = 1104;
            int n = 1104;
            return n;
        }
        return error;
    }

    public int checkTSPResponse(byte[] tspresponse, byte[] pkcs7, ByteArrayOutputStream dateOut) {
        int error = 0;
        ByteArrayOutputStream dataHash = new ByteArrayOutputStream();
        ByteArrayOutputStream algHash = new ByteArrayOutputStream();
        ByteArrayOutputStream dateSalida = new ByteArrayOutputStream();
        ByteArrayOutputStream snOut = new ByteArrayOutputStream();
        error = this.parseTSP(tspresponse, dataHash, algHash, dateSalida, snOut);
        if (error != 0) {
            return error;
        }
        AlgoritmosHash alg = new AlgoritmosHash();
        alg.setAlgorithm(algHash.toString().trim());
        Miscelanea funciones = new Miscelanea();
        ByteArrayOutputStream hashSalida = new ByteArrayOutputStream();
        error = funciones.newHash(alg.getAlgorithm(), pkcs7, hashSalida);
        if (error != 0) {
            return error;
        }
        ByteArrayOutputStream dataHashB64 = new ByteArrayOutputStream();
        error = funciones.binBase64(dataHash.toByteArray(), dataHashB64);
        if (error != 0) {
            return error;
        }
        try {
            dateOut.write(dateSalida.toByteArray());
            ((OutputStream)hashSalida).close();
            ((OutputStream)dataHash).close();
            ((OutputStream)algHash).close();
            ((OutputStream)dateSalida).close();
            ((OutputStream)snOut).close();
            if (!hashSalida.toString("ISO8859_1").equals(dataHashB64.toString("ISO8859_1"))) {
                error = 1122;
                int n = 1122;
                return n;
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return error;
    }
}

