/*
 * Decompiled with CFR 0.152.
 */
package com.izenpe.miscelanea;

import iaik.asn1.ASN1;
import iaik.asn1.CodingException;
import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.PKCSException;
import iaik.pkcs.PKCSParsingException;
import iaik.pkcs.pkcs7.ContentInfoStream;
import iaik.pkcs.pkcs7.ContentStream;
import iaik.pkcs.pkcs7.EncryptedDataStream;
import iaik.security.provider.IAIK;
import iaik.utils.Base64OutputStream;
import iaik.utils.StreamCopier;
import iaik.utils.Util;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.spec.InvalidParameterSpecException;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.StringTokenizer;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSearchResults;

public class Miscelanea {
    public Miscelanea() {
        IAIK iaik = new IAIK();
        Security.insertProviderAt((Provider)iaik, 2);
        IAIK.addAsProvider((boolean)false);
    }

    private int getIntRandom() {
        Random numRandom = new Random();
        int numAleatorio = numRandom.nextInt();
        if (numAleatorio < 0) {
            numAleatorio *= -1;
        }
        return numAleatorio;
    }

    public int newRandom(int longitud, ByteArrayOutputStream baos) {
        int error = 0;
        try {
            Random numRandom = new Random();
            byte[] bytes = new byte[longitud];
            numRandom.nextBytes(bytes);
            baos.write(bytes);
            ((OutputStream)baos).close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return error;
    }

    public int newHash(AlgorithmID algorithm, byte[] datosEntrada, ByteArrayOutputStream hashSalida, boolean vectorInicializacion) {
        int error = 0;
        try {
            if (vectorInicializacion) {
                byte[] temp = null;
                MessageDigest sha = MessageDigest.getInstance(algorithm.getImplementationName());
                sha.update(datosEntrada);
                temp = sha.digest(datosEntrada);
                ByteArrayOutputStream dos = new ByteArrayOutputStream();
                Base64OutputStream base64 = new Base64OutputStream((OutputStream)dos);
                base64.write(temp);
                String cadena = dos.toString("ISO8859_1");
                hashSalida.write(cadena.getBytes("ISO8859_1"));
                ((OutputStream)dos).close();
                base64.close();
                ((OutputStream)hashSalida).close();
            } else {
                MessageDigest sha = MessageDigest.getInstance(algorithm.getImplementationName());
                sha.update(datosEntrada);
                byte[] temp = sha.digest();
                this.binBase64(temp, hashSalida);
                ((OutputStream)hashSalida).close();
            }
        }
        catch (NoSuchAlgorithmException nsae) {
            error = 801;
            int n = 801;
            return n;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return error;
    }

    public int newHash(AlgorithmID algorithm, byte[] datosEntrada, ByteArrayOutputStream hashSalida) {
        int error = 0;
        try {
            MessageDigest sha = MessageDigest.getInstance(algorithm.getImplementationName());
            sha.update(datosEntrada);
            byte[] temp = sha.digest();
            this.binBase64(temp, hashSalida);
            ((OutputStream)hashSalida).close();
        }
        catch (NoSuchAlgorithmException nsae) {
            error = 801;
            int n = 801;
            return n;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return error;
    }

    public int binBase64(byte[] derBinIn, ByteArrayOutputStream base64Out) {
        int error = 0;
        try {
            base64Out.write(Util.Base64Encode((byte[])derBinIn));
            ((OutputStream)base64Out).close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return error;
    }

    public int binBase64_NoLineBreaks(byte[] derBinIn, ByteArrayOutputStream base64Out) {
        int error = 0;
        try {
            int sixbit;
            char[] alphabet = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
            char[] output = new char[((derBinIn.length - 1) / 3 + 1) * 4];
            int outIndex = 0;
            int i = 0;
            while (i + 3 <= derBinIn.length) {
                sixbit = (derBinIn[i] & 0xFC) >> 2;
                output[outIndex++] = alphabet[sixbit];
                sixbit = ((derBinIn[i] & 3) << 4) + ((derBinIn[i + 1] & 0xF0) >> 4);
                output[outIndex++] = alphabet[sixbit];
                sixbit = ((derBinIn[i + 1] & 0xF) << 2) + ((derBinIn[i + 2] & 0xC0) >> 6);
                output[outIndex++] = alphabet[sixbit];
                sixbit = derBinIn[i + 2] & 0x3F;
                output[outIndex++] = alphabet[sixbit];
                i += 3;
            }
            if (derBinIn.length - i == 2) {
                sixbit = (derBinIn[i] & 0xFC) >> 2;
                output[outIndex++] = alphabet[sixbit];
                sixbit = ((derBinIn[i] & 3) << 4) + ((derBinIn[i + 1] & 0xF0) >> 4);
                output[outIndex++] = alphabet[sixbit];
                sixbit = (derBinIn[i + 1] & 0xF) << 2;
                output[outIndex++] = alphabet[sixbit];
                output[outIndex++] = 61;
            } else if (derBinIn.length - i == 1) {
                sixbit = (derBinIn[i] & 0xFC) >> 2;
                output[outIndex++] = alphabet[sixbit];
                sixbit = (derBinIn[i] & 3) << 4;
                output[outIndex++] = alphabet[sixbit];
                output[outIndex++] = 61;
                output[outIndex++] = 61;
            }
            String enBase64 = new String(output);
            base64Out.write(enBase64.getBytes("ISO8859_1"));
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return error;
    }

    public int base64Bin(String base64In, ByteArrayOutputStream binOut) {
        int error = 0;
        try {
            binOut.write(Util.Base64Decode((byte[])base64In.getBytes("ISO8859_1")));
            ((OutputStream)binOut).close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return error;
    }

    public int encodeDER(byte[] dataIn, ByteArrayOutputStream os) {
        int error = 0;
        try {
            ASN1 asn1 = new ASN1(dataIn);
            byte[] der_array = asn1.toByteArray();
            byte[] pem_array = Util.Base64Encode((byte[])der_array);
            os.write(der_array);
            ((OutputStream)os).close();
        }
        catch (CodingException ce) {
            error = 804;
            int n = 804;
            return n;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return error;
    }

    public int symetricEncryp(byte[] dataIn, AlgorithmID algorithm, byte[] key, ByteArrayOutputStream p7) {
        int error = 0;
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(dataIn);
            EncryptedDataStream pkcs7 = new EncryptedDataStream((InputStream)is, key.length);
            char[] pass = new char[key.length];
            for (int i = 0; i < key.length; ++i) {
                pass[i] = (char)key[i];
            }
            pkcs7.setupCipher(algorithm, pass);
            ContentInfoStream cis = new ContentInfoStream((ContentStream)pkcs7);
            cis.writeTo((OutputStream)p7);
            ((InputStream)is).close();
            ((OutputStream)p7).close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (PKCSParsingException pkcspe) {
            error = 806;
            int n = 806;
            return n;
        }
        catch (NoSuchAlgorithmException nsae) {
            error = 802;
            int n = 802;
            return n;
        }
        catch (InvalidKeyException ike) {
            error = 805;
            int n = 805;
            return n;
        }
        catch (PKCSException pkcse) {
            error = 807;
            int n = 807;
            return n;
        }
        return error;
    }

    public int symetricDecryp(byte[] p7, byte[] key, ByteArrayOutputStream dataOut) {
        int error = 0;
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(p7);
            ContentInfoStream cis = new ContentInfoStream((InputStream)is);
            EncryptedDataStream pkcs7 = (EncryptedDataStream)cis.getContent();
            char[] pass = new char[key.length];
            for (int i = 0; i < key.length; ++i) {
                pass[i] = (char)key[i];
            }
            pkcs7.setupCipher(pass);
            InputStream descripcion = pkcs7.getInputStream();
            StreamCopier sc = new StreamCopier(descripcion, (OutputStream)dataOut);
            sc.copyStream();
            ((InputStream)is).close();
            descripcion.close();
            ((OutputStream)dataOut).close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (PKCSParsingException pkcspe) {
            error = 806;
            int n = 806;
            return n;
        }
        catch (NoSuchAlgorithmException nsae) {
            error = 803;
            int n = 803;
            return n;
        }
        catch (InvalidKeyException ie) {
            error = 805;
            int n = 805;
            return n;
        }
        catch (InvalidAlgorithmParameterException iae) {
            error = 808;
            int n = 808;
            return n;
        }
        catch (InvalidParameterSpecException iase) {
            error = 809;
            int n = 809;
            return n;
        }
        catch (PKCSException pkcse) {
            error = 807;
            int n = 807;
            return n;
        }
        error = 0;
        return 0;
    }

    public int parseString(String cadena, char separador, int indice, ByteArrayOutputStream palabraOut) {
        int error = 0;
        try {
            String separador2 = "".concat(String.valueOf(String.valueOf(separador)));
            StringTokenizer cadenaSep = new StringTokenizer(cadena, separador2);
            String palabra = null;
            for (int i = 1; i <= indice; ++i) {
                palabra = cadenaSep.nextToken();
            }
            palabraOut.write(palabra.getBytes("ISO8859_1"));
            ((OutputStream)palabraOut).close();
        }
        catch (IOException ioe) {
            System.err.println(ioe);
        }
        catch (NullPointerException npe) {
            error = 811;
            int n = 811;
            return n;
        }
        catch (NoSuchElementException nsee) {
            error = 812;
            int n = 812;
            return n;
        }
        return error;
    }

    public int getRandomSymetricKey(int longitud, ByteArrayOutputStream keyOut) {
        int error = 0;
        try {
            ByteArrayOutputStream temp = new ByteArrayOutputStream();
            this.newRandom(longitud, temp);
            this.binBase64(temp.toByteArray(), keyOut);
            ((OutputStream)temp).close();
            ((OutputStream)keyOut).close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return error;
    }

    public int extractUserCertificate_LDAP(String servidor, int puerto, String login, String ldappass, String rama, String nombreat, String valorat, ByteArrayOutputStream certOut) {
        int error = 0;
        try {
            boolean encontrado = false;
            LDAPConnection ldap = new LDAPConnection();
            ldap.connect(servidor, puerto, login, ldappass);
            String ramanombre = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(rama))).append("=").append(nombreat)));
            LDAPSearchResults res = ldap.search(valorat, 2, ramanombre, null, false);
            while (res.hasMoreElements()) {
                LDAPEntry findEntry = null;
                findEntry = res.next();
                LDAPAttributeSet findAttrs = findEntry.getAttributeSet();
                Enumeration enumAttrs = findAttrs.getAttributes();
                LDAPAttribute anAttr = null;
                while (enumAttrs.hasMoreElements()) {
                    anAttr = (LDAPAttribute)enumAttrs.nextElement();
                    String attrName = anAttr.getName();
                    if (!attrName.equalsIgnoreCase("userCertificate;binary")) continue;
                    Enumeration enumVals = anAttr.getByteValues();
                    while (enumVals.hasMoreElements()) {
                        encontrado = true;
                        byte[] aVal = (byte[])enumVals.nextElement();
                        certOut.write(aVal);
                    }
                }
            }
            ((OutputStream)certOut).close();
            ldap.disconnect();
            if (!encontrado) {
                error = 51;
                int n = 51;
                return n;
            }
        }
        catch (LDAPException ldape) {
            error = 36;
            int n = 36;
            return n;
        }
        catch (IOException ioe) {
            error = 56;
            int n = 56;
            return n;
        }
        return error;
    }
}

