/*
 * Decompiled with CFR 0.152.
 */
package com.izenpe.gestioncontenedorseguro;

import com.izenpe.AlgoritmosAsimetricos;
import com.izenpe.AlgoritmosHash;
import com.izenpe.autenticacionfuerte.AutenticacionFuerte;
import com.izenpe.gestioncontenedorseguro.ConstantesContenedorSeguro;
import com.izenpe.miscelanea.Miscelanea;
import iaik.asn1.CodingException;
import iaik.asn1.ObjectID;
import iaik.asn1.structures.AccessDescription;
import iaik.asn1.structures.AlgorithmID;
import iaik.asn1.structures.Attribute;
import iaik.asn1.structures.AttributeValue;
import iaik.asn1.structures.GeneralName;
import iaik.asn1.structures.Name;
import iaik.pkcs.PKCS7CertList;
import iaik.pkcs.PKCSException;
import iaik.pkcs.PKCSParsingException;
import iaik.pkcs.pkcs10.CertificateRequest;
import iaik.pkcs.pkcs12.CertificateBag;
import iaik.pkcs.pkcs12.KeyBag;
import iaik.pkcs.pkcs12.PKCS12;
import iaik.pkcs.pkcs9.ExtensionRequest;
import iaik.security.provider.IAIK;
import iaik.utils.StreamCopier;
import iaik.x509.V3Extension;
import iaik.x509.X509CRL;
import iaik.x509.X509Certificate;
import iaik.x509.X509ExtensionException;
import iaik.x509.X509ExtensionInitException;
import iaik.x509.extensions.AuthorityKeyIdentifier;
import iaik.x509.extensions.BasicConstraints;
import iaik.x509.extensions.ExtendedKeyUsage;
import iaik.x509.extensions.KeyUsage;
import iaik.x509.extensions.SubjectInfoAccess;
import iaik.x509.extensions.SubjectKeyIdentifier;
import iaik.x509.extensions.netscape.NetscapeCertType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import java.util.Vector;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSearchResults;

public class GestionContenedorSeguro
implements ConstantesContenedorSeguro {
    static String pathContenedorSeguro = "";
    static String passContenedorSeguro = "";
    KeyStore repositorio = null;
    private static GestionContenedorSeguro instancia = null;

    protected GestionContenedorSeguro(String path, String pass) {
        try {
            if (!pass.equals("")) {
                IAIK iaik = new IAIK();
                Security.insertProviderAt((Provider)iaik, 2);
                IAIK.addAsProvider((boolean)false);
                this.repositorio = KeyStore.getInstance("IAIKKeyStore", "IAIK");
                pathContenedorSeguro = path.trim();
                if (!pathContenedorSeguro.endsWith(File.separator)) {
                    pathContenedorSeguro = String.valueOf(String.valueOf(pathContenedorSeguro)).concat(String.valueOf(String.valueOf(File.separator)));
                }
                passContenedorSeguro = pass.trim();
                int errorOpen = this.openKeyStore();
                if (errorOpen != 0) {
                    this.repositorio = null;
                }
            } else {
                this.repositorio = null;
            }
        }
        catch (NoSuchProviderException nspe) {
            nspe.printStackTrace();
        }
        catch (KeyStoreException kse) {
            kse.printStackTrace();
        }
    }

    public static GestionContenedorSeguro getInstance(String path, String pass) {
        boolean error = false;
        IAIK iaik = new IAIK();
        Security.insertProviderAt((Provider)iaik, 2);
        IAIK.addAsProvider((boolean)false);
        if (instancia == null || !path.equals(pathContenedorSeguro) || !pass.equals(passContenedorSeguro)) {
            instancia = new GestionContenedorSeguro(path, pass);
        }
        return instancia;
    }

    private synchronized void recordKeyStore() {
        try {
            FileOutputStream grabarks = new FileOutputStream(String.valueOf(String.valueOf(pathContenedorSeguro)).concat("jce.keystore"));
            this.repositorio.store(grabarks, passContenedorSeguro.toCharArray());
            grabarks.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (CertificateException ce) {
            ce.printStackTrace();
        }
        catch (NoSuchAlgorithmException nsae) {
            nsae.printStackTrace();
        }
        catch (KeyStoreException kse) {
            kse.printStackTrace();
        }
    }

    public int newKeyStore() {
        int error = 0;
        try {
            File ficheroks = new File(String.valueOf(String.valueOf(pathContenedorSeguro)).concat("jce.keystore"));
            File dir = new File(pathContenedorSeguro);
            if (dir.isDirectory()) {
                if (!ficheroks.exists()) {
                    this.repositorio.load(null, null);
                    this.recordKeyStore();
                    int n = error;
                    return n;
                }
                error = 1;
                int n = 1;
                return n;
            }
            if (dir.mkdir()) {
                if (!ficheroks.exists()) {
                    this.repositorio.load(null, null);
                    this.recordKeyStore();
                    int n = error;
                    return n;
                }
                error = 1;
                int n = 1;
                return n;
            }
            error = 46;
            int n = 46;
            return n;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (CertificateException ce) {
            error = 6;
            int n = 6;
            return n;
        }
        catch (NoSuchAlgorithmException nsae) {
            error = 27;
            int n = 27;
            return n;
        }
        return error;
    }

    public int deleteKeyStore() {
        int error = 0;
        try {
            File ficheroks = new File(String.valueOf(String.valueOf(pathContenedorSeguro)).concat("jce.keystore"));
            FileInputStream is = new FileInputStream(ficheroks);
            this.repositorio.load(is, passContenedorSeguro.toCharArray());
            is.close();
            if (!ficheroks.exists()) {
                error = 4;
                int n = 4;
                return n;
            }
            ficheroks.delete();
            if (ficheroks.exists()) {
                error = 44;
                int n = 44;
                return n;
            }
            int n = error;
            return n;
        }
        catch (IOException ioe) {
            error = 29;
            int n = 29;
            return n;
        }
        catch (CertificateException ce) {
            error = 28;
            int n = 28;
            return n;
        }
        catch (NoSuchAlgorithmException nsae) {
            error = 27;
            int n = 27;
            return n;
        }
    }

    public int insertCertificateFile(String pathFichero, String nombreFichero) {
        int error = 0;
        try {
            File fcertificado;
            if (!pathFichero.endsWith(File.separator)) {
                pathFichero = String.valueOf(String.valueOf(pathFichero)).concat(String.valueOf(String.valueOf(File.separator)));
            }
            if (!(fcertificado = new File(String.valueOf(String.valueOf(pathFichero)).concat(String.valueOf(String.valueOf(nombreFichero))))).exists()) {
                error = 5;
            } else {
                X509Certificate x509cert = new X509Certificate((InputStream)new FileInputStream(fcertificado));
                error = this.insertCertificate(x509cert.toByteArray());
            }
        }
        catch (IOException ioe) {
            error = 29;
            int n = 29;
            return n;
        }
        catch (CertificateException ce) {
            error = 16;
            int n = 16;
            return n;
        }
        return error;
    }

    public int insertCACertificateFile(String pathFichero, String nombreFichero) {
        int error = 0;
        try {
            File fcertificado;
            if (!pathFichero.endsWith(File.separator)) {
                pathFichero = String.valueOf(String.valueOf(pathFichero)).concat(String.valueOf(String.valueOf(File.separator)));
            }
            if (!(fcertificado = new File(String.valueOf(String.valueOf(pathFichero)).concat(String.valueOf(String.valueOf(nombreFichero))))).exists()) {
                error = 5;
            } else {
                X509Certificate x509cert = new X509Certificate((InputStream)new FileInputStream(fcertificado));
                error = this.insertRootCertificate(x509cert.toByteArray());
            }
        }
        catch (IOException ioe) {
            error = 29;
            int n = 29;
            return n;
        }
        catch (CertificateException ce) {
            error = 6;
            int n = 6;
            return n;
        }
        return error;
    }

    public int insertCertificate(byte[] certificado) {
        int error = 0;
        try {
            X509Certificate cert = new X509Certificate(certificado);
            SubjectInfoAccess SIA = (SubjectInfoAccess)cert.getExtension(SubjectInfoAccess.oid);
            if (SIA != null) {
                error = 59;
                int n = 59;
                return n;
            }
            String alias = String.valueOf(String.valueOf(cert.getIssuerDN().toString())).concat(String.valueOf(String.valueOf(cert.getSerialNumber().toString())));
            BasicConstraints BC = (BasicConstraints)cert.getExtension(BasicConstraints.oid);
            if (BC != null) {
                error = 60;
                int n = 60;
                return n;
            }
            cert.checkValidity();
            int revocado = this.isRevoked(cert);
            if (revocado == 0) {
                boolean encontrado = false;
                Vector listaAlias = new Vector();
                error = this.getAliasKeyStore(listaAlias);
                for (int i = 0; i < listaAlias.size(); ++i) {
                    if (!alias.equals((String)listaAlias.elementAt(i))) continue;
                    encontrado = true;
                    break;
                }
                if (!encontrado) {
                    this.repositorio.setCertificateEntry(alias, (Certificate)cert);
                } else {
                    error = 14;
                }
            } else {
                int n = error = revocado;
                return n;
            }
            this.recordKeyStore();
        }
        catch (CertificateExpiredException cee) {
            error = 32;
            int n = 32;
            return n;
        }
        catch (CertificateNotYetValidException cnyve) {
            error = 33;
            int n = 33;
            return n;
        }
        catch (CertificateException ce) {
            error = 6;
            int n = 6;
            return n;
        }
        catch (X509ExtensionInitException xeie) {
            error = 30;
            int n = 30;
            return n;
        }
        catch (KeyStoreException kse) {
            error = 12;
            int n = 12;
            return n;
        }
        return error;
    }

    public int insertCert_PKCS7(byte[] p7) {
        int error = 0;
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(p7);
            PKCS7CertList plist = new PKCS7CertList((InputStream)bais);
            X509Certificate[] x = plist.getCertificateList();
            for (int i = 0; i < x.length; ++i) {
                X509Certificate x509cert = x[i];
                error = this.insertCertificate(x509cert.toByteArray());
            }
            this.recordKeyStore();
            ((InputStream)bais).close();
        }
        catch (IOException ioe) {
            error = 29;
            int n = 29;
            return n;
        }
        catch (PKCSParsingException ppe) {
            error = 31;
            int n = 31;
            return n;
        }
        return error;
    }

    public int insertRoot_PKCS7(byte[] p7) {
        int error = 0;
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(p7);
            PKCS7CertList plist = new PKCS7CertList((InputStream)bais);
            X509Certificate[] x = plist.getCertificateList();
            for (int i = 0; i < x.length; ++i) {
                X509Certificate x509cert = x[i];
                BasicConstraints BC = (BasicConstraints)x509cert.getExtension(BasicConstraints.oid);
                if (BC == null) {
                    error = 52;
                    int n = 52;
                    return n;
                }
                if (!BC.ca()) continue;
                error = this.insertRootCertificate(x509cert.toByteArray());
            }
            this.recordKeyStore();
            ((InputStream)bais).close();
        }
        catch (IOException ioe) {
            error = 29;
            int n = 29;
            return n;
        }
        catch (X509ExtensionInitException xeie) {
            error = 30;
            int n = 30;
            return n;
        }
        catch (PKCSParsingException ppe) {
            error = 31;
            int n = 31;
            return n;
        }
        return error;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int insertRootCertificate(byte[] certificado) {
        int error = 0;
        try {
            X509Certificate cert = new X509Certificate(certificado);
            String alias = String.valueOf(String.valueOf(cert.getIssuerDN().toString())).concat(String.valueOf(String.valueOf(cert.getSerialNumber().toString())));
            BasicConstraints BC = (BasicConstraints)cert.getExtension(BasicConstraints.oid);
            if (BC == null) {
                return 52;
            }
            if (BC.ca()) {
                cert.checkValidity();
                int revocado = this.isRevoked(cert);
                error = revocado;
                if (revocado != 0) return error;
                boolean encontrado = false;
                Vector listaAlias = new Vector();
                error = this.getAliasKeyStore(listaAlias);
                for (int i = 0; i < listaAlias.size(); ++i) {
                    if (!alias.equals((String)listaAlias.elementAt(i))) continue;
                    encontrado = true;
                    break;
                }
                if (!encontrado) {
                    this.repositorio.setCertificateEntry(alias, (Certificate)cert);
                } else {
                    error = 14;
                }
            } else {
                error = 8;
            }
            this.recordKeyStore();
            return error;
        }
        catch (CertificateExpiredException cee) {
            return 32;
        }
        catch (CertificateNotYetValidException cnyve) {
            return 33;
        }
        catch (CertificateException ce) {
            return 6;
        }
        catch (KeyStoreException kse) {
            return 12;
        }
        catch (X509ExtensionInitException xeie) {
            return 30;
        }
    }

    public int insertKeyEntry(byte[] p12In, String passP12) {
        int error = 0;
        try {
            ByteArrayInputStream pkcs12 = new ByteArrayInputStream(p12In);
            PKCS12 p12 = new PKCS12((InputStream)pkcs12);
            p12.decrypt(passP12.toCharArray());
            CertificateBag[] certBag = new CertificateBag[1];
            certBag = p12.getCertificateBags();
            X509Certificate cert = new X509Certificate();
            cert = certBag[0].getCertificate();
            String alias = String.valueOf(String.valueOf(cert.getIssuerDN().toString())).concat(String.valueOf(String.valueOf(cert.getSerialNumber().toString())));
            X509Certificate[] chain = new X509Certificate[]{cert};
            cert.checkValidity();
            int revocado = this.isRevoked(cert);
            if (revocado == 0) {
                boolean encontrado = false;
                Vector listaAlias = new Vector();
                error = this.getAliasKeyStore(listaAlias);
                for (int i = 0; i < listaAlias.size(); ++i) {
                    if (!alias.equals((String)listaAlias.elementAt(i))) continue;
                    encontrado = true;
                    break;
                }
                if (!encontrado) {
                    KeyBag kB = p12.getKeyBag();
                    PrivateKey pKey = kB.getPrivateKey();
                    this.repositorio.setKeyEntry(alias, pKey, passContenedorSeguro.toCharArray(), (Certificate[])chain);
                } else {
                    error = 14;
                }
            } else {
                int n = error = revocado;
                return n;
            }
            ((InputStream)pkcs12).close();
            this.recordKeyStore();
        }
        catch (KeyStoreException kse) {
            error = 12;
            int n = 12;
            return n;
        }
        catch (PKCSException pkcse) {
            error = 47;
            int n = 47;
            return n;
        }
        catch (CertificateExpiredException cee) {
            error = 32;
            int n = 32;
            return n;
        }
        catch (CertificateNotYetValidException cnyve) {
            error = 33;
            int n = 33;
            return n;
        }
        catch (FileNotFoundException fnfe) {
            error = 40;
            int n = 40;
            return n;
        }
        catch (IOException ioe) {
            error = 29;
            int n = 29;
            return n;
        }
        return error;
    }

    public int enumCertsCS(Vector issuerOut, Vector snOut) {
        int error = 0;
        Vector aliases = new Vector();
        error = this.getAliasKeyStore(aliases);
        if (aliases.size() == 0) {
            error = 10;
            return 10;
        }
        try {
            for (int i = 0; i < aliases.size(); ++i) {
                ByteArrayOutputStream certOut = new ByteArrayOutputStream();
                int getcert = this.getCertificate((String)aliases.elementAt(i), certOut);
                if (getcert != 0) {
                    int n = error = getcert;
                    return n;
                }
                X509Certificate x509cert = new X509Certificate(certOut.toByteArray());
                if (x509cert != null) {
                    Principal is = x509cert.getIssuerDN();
                    BigInteger sn = x509cert.getSerialNumber();
                    issuerOut.addElement(is);
                    snOut.addElement(sn);
                }
                ((OutputStream)certOut).close();
            }
        }
        catch (CertificateException ce) {
            error = 42;
            int n = 42;
            return n;
        }
        catch (IOException ce) {
            error = 56;
            int n = 56;
            return n;
        }
        return error;
    }

    public synchronized int openKeyStore() {
        int error = 0;
        if (this.repositorio == null) {
            error = 11;
            return 11;
        }
        try {
            File ficheroks = new File(String.valueOf(String.valueOf(pathContenedorSeguro)).concat("jce.keystore"));
            if (!ficheroks.exists()) {
                error = 2;
                int n = 2;
                return n;
            }
            FileInputStream ff = new FileInputStream(ficheroks);
            this.repositorio.load(new FileInputStream(ficheroks), passContenedorSeguro.toCharArray());
            ff.close();
        }
        catch (NullPointerException npe) {
            npe.printStackTrace();
        }
        catch (CertificateException ce) {
            error = 28;
            int n = 28;
            return n;
        }
        catch (NoSuchAlgorithmException nsae) {
            error = 27;
            int n = 27;
            return n;
        }
        catch (IOException ioe) {
            error = 11;
            int n = 11;
            return n;
        }
        return error;
    }

    public int getCertCS(String issuerIn, String snIn, ByteArrayOutputStream certOut) {
        int error = 0;
        try {
            boolean encontrado = false;
            Vector aliases = new Vector();
            error = this.getAliasKeyStore(aliases);
            for (int i = 0; i < aliases.size(); ++i) {
                ByteArrayOutputStream certSalida = new ByteArrayOutputStream();
                int getcert = this.getCertificate((String)aliases.elementAt(i), certSalida);
                if (getcert != 0) {
                    int n = error = getcert;
                    return n;
                }
                X509Certificate x509cert = new X509Certificate(certSalida.toByteArray());
                if (x509cert.getIssuerDN().toString().equals(issuerIn) && x509cert.getSerialNumber().toString().equals(snIn)) {
                    certOut.write(x509cert.toByteArray());
                    encontrado = true;
                    break;
                }
                ((OutputStream)certSalida).close();
            }
            if (!encontrado) {
                error = 13;
                int n = 13;
                return n;
            }
        }
        catch (IOException ioe) {
            error = 56;
            int n = 56;
            return n;
        }
        catch (CertificateException ce) {
            error = 42;
            int n = 42;
            return n;
        }
        return error;
    }

    public int getCAFromKeyStore(String issuerIn, byte[] authorityIn, ByteArrayOutputStream certOut) {
        int error = 0;
        try {
            boolean encontrado = false;
            Vector aliases = new Vector();
            error = this.getAliasKeyStore(aliases);
            for (int i = 0; i < aliases.size(); ++i) {
                ByteArrayOutputStream certSalida = new ByteArrayOutputStream();
                int getcert = this.getCertificate((String)aliases.elementAt(i), certSalida);
                if (getcert != 0) {
                    int n = error = getcert;
                    return n;
                }
                X509Certificate x509cert = new X509Certificate(certSalida.toByteArray());
                BasicConstraints BC = (BasicConstraints)x509cert.getExtension(BasicConstraints.oid);
                if (BC != null && BC.ca()) {
                    if (authorityIn != null) {
                        SubjectKeyIdentifier ski = new SubjectKeyIdentifier();
                        SubjectKeyIdentifier ski2 = new SubjectKeyIdentifier(authorityIn);
                        ski = (SubjectKeyIdentifier)x509cert.getExtension(SubjectKeyIdentifier.oid);
                        byte[] subjectKI = ski.get();
                        if (x509cert.getSubjectDN().toString().equals(issuerIn) && ski.toString().equals(ski2.toString())) {
                            encontrado = true;
                            certOut.write(x509cert.toByteArray());
                            break;
                        }
                    } else if (x509cert.getSubjectDN().toString().equals(issuerIn)) {
                        certOut.write(x509cert.toByteArray());
                        encontrado = true;
                        certOut.write(x509cert.toByteArray());
                        break;
                    }
                }
                ((OutputStream)certSalida).close();
            }
            if (!encontrado) {
                error = 13;
                int n = 13;
                return n;
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (CertificateException ce) {
            error = 42;
            int n = 42;
            return n;
        }
        catch (X509ExtensionInitException xeie) {
            error = 30;
            int n = 30;
            return n;
        }
        return error;
    }

    public int isRevoked(X509Certificate x509cert) {
        int error = 0;
        try {
            if (!x509cert.getIssuerDN().equals(x509cert.getSubjectDN())) {
                String issuer = x509cert.getIssuerDN().toString();
                AuthorityKeyIdentifier aki = new AuthorityKeyIdentifier();
                aki = (AuthorityKeyIdentifier)x509cert.getExtension(AuthorityKeyIdentifier.oid);
                ByteArrayOutputStream cacert = new ByteArrayOutputStream();
                if (aki != null) {
                    byte[] authority = aki.getKeyIdentifier();
                    error = this.getCAFromKeyStore(issuer, authority, cacert);
                } else {
                    error = this.getCAFromKeyStore(issuer, null, cacert);
                }
                if (cacert.size() > 0) {
                    X509Certificate CACert = new X509Certificate(cacert.toByteArray());
                    ByteArrayOutputStream hash = new ByteArrayOutputStream();
                    ByteArrayOutputStream nuevohash64 = new ByteArrayOutputStream();
                    String nombrecrl = String.valueOf(String.valueOf(CACert.getIssuerDN().toString())).concat(String.valueOf(String.valueOf(CACert.getSerialNumber().toString())));
                    Miscelanea funciones = new Miscelanea();
                    AlgoritmosHash alg = new AlgoritmosHash();
                    alg.setAlgorithm("sha");
                    funciones.newHash(alg.getAlgorithm(), nombrecrl.getBytes("ISO8859_1"), hash, true);
                    funciones.binBase64(hash.toByteArray(), nuevohash64);
                    String htemporal = nuevohash64.toString("ISO8859_1");
                    htemporal = htemporal.replace('/', '_');
                    String pathcompleto = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(pathContenedorSeguro))).append(htemporal).append(".crl")));
                    File crl = new File(pathcompleto);
                    FileInputStream is = new FileInputStream(crl);
                    X509CRL x509crl = new X509CRL((InputStream)is);
                    x509crl.verify(CACert.getPublicKey());
                    if (!CACert.getIssuerDN().equals(CACert.getSubjectDN())) {
                        Vector listacerts = new Vector();
                        int erroropen = this.getCertificateChain(x509crl, listacerts);
                        if (erroropen != 0) {
                            int n = error = erroropen;
                            return n;
                        }
                        X509Certificate[] cadena = new X509Certificate[listacerts.size()];
                        for (int i = 0; i < listacerts.size(); ++i) {
                            cadena[i] = (X509Certificate)listacerts.elementAt(i);
                        }
                        if (cadena != null) {
                            error = this.comprobar(cadena);
                        }
                    }
                    ((OutputStream)cacert).close();
                    is.close();
                    ((OutputStream)hash).close();
                    ((OutputStream)nuevohash64).close();
                    if (x509crl.isRevoked((Certificate)x509cert)) {
                        error = 21;
                        int n = 21;
                        return n;
                    }
                    error = 0;
                    int n = 0;
                    return n;
                }
                error = 22;
                int n = 22;
                return n;
            }
        }
        catch (X509ExtensionInitException xeie) {
            error = 30;
            int n = 30;
            return n;
        }
        catch (SignatureException se) {
            error = 34;
            int n = 34;
            return n;
        }
        catch (InvalidKeyException ike) {
            error = 35;
            int n = 35;
            return n;
        }
        catch (NoSuchAlgorithmException nsae) {
            error = 27;
            int n = 27;
            return n;
        }
        catch (NoSuchProviderException nspe) {
            error = 25;
            int n = 25;
            return n;
        }
        catch (CertificateException ce) {
            error = 28;
            int n = 28;
            return n;
        }
        catch (CRLException crle) {
            error = 37;
            int n = 37;
            return n;
        }
        catch (FileNotFoundException fnfe) {
            error = 23;
            int n = 23;
            return n;
        }
        catch (IOException ioe) {
            error = 56;
            int n = 56;
            return n;
        }
        return error;
    }

    public int comprobar(X509Certificate[] certChain) {
        int error = 0;
        for (int z = 0; z < certChain.length; ++z) {
            error = this.isRevoked(certChain[z]);
            if (error == 0) continue;
            return error;
        }
        if (error == 0) {
            for (int i = 0; i < certChain.length; ++i) {
                try {
                    certChain[i].checkValidity();
                }
                catch (CertificateExpiredException cee) {
                    error = 32;
                }
                catch (CertificateNotYetValidException cnyve) {
                    error = 33;
                }
                try {
                    if (i < certChain.length - 1) {
                        certChain[i].verify(certChain[i + 1].getPublicKey());
                        continue;
                    }
                    certChain[i].verify();
                    continue;
                }
                catch (CertificateException ce) {
                    error = 28;
                    int n = 28;
                    return n;
                }
                catch (NoSuchAlgorithmException nsae) {
                    error = 27;
                    int n = 27;
                    return n;
                }
                catch (InvalidKeyException ike) {
                    error = 35;
                    int n = 35;
                    return n;
                }
                catch (NoSuchProviderException nspe) {
                    error = 25;
                    int n = 25;
                    return n;
                }
                catch (SignatureException se) {
                    error = 34;
                    int n = 34;
                    return n;
                }
            }
        }
        return error;
    }

    public PrivateKey getPrivateKeyFromKeyStore(String issuerIn, String snIn) {
        PrivateKey pk = null;
        boolean encontrado = false;
        String comparar = String.valueOf(String.valueOf(issuerIn)).concat(String.valueOf(String.valueOf(snIn)));
        Vector aliases = new Vector();
        this.getAliasKeyStore(aliases);
        for (int i = 0; i < aliases.size(); ++i) {
            if (!comparar.equals((String)aliases.elementAt(i))) continue;
            pk = this.getPrivateKey(comparar);
            encontrado = true;
            break;
        }
        if (!encontrado) {
            pk = null;
        }
        return pk;
    }

    public int removeCertCS(String issuerIn, String snIn) {
        int error = 0;
        try {
            boolean encontrado = false;
            String alias = String.valueOf(String.valueOf(issuerIn)).concat(String.valueOf(String.valueOf(snIn)));
            Vector aliases = new Vector();
            error = this.getAliasKeyStore(aliases);
            for (int i = 0; i < aliases.size(); ++i) {
                if (!alias.equals((String)aliases.elementAt(i))) continue;
                encontrado = true;
                break;
            }
            if (encontrado) {
                this.repositorio.deleteEntry(alias);
            }
            this.recordKeyStore();
            if (!encontrado) {
                error = 13;
                int n = 13;
                return n;
            }
        }
        catch (KeyStoreException kse) {
            error = 12;
            int n = 12;
            return n;
        }
        return error;
    }

    public synchronized int changePasswordCS(String oldPassword, String newPassword) {
        int error = 0;
        try {
            FileInputStream fic;
            File ficheroks2;
            if (oldPassword.equals(passContenedorSeguro)) {
                ficheroks2 = new File(String.valueOf(String.valueOf(pathContenedorSeguro)).concat("jce.keystore"));
                fic = new FileInputStream(ficheroks2);
                if (!ficheroks2.exists()) {
                    error = 2;
                    int n = 2;
                    return n;
                }
                this.repositorio.load(fic, passContenedorSeguro.toCharArray());
                Enumeration<String> conjunto = this.repositorio.aliases();
                while (conjunto.hasMoreElements()) {
                    String aliasTemporal = conjunto.nextElement();
                    if (!this.repositorio.isKeyEntry(aliasTemporal)) continue;
                    Key keyTemporal = this.repositorio.getKey(aliasTemporal, oldPassword.toCharArray());
                    X509Certificate certTemporal = (X509Certificate)this.repositorio.getCertificate(aliasTemporal);
                    X509Certificate[] cadenaTemporal = new X509Certificate[]{certTemporal};
                    this.repositorio.deleteEntry(aliasTemporal);
                    this.repositorio.setKeyEntry(aliasTemporal, keyTemporal, newPassword.toCharArray(), (Certificate[])cadenaTemporal);
                }
            } else {
                error = 11;
                int ficheroks2 = 11;
                return ficheroks2;
            }
            fic.close();
            FileOutputStream foc = new FileOutputStream(ficheroks2);
            this.repositorio.store(foc, newPassword.toCharArray());
            foc.close();
        }
        catch (IOException ioe) {
            error = 15;
            int n = 15;
            return n;
        }
        catch (UnrecoverableKeyException urke) {
            error = 41;
            int n = 41;
            return n;
        }
        catch (NullPointerException ioe) {
            error = 11;
            int n = 11;
            return n;
        }
        catch (CertificateException ce) {
            error = 28;
            int n = 28;
            return n;
        }
        catch (NoSuchAlgorithmException nsae) {
            error = 27;
            int n = 27;
            return n;
        }
        catch (KeyStoreException kse) {
            error = 12;
            int n = 12;
            return n;
        }
        return error;
    }

    public int importPKCS12(byte[] pkcs12, String passIn, PrivateKey pkOut, ByteArrayOutputStream certOut) {
        int error = 0;
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(pkcs12);
            PKCS12 p12 = new PKCS12((InputStream)bis);
            p12.decrypt(passIn.toCharArray());
            CertificateBag[] certBag = p12.getCertificateBags();
            CertificateBag cert = certBag[0];
            X509Certificate x509cert = new X509Certificate();
            x509cert = cert.getCertificate();
            KeyBag kB = p12.getKeyBag();
            pkOut = kB.getPrivateKey();
            certOut.write(x509cert.toByteArray());
            ((InputStream)bis).close();
            ((OutputStream)certOut).close();
        }
        catch (IOException ioe) {
            error = 56;
            int n = 56;
            return n;
        }
        catch (PKCSParsingException ppe) {
            error = 31;
            int n = 31;
            return n;
        }
        catch (PKCSException pe) {
            error = 38;
            int n = 38;
            return n;
        }
        return error;
    }

    private int exportPKCS12(byte[] certIn, PrivateKey pkeyin, String pass12, ByteArrayOutputStream pfx) {
        int error = 0;
        try {
            ByteArrayInputStream cert = new ByteArrayInputStream(certIn);
            KeyBag keyBag = new KeyBag(pkeyin);
            CertificateBag[] certBags = new CertificateBag[1];
            X509Certificate x509cert = new X509Certificate(certIn);
            certBags[0] = new CertificateBag(x509cert);
            PKCS12 p12 = new PKCS12(keyBag, certBags);
            p12.encrypt(pass12.toCharArray());
            p12.writeTo((OutputStream)pfx);
            ((InputStream)cert).close();
        }
        catch (CertificateException ce) {
            error = 28;
            int n = 28;
            return n;
        }
        catch (IOException ioe) {
            error = 56;
            int n = 56;
            return n;
        }
        catch (PKCSParsingException ppe) {
            error = 31;
            int n = 31;
            return n;
        }
        catch (PKCSException pe) {
            error = 38;
            int n = 38;
            return n;
        }
        return error;
    }

    public int exportPKCS12(String issuerIn, String snIn, String pass12, ByteArrayOutputStream pfx) {
        int error = 0;
        try {
            PrivateKey pkeyin = this.getPrivateKeyFromKeyStore(issuerIn, snIn);
            if (pkeyin == null) {
                error = 19;
                int n = 19;
                return n;
            }
            ByteArrayOutputStream cert = new ByteArrayOutputStream();
            int errorcert = this.getCertCS(issuerIn, snIn, cert);
            if (error != 0) {
                int n = error = errorcert;
                return n;
            }
            X509Certificate x509cert = new X509Certificate(cert.toByteArray());
            KeyBag keyBag = new KeyBag(pkeyin);
            CertificateBag[] certBags = new CertificateBag[]{new CertificateBag(x509cert)};
            PKCS12 p12 = new PKCS12(keyBag, certBags);
            p12.encrypt(pass12.toCharArray());
            p12.writeTo((OutputStream)pfx);
            ((OutputStream)pfx).close();
            ((OutputStream)cert).close();
        }
        catch (CertificateException ce) {
            error = 28;
            int n = 28;
            return n;
        }
        catch (IOException ioe) {
            error = 56;
            int n = 56;
            return n;
        }
        catch (PKCSParsingException ppe) {
            error = 31;
            int n = 31;
            return n;
        }
        catch (PKCSException pe) {
            error = 38;
            int n = 38;
            return n;
        }
        return error;
    }

    public int extractCert_LDAP(String servidor, int puerto, String login, String ldappass, String rama, String nombreat, String valorat, ByteArrayOutputStream certOut) {
        int error = 0;
        try {
            boolean encontrado = false;
            LDAPConnection ldap = new LDAPConnection();
            ldap.connect(servidor, puerto, login, ldappass);
            String ramanombre = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(rama))).append("=").append(nombreat)));
            LDAPSearchResults res = ldap.search(valorat, 2, ramanombre, null, false);
            while (res.hasMoreElements()) {
                LDAPEntry findEntry = null;
                findEntry = res.next();
                LDAPAttributeSet findAttrs = findEntry.getAttributeSet();
                Enumeration enumAttrs = findAttrs.getAttributes();
                LDAPAttribute anAttr = null;
                while (enumAttrs.hasMoreElements()) {
                    anAttr = (LDAPAttribute)enumAttrs.nextElement();
                    String attrName = anAttr.getName();
                    if (!attrName.equalsIgnoreCase("cACertificate")) continue;
                    Enumeration enumVals = anAttr.getByteValues();
                    while (enumVals.hasMoreElements()) {
                        encontrado = true;
                        byte[] aVal = (byte[])enumVals.nextElement();
                        certOut.write(aVal);
                    }
                }
            }
            ((OutputStream)certOut).close();
            ldap.disconnect();
            if (!encontrado) {
                error = 51;
                int n = 51;
                return n;
            }
        }
        catch (LDAPException ldape) {
            error = 36;
            int n = 36;
            return n;
        }
        catch (IOException ioe) {
            error = 56;
            int n = 56;
            return n;
        }
        return error;
    }

    public int extractCrl_LDAP(String servidor, int puerto, String login, String ldappass, String rama, String nombreat, String valorat, ByteArrayOutputStream crlOut) {
        int error = 0;
        try {
            boolean encontrado = false;
            LDAPConnection ldap = new LDAPConnection();
            ldap.connect(servidor, puerto, login, ldappass);
            String ramanombre = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(rama))).append("=").append(nombreat)));
            LDAPSearchResults res = ldap.search(valorat, 2, ramanombre, null, false);
            while (res.hasMoreElements()) {
                LDAPEntry findEntry = null;
                findEntry = res.next();
                LDAPAttributeSet findAttrs = findEntry.getAttributeSet();
                Enumeration enumAttrs = findAttrs.getAttributes();
                LDAPAttribute anAttr = null;
                while (enumAttrs.hasMoreElements()) {
                    anAttr = (LDAPAttribute)enumAttrs.nextElement();
                    String attrName = anAttr.getName();
                    if (!attrName.equalsIgnoreCase("certificateRevocationList")) continue;
                    Enumeration enumVals = anAttr.getByteValues();
                    while (enumVals.hasMoreElements()) {
                        encontrado = true;
                        byte[] aVal = (byte[])enumVals.nextElement();
                        crlOut.write(aVal);
                    }
                }
            }
            ((OutputStream)crlOut).close();
            ldap.disconnect();
            if (!encontrado) {
                error = 51;
                int n = 51;
                return n;
            }
        }
        catch (LDAPException ldape) {
            error = 36;
            int n = 36;
            return n;
        }
        catch (IOException ioe) {
            error = 56;
            int n = 56;
            return n;
        }
        return error;
    }

    public int extractArl_LDAP(String servidor, int puerto, String login, String ldappass, String rama, String nombreat, String valorat, ByteArrayOutputStream crlOut) {
        int error = 0;
        try {
            boolean encontrado = false;
            LDAPConnection ldap = new LDAPConnection();
            ldap.connect(servidor, puerto, login, ldappass);
            String ramanombre = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(rama))).append("=").append(nombreat)));
            LDAPSearchResults res = ldap.search(valorat, 2, ramanombre, null, false);
            while (res.hasMoreElements()) {
                LDAPEntry findEntry = null;
                findEntry = res.next();
                LDAPAttributeSet findAttrs = findEntry.getAttributeSet();
                Enumeration enumAttrs = findAttrs.getAttributes();
                LDAPAttribute anAttr = null;
                while (enumAttrs.hasMoreElements()) {
                    anAttr = (LDAPAttribute)enumAttrs.nextElement();
                    String attrName = anAttr.getName();
                    if (!attrName.equalsIgnoreCase("authorityRevocationList")) continue;
                    Enumeration enumVals = anAttr.getByteValues();
                    while (enumVals.hasMoreElements()) {
                        encontrado = true;
                        byte[] aVal = (byte[])enumVals.nextElement();
                        crlOut.write(aVal);
                    }
                }
            }
            ((OutputStream)crlOut).close();
            ldap.disconnect();
            if (!encontrado) {
                error = 51;
                int n = 51;
                return n;
            }
        }
        catch (LDAPException ldape) {
            error = 36;
            int n = 36;
            return n;
        }
        catch (IOException ioe) {
            error = 56;
            int n = 56;
            return n;
        }
        return error;
    }

    public int extractUserCertificate_LDAP(String servidor, int puerto, String login, String ldappass, String rama, String nombreat, String valorat, ByteArrayOutputStream certOut) {
        int error = 0;
        try {
            boolean encontrado = false;
            LDAPConnection ldap = new LDAPConnection();
            ldap.connect(servidor, puerto, login, ldappass);
            String ramanombre = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(rama))).append("=").append(nombreat)));
            LDAPSearchResults res = ldap.search(valorat, 2, ramanombre, null, false);
            while (res.hasMoreElements()) {
                LDAPEntry findEntry = null;
                findEntry = res.next();
                LDAPAttributeSet findAttrs = findEntry.getAttributeSet();
                Enumeration enumAttrs = findAttrs.getAttributes();
                LDAPAttribute anAttr = null;
                while (enumAttrs.hasMoreElements()) {
                    anAttr = (LDAPAttribute)enumAttrs.nextElement();
                    String attrName = anAttr.getName();
                    if (!attrName.equalsIgnoreCase("userCertificate;binary")) continue;
                    Enumeration enumVals = anAttr.getByteValues();
                    while (enumVals.hasMoreElements()) {
                        encontrado = true;
                        byte[] aVal = (byte[])enumVals.nextElement();
                        certOut.write(aVal);
                    }
                }
            }
            ((OutputStream)certOut).close();
            ldap.disconnect();
            if (!encontrado) {
                error = 51;
                int n = 51;
                return n;
            }
        }
        catch (LDAPException ldape) {
            error = 36;
            int n = 36;
            return n;
        }
        catch (IOException ioe) {
            error = 56;
            int n = 56;
            return n;
        }
        return error;
    }

    public PrivateKey getPrivateKeyFromPKCS12File(String path, String fichero, String pass) {
        PrivateKey pKey = null;
        try {
            if (!path.endsWith(File.separator)) {
                path = String.valueOf(String.valueOf(path)).concat(String.valueOf(String.valueOf(File.separator)));
            }
            File fcertificado = new File(String.valueOf(String.valueOf(path)).concat(String.valueOf(String.valueOf(fichero))));
            FileInputStream ff = new FileInputStream(fcertificado);
            byte[] pkcs12 = new byte[(int)fcertificado.length()];
            ff.read(pkcs12);
            ff.close();
            ByteArrayInputStream bis = new ByteArrayInputStream(pkcs12);
            PKCS12 p12 = new PKCS12((InputStream)bis);
            p12.decrypt(pass.toCharArray());
            CertificateBag[] certBag = p12.getCertificateBags();
            X509Certificate[] certChain = CertificateBag.getCertificates((CertificateBag[])certBag);
            KeyBag kB = p12.getKeyBag();
            pKey = kB.getPrivateKey();
            ((InputStream)bis).close();
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (PKCSParsingException pKCSParsingException) {
        }
        catch (PKCSException pKCSException) {
            // empty catch block
        }
        return pKey;
    }

    public int requestPKCS10(String DNIn, int longitud, ByteArrayOutputStream pkcs10) {
        int error = 0;
        Name subject = new Name();
        String todo = DNIn;
        if (DNIn.indexOf("\u00f1") != -1 || DNIn.indexOf("\u00d1") != -1) {
            error = 61;
            return 61;
        }
        StringTokenizer st = new StringTokenizer(todo, ",");
        String c = "";
        String o = "";
        String ou = "";
        String cn = "";
        String email = "";
        String l = "";
        String prov = "";
        while (st.hasMoreElements()) {
            String valor = "";
            String temporal = (String)st.nextElement();
            String etiqueta = temporal.substring(0, temporal.indexOf("=")).trim();
            if (etiqueta.equalsIgnoreCase("C") || etiqueta.equalsIgnoreCase("Country")) {
                if (temporal.substring(temporal.indexOf("=") + 1, temporal.length()).length() > 2) {
                    error = 62;
                    return 62;
                }
                c = temporal.substring(temporal.indexOf("=") + 1, temporal.length());
            }
            if (etiqueta.equalsIgnoreCase("O") || etiqueta.equalsIgnoreCase("Organization")) {
                o = temporal.substring(temporal.indexOf("=") + 1, temporal.length());
            }
            if (etiqueta.equalsIgnoreCase("OU") || etiqueta.equalsIgnoreCase("Org-unit")) {
                ou = temporal.substring(temporal.indexOf("=") + 1, temporal.length());
            }
            if (etiqueta.equalsIgnoreCase("CN") || etiqueta.equalsIgnoreCase("Common-name")) {
                cn = temporal.substring(temporal.indexOf("=") + 1, temporal.length());
            }
            if (etiqueta.equalsIgnoreCase("EA") || etiqueta.equalsIgnoreCase("Email")) {
                email = temporal.substring(temporal.indexOf("=") + 1, temporal.length());
            }
            if (etiqueta.equalsIgnoreCase("L") || etiqueta.equalsIgnoreCase("Locality")) {
                l = temporal.substring(temporal.indexOf("=") + 1, temporal.length());
            }
            if (!etiqueta.equalsIgnoreCase("ST") && !etiqueta.equalsIgnoreCase("State")) continue;
            prov = temporal.substring(temporal.indexOf("=") + 1, temporal.length());
        }
        if (!c.equals("")) {
            subject.addRDN(ObjectID.country, (Object)c);
        }
        if (!o.equals("")) {
            subject.addRDN(ObjectID.organization, (Object)o);
        }
        if (!ou.equals("")) {
            subject.addRDN(ObjectID.organizationalUnit, (Object)ou);
        }
        if (!cn.equals("")) {
            subject.addRDN(ObjectID.commonName, (Object)cn);
        }
        if (!email.equals("")) {
            subject.addRDN(ObjectID.emailAddress, (Object)email);
        }
        if (!l.equals("")) {
            subject.addRDN(ObjectID.locality, (Object)l);
        }
        if (!prov.equals("")) {
            subject.addRDN(ObjectID.stateOrProvince, (Object)prov);
        }
        try {
            AlgoritmosAsimetricos alg = new AlgoritmosAsimetricos();
            alg.setAlgorithm("RSAENCRYPTION");
            KeyPair kp = this.generateKeyPair(alg.getAlgorithm().getImplementationName(), longitud);
            CertificateRequest request = new CertificateRequest(kp.getPublic(), subject);
            Attribute[] attributes = new Attribute[1];
            KeyUsage keyUsage = new KeyUsage(11);
            ExtendedKeyUsage eku = new ExtendedKeyUsage();
            eku.addKeyPurposeID(ExtendedKeyUsage.clientAuth);
            eku.addKeyPurposeID(ExtendedKeyUsage.emailProtection);
            ExtensionRequest extensionRequest = new ExtensionRequest();
            NetscapeCertType netCert = new NetscapeCertType();
            netCert.setCertType(NetscapeCertType.S_MIME);
            extensionRequest.addExtension((V3Extension)keyUsage);
            extensionRequest.addExtension((V3Extension)eku);
            extensionRequest.addExtension((V3Extension)netCert);
            attributes[0] = new Attribute((AttributeValue)extensionRequest);
            request.setAttributes(attributes);
            request.sign(AlgorithmID.sha1WithRSAEncryption, kp.getPrivate());
            request.writeTo((OutputStream)pkcs10);
            Miscelanea funciones = new Miscelanea();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            AlgoritmosHash alg2 = new AlgoritmosHash();
            alg2.setAlgorithm("SHA");
            funciones.newHash(alg2.getAlgorithm(), kp.getPublic().getEncoded(), baos, true);
            X509Certificate[] chain = new X509Certificate[1];
            X509Certificate x509certp10 = new X509Certificate();
            GregorianCalendar date = new GregorianCalendar();
            x509certp10.setValidNotBefore(date.getTime());
            date.add(1, 1);
            x509certp10.setValidNotAfter(date.getTime());
            x509certp10.setPublicKey(kp.getPublic());
            double doble = Math.random();
            String tempserial = "".concat(String.valueOf(String.valueOf(doble)));
            x509certp10.setSerialNumber(new BigInteger(tempserial.substring(tempserial.indexOf(".") + 1, tempserial.length())));
            Name issuer = new Name();
            issuer.addRDN(ObjectID.caIssuers, (Object)"Petici\u00f3n de PKCS10");
            x509certp10.setIssuerDN((Principal)issuer);
            x509certp10.setSubjectDN((Principal)subject);
            x509certp10.sign(AlgorithmID.sha1WithRSAEncryption, kp.getPrivate());
            chain[0] = x509certp10;
            this.repositorio.setKeyEntry(baos.toString("ISO8859_1"), kp.getPrivate(), passContenedorSeguro.toCharArray(), (Certificate[])chain);
            ((OutputStream)pkcs10).close();
            ((OutputStream)baos).close();
            this.recordKeyStore();
        }
        catch (NoSuchAlgorithmException nsae) {
            error = 27;
            int n = 27;
            return n;
        }
        catch (InvalidKeyException ike) {
            error = 35;
            int n = 35;
            return n;
        }
        catch (CertificateException ce) {
            error = 42;
            int n = 42;
            return n;
        }
        catch (X509ExtensionException xee) {
            error = 30;
            int n = 30;
            return n;
        }
        catch (CodingException ce) {
            error = 39;
            int n = 39;
            return n;
        }
        catch (SignatureException se) {
            error = 34;
            int n = 34;
            return n;
        }
        catch (KeyStoreException kse) {
            error = 26;
            int n = 26;
            return n;
        }
        catch (IOException ioe) {
            error = 56;
            int n = 56;
            return n;
        }
        return error;
    }

    public int insertPKCS10(X509Certificate pkcs10) {
        int error = 0;
        try {
            Miscelanea funciones = new Miscelanea();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            AlgoritmosHash alg2 = new AlgoritmosHash();
            alg2.setAlgorithm("SHA");
            funciones.newHash(alg2.getAlgorithm(), pkcs10.getPublicKey().getEncoded(), baos, true);
            PrivateKey pkey = this.getPrivateKey(baos.toString("ISO8859_1"));
            String aliasp10 = String.valueOf(String.valueOf(pkcs10.getIssuerDN().toString())).concat(String.valueOf(String.valueOf(pkcs10.getSerialNumber().toString())));
            X509Certificate[] cadena = new X509Certificate[]{pkcs10};
            pkcs10.checkValidity();
            error = this.isRevoked(pkcs10);
            if (error != 0) {
                int n = error;
                return n;
            }
            this.repositorio.setKeyEntry(aliasp10, pkey, passContenedorSeguro.toCharArray(), (Certificate[])cadena);
            this.repositorio.deleteEntry(baos.toString("ISO8859_1"));
            ((OutputStream)baos).close();
            this.recordKeyStore();
        }
        catch (CertificateExpiredException cee) {
            error = 32;
            int n = 32;
            return n;
        }
        catch (CertificateNotYetValidException cnyve) {
            error = 33;
            int n = 33;
            return n;
        }
        catch (KeyStoreException kse) {
            error = 26;
            int n = 26;
            return n;
        }
        catch (IOException ioe) {
            error = 56;
            int n = 56;
            return n;
        }
        return error;
    }

    public int getCertificateChain(X509Certificate cert, Vector cadena) {
        int error = 0;
        Vector<X509Certificate> v = new Vector<X509Certificate>();
        boolean encontrado = false;
        try {
            Enumeration<String> aliases = this.repositorio.aliases();
            X509Certificate certAux = new X509Certificate();
            v.addElement(new X509Certificate(cert.toByteArray()));
            while (aliases.hasMoreElements() && !encontrado) {
                String alias = aliases.nextElement();
                certAux = (X509Certificate)this.repositorio.getCertificate(alias);
                if (!certAux.getSubjectDN().equals(cert.getIssuerDN())) continue;
                ByteArrayOutputStream aki = this.getAuthorityKeyIdentifier(cert);
                ByteArrayOutputStream ski = this.getSubjectKeyIdentifier(certAux);
                if (aki != null && ski != null) {
                    if (aki.toString("ISO8859_1").equals(ski.toString("ISO8859_1"))) {
                        v.addElement(new X509Certificate(certAux.toByteArray()));
                        if (certAux.getSubjectDN().equals(certAux.getIssuerDN())) {
                            encontrado = true;
                        } else {
                            aliases = this.repositorio.aliases();
                            cert = certAux;
                        }
                    }
                    ((OutputStream)aki).close();
                } else {
                    v.addElement(new X509Certificate(certAux.toByteArray()));
                    if (certAux.getSubjectDN().equals(certAux.getIssuerDN())) {
                        encontrado = true;
                    } else {
                        aliases = this.repositorio.aliases();
                        cert = certAux;
                    }
                }
                ((OutputStream)ski).close();
            }
        }
        catch (KeyStoreException kse) {
            error = 26;
            int n = 26;
            return n;
        }
        catch (IOException ioe) {
            error = 56;
            int n = 56;
            return n;
        }
        catch (CertificateException ce) {
            error = 28;
            int n = 28;
            return n;
        }
        if (encontrado) {
            for (int j = 0; j < v.size(); ++j) {
                cadena.addElement((X509Certificate)v.elementAt(j));
            }
            return error;
        }
        error = 43;
        return 43;
    }

    public int writeCRL(byte[] crlbyte, String path, String pass) {
        int error = 0;
        try {
            X509CRL x509crl = new X509CRL(crlbyte);
            if (!path.endsWith(File.separator)) {
                path = String.valueOf(String.valueOf(path)).concat(String.valueOf(String.valueOf(File.separator)));
            }
            String issuer = x509crl.getIssuerDN().toString();
            AuthorityKeyIdentifier aki = new AuthorityKeyIdentifier();
            aki = (AuthorityKeyIdentifier)x509crl.getExtension(AuthorityKeyIdentifier.oid);
            ByteArrayOutputStream cacert = new ByteArrayOutputStream();
            if (aki != null) {
                byte[] authority = aki.getKeyIdentifier();
                error = this.getCAFromKeyStore(issuer, authority, cacert);
            } else {
                error = this.getCAFromKeyStore(issuer, null, cacert);
            }
            if (error == 0 && cacert.size() > 0) {
                X509Certificate x509cert = new X509Certificate(cacert.toByteArray());
                x509crl.verify(x509cert.getPublicKey());
                Vector listacerts = new Vector();
                int errorcarga = this.getCertificateChain(x509crl, listacerts);
                X509Certificate[] cadenacrl = new X509Certificate[listacerts.size()];
                for (int i = 0; i < listacerts.size(); ++i) {
                    cadenacrl[i] = (X509Certificate)listacerts.elementAt(i);
                }
                if (errorcarga == 0) {
                    error = this.comprobar(cadenacrl);
                    if (error == 0) {
                        ByteArrayOutputStream hash = new ByteArrayOutputStream();
                        ByteArrayOutputStream nuevohash64 = new ByteArrayOutputStream();
                        String nombrecrl = String.valueOf(String.valueOf(x509cert.getIssuerDN().toString())).concat(String.valueOf(String.valueOf(x509cert.getSerialNumber().toString())));
                        Miscelanea funciones = new Miscelanea();
                        AlgoritmosHash alg = new AlgoritmosHash();
                        alg.setAlgorithm("sha");
                        funciones.newHash(alg.getAlgorithm(), nombrecrl.getBytes("ISO8859_1"), hash, true);
                        funciones.binBase64(hash.toByteArray(), nuevohash64);
                        String htemporal = nuevohash64.toString("ISO8859_1");
                        htemporal = htemporal.replace('/', '_');
                        String pathcompleto = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(path))).append(htemporal).append(".crl")));
                        File crl = new File(pathcompleto);
                        if (crl.exists()) {
                            error = 201;
                        }
                        ((OutputStream)hash).close();
                        ((OutputStream)nuevohash64).close();
                        byte[] tempcrl = crlbyte;
                        ByteArrayInputStream bis = new ByteArrayInputStream(tempcrl);
                        FileOutputStream fi = new FileOutputStream(crl);
                        int linea2 = 0;
                        byte[] temp2 = new byte[4096];
                        while ((linea2 = bis.read(temp2)) != -1) {
                            fi.write(temp2, 0, linea2);
                        }
                        fi.close();
                        ((InputStream)bis).close();
                    } else {
                        error = 48;
                    }
                    ((OutputStream)cacert).close();
                } else {
                    error = 49;
                }
            } else {
                error = 50;
            }
            int n = error;
            return n;
        }
        catch (CRLException crle) {
            error = 37;
            int n = 37;
            return n;
        }
        catch (NoSuchAlgorithmException nsae) {
            error = 27;
            int n = 27;
            return n;
        }
        catch (InvalidKeyException ike) {
            error = 35;
            int n = 35;
            return n;
        }
        catch (X509ExtensionInitException xeie) {
            error = 30;
            int n = 30;
            return n;
        }
        catch (CertificateException ce) {
            error = 28;
            int n = 28;
            return n;
        }
        catch (SignatureException se) {
            error = 34;
            int n = 34;
            return n;
        }
        catch (IOException ioe) {
            error = 29;
            int n = 29;
            return n;
        }
        catch (NoSuchProviderException nspe) {
            error = 25;
            int n = 25;
            return n;
        }
    }

    public int getCertificateChain(X509CRL crl, Vector cadena) {
        int error = 0;
        Vector<X509Certificate> v = new Vector<X509Certificate>();
        boolean encontrado = false;
        boolean encontrado2 = false;
        try {
            Enumeration<String> aliases = this.repositorio.aliases();
            X509Certificate certAux = new X509Certificate();
            while (aliases.hasMoreElements() && !encontrado2) {
                certAux = (X509Certificate)this.repositorio.getCertificate(aliases.nextElement());
                if (!certAux.getSubjectDN().equals(crl.getIssuerDN())) continue;
                ByteArrayOutputStream aki = this.getAuthorityKeyIdentifierCRL(crl);
                ByteArrayOutputStream ski = this.getSubjectKeyIdentifier(certAux);
                if (aki != null && ski != null) {
                    if (aki.toString("ISO8859_1").equals(ski.toString("ISO8859_1"))) {
                        v.addElement(certAux);
                        encontrado2 = true;
                    }
                    ((OutputStream)aki).close();
                } else {
                    v.addElement(certAux);
                    encontrado2 = true;
                }
                ((OutputStream)ski).close();
            }
            X509Certificate cert = certAux;
            aliases = this.repositorio.aliases();
            while (aliases.hasMoreElements() && !encontrado) {
                String alias = aliases.nextElement();
                certAux = (X509Certificate)this.repositorio.getCertificate(alias);
                if (!certAux.getSubjectDN().equals(cert.getIssuerDN())) continue;
                ByteArrayOutputStream aki = this.getAuthorityKeyIdentifier(cert);
                ByteArrayOutputStream ski = this.getSubjectKeyIdentifier(certAux);
                if (aki != null && ski != null) {
                    if (aki.toString("ISO8859_1").equals(ski.toString("ISO8859_1"))) {
                        v.addElement(new X509Certificate(certAux.toByteArray()));
                        if (certAux.getSubjectDN().equals(certAux.getIssuerDN())) {
                            encontrado = true;
                        } else {
                            aliases = this.repositorio.aliases();
                            cert = certAux;
                        }
                    }
                    ((OutputStream)aki).close();
                } else {
                    v.addElement(new X509Certificate(certAux.toByteArray()));
                    if (certAux.getSubjectDN().equals(certAux.getIssuerDN())) {
                        encontrado = true;
                    } else {
                        aliases = this.repositorio.aliases();
                        cert = certAux;
                    }
                }
                ((OutputStream)ski).close();
            }
        }
        catch (KeyStoreException kse) {
            error = 26;
            int n = 26;
            return n;
        }
        catch (IOException ioe) {
            error = 56;
            int n = 56;
            return n;
        }
        catch (CertificateException ce) {
            error = 28;
            int n = 28;
            return n;
        }
        if (encontrado) {
            for (int j = 0; j < v.size(); ++j) {
                cadena.addElement((X509Certificate)v.elementAt(j));
            }
            return error;
        }
        error = 43;
        return 43;
    }

    public int getRoot(X509Certificate cert, ByteArrayOutputStream certOut) {
        int error = 0;
        X509Certificate certificado = new X509Certificate();
        boolean encontrado = false;
        String alias = "";
        try {
            Enumeration<String> aliases = this.repositorio.aliases();
            while (aliases.hasMoreElements() && !encontrado) {
                alias = aliases.nextElement();
                certificado = (X509Certificate)this.repositorio.getCertificate(alias);
                if (!certificado.getSubjectDN().toString().equals(cert.getIssuerDN().toString()) || !certificado.getSubjectDN().equals(certificado.getIssuerDN())) continue;
                ByteArrayOutputStream aki = this.getAuthorityKeyIdentifier(cert);
                ByteArrayOutputStream ski = this.getSubjectKeyIdentifier(certificado);
                if (ski != null && aki != null) {
                    if (aki.toString("ISO8859_1").equals(ski.toString("ISO8859_1"))) {
                        encontrado = true;
                    }
                    ((OutputStream)aki).close();
                } else {
                    encontrado = true;
                }
                ((OutputStream)ski).close();
            }
            if (encontrado) {
                certOut.write(certificado.getEncoded());
                ((OutputStream)certOut).close();
                int n = error;
                return n;
            }
            error = 45;
            int n = 45;
            return n;
        }
        catch (KeyStoreException kse) {
            error = 26;
            int n = 26;
            return n;
        }
        catch (CertificateEncodingException cee) {
            error = 28;
            int n = 28;
            return n;
        }
        catch (IOException ioe) {
            error = 56;
            int n = 56;
            return n;
        }
    }

    public int getPKAlias(String issuer, String serial, ByteArrayOutputStream salida) {
        int error = 0;
        boolean encontrado = false;
        X509Certificate cert = new X509Certificate();
        String alias = "";
        try {
            Enumeration<String> aliases = this.repositorio.aliases();
            while (aliases.hasMoreElements() && !encontrado) {
                alias = aliases.nextElement();
                cert = (X509Certificate)this.repositorio.getCertificate(alias);
                if (!cert.getIssuerDN().toString().equals(issuer) || !cert.getSerialNumber().toString().equals(serial) || !this.repositorio.isKeyEntry(alias)) continue;
                encontrado = true;
            }
            if (encontrado) {
                salida.write(alias.getBytes("ISO8859_1"));
                ((OutputStream)salida).close();
                int n = error;
                return n;
            }
            int n = error;
            return n;
        }
        catch (KeyStoreException kse) {
            error = 26;
            int n = 26;
            return n;
        }
        catch (IOException ioe) {
            error = 56;
            int n = 56;
            return n;
        }
    }

    public int getCertificateAlias(String issuer, String serial, ByteArrayOutputStream salida) {
        int error = 0;
        boolean encontrado = false;
        X509Certificate cert = new X509Certificate();
        String alias = "";
        try {
            Enumeration<String> aliases = this.repositorio.aliases();
            while (aliases.hasMoreElements() && !encontrado) {
                alias = aliases.nextElement();
                cert = (X509Certificate)this.repositorio.getCertificate(alias);
                if (!cert.getIssuerDN().toString().equals(issuer) || !cert.getSerialNumber().toString().equals(serial)) continue;
                encontrado = true;
            }
            if (encontrado) {
                salida.write(alias.getBytes("ISO8859_1"));
                ((OutputStream)salida).close();
                int n = error;
                return n;
            }
            int n = error;
            return n;
        }
        catch (KeyStoreException kse) {
            error = 26;
            int n = 26;
            return n;
        }
        catch (IOException ioe) {
            error = 56;
            int n = 56;
            return n;
        }
    }

    public int removeTSACertificate() {
        int error = 0;
        try {
            if (!this.repositorio.containsAlias("TSACertificate")) {
                error = 58;
                int n = 58;
                return n;
            }
            this.repositorio.deleteEntry("TSACertificate");
            this.recordKeyStore();
        }
        catch (KeyStoreException kse) {
            error = 26;
            int n = 26;
            return n;
        }
        return error;
    }

    public int getURLTSA(ByteArrayOutputStream url) {
        int error = 0;
        try {
            X509Certificate x509tsa = (X509Certificate)this.repositorio.getCertificate("TSACertificate");
            if (x509tsa == null) {
                error = 54;
                int n = 54;
                return n;
            }
            SubjectInfoAccess SIA = (SubjectInfoAccess)x509tsa.getExtension(SubjectInfoAccess.oid);
            if (SIA == null) {
                error = 53;
                int n = 53;
                return n;
            }
            GeneralName gn = null;
            Enumeration accessDs = SIA.getAccessDescriptions();
            AccessDescription ad = null;
            while (accessDs.hasMoreElements()) {
                ad = (AccessDescription)accessDs.nextElement();
                gn = ad.getAccessLocation();
            }
            url.write(gn.getName().toString().getBytes("ISO8859_1"));
        }
        catch (KeyStoreException kse) {
            error = 26;
            int n = 26;
            return n;
        }
        catch (X509ExtensionInitException xeie) {
            error = 30;
            int n = 30;
            return n;
        }
        catch (IOException ioe) {
            error = 29;
            int n = 29;
            return n;
        }
        return error;
    }

    public int insertTSACertificate(byte[] certificado) {
        int error = 0;
        try {
            X509Certificate cert = new X509Certificate(certificado);
            String alias = "TSACertificate";
            SubjectInfoAccess SIA = (SubjectInfoAccess)cert.getExtension(SubjectInfoAccess.oid);
            if (SIA == null) {
                error = 53;
                int n = 53;
                return n;
            }
            cert.checkValidity();
            int revocado = this.isRevoked(cert);
            if (revocado != 0) {
                int n = error = revocado;
                return n;
            }
            boolean encontrado = false;
            Vector listaAlias = new Vector();
            error = this.getAliasKeyStore(listaAlias);
            for (int i = 0; i < listaAlias.size(); ++i) {
                if (!alias.equals((String)listaAlias.elementAt(i))) continue;
                encontrado = true;
                break;
            }
            if (!encontrado) {
                this.repositorio.setCertificateEntry(alias, (Certificate)cert);
            } else {
                error = 14;
            }
            this.recordKeyStore();
        }
        catch (CertificateExpiredException cee) {
            error = 32;
            int n = 32;
            return n;
        }
        catch (CertificateNotYetValidException cnyve) {
            error = 33;
            int n = 33;
            return n;
        }
        catch (CertificateException ce) {
            error = 6;
            int n = 6;
            return n;
        }
        catch (KeyStoreException kse) {
            error = 12;
            int n = 12;
            return n;
        }
        catch (X509ExtensionInitException xeie) {
            error = 30;
            int n = 30;
            return n;
        }
        return error;
    }

    public int mostrarCertificado(byte[] certificado, ByteArrayOutputStream issuer, ByteArrayOutputStream serial, ByteArrayOutputStream subject, ByteArrayOutputStream keyUsage, ByteArrayOutputStream validFromDate, ByteArrayOutputStream expirationDate) {
        int error = 0;
        try {
            X509Certificate cert = new X509Certificate(certificado);
            issuer.write(cert.getIssuerDN().toString().getBytes("ISO8859_1"));
            serial.write(cert.getSerialNumber().toString().getBytes("ISO8859_1"));
            subject.write(cert.getSubjectDN().toString().getBytes("ISO8859_1"));
            validFromDate.write(cert.getNotBefore().toString().getBytes("ISO8859_1"));
            expirationDate.write(cert.getNotAfter().toString().getBytes("ISO8859_1"));
            AutenticacionFuerte af = new AutenticacionFuerte();
            error = af.extractKeyUsage(certificado, keyUsage);
        }
        catch (CertificateException ce) {
            error = 28;
        }
        catch (IOException ioe) {
            error = 29;
        }
        return error;
    }

    public int mostrarCrl(byte[] crl, ByteArrayOutputStream issuer, Vector certsRevoked, ByteArrayOutputStream nextUpdate, ByteArrayOutputStream thisUpdate) {
        int error = 0;
        try {
            X509CRL xCrl = new X509CRL(crl);
            issuer.write(xCrl.getIssuerDN().toString().getBytes("ISO8859_1"));
            nextUpdate.write(xCrl.getNextUpdate().toString().getBytes("ISO8859_1"));
            thisUpdate.write(xCrl.getThisUpdate().toString().getBytes("ISO8859_1"));
            Enumeration enumeration = xCrl.listCertificates();
            while (enumeration.hasMoreElements()) {
                certsRevoked.addElement(enumeration.nextElement());
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (CRLException crle) {
            crle.printStackTrace();
        }
        return error;
    }

    public int extractCrl(String issuer, String sn, ByteArrayOutputStream crlOut) {
        int errorCRL = 0;
        try {
            String nombrecrl = String.valueOf(String.valueOf(issuer)).concat(String.valueOf(String.valueOf(sn)));
            ByteArrayOutputStream hash = new ByteArrayOutputStream();
            ByteArrayOutputStream nuevohash64 = new ByteArrayOutputStream();
            Miscelanea funciones = new Miscelanea();
            AlgoritmosHash alg = new AlgoritmosHash();
            alg.setAlgorithm("sha");
            funciones.newHash(alg.getAlgorithm(), nombrecrl.getBytes("ISO8859_1"), hash, true);
            funciones.binBase64(hash.toByteArray(), nuevohash64);
            String htemporal = nuevohash64.toString("ISO8859_1");
            htemporal = htemporal.replace('/', '_');
            FileInputStream fCrl = new FileInputStream(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(pathContenedorSeguro))).append(htemporal).append(".crl"))));
            X509CRL crl = new X509CRL((InputStream)fCrl);
            crlOut.write(crl.toByteArray());
            ((OutputStream)nuevohash64).close();
            ((OutputStream)crlOut).close();
            ((OutputStream)hash).close();
        }
        catch (FileNotFoundException fnfe) {
            errorCRL = 57;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (CRLException crle) {
            crle.printStackTrace();
        }
        return errorCRL;
    }

    public int listarCAs(Vector issuerOut, Vector snOut) {
        int error = 0;
        try {
            Enumeration<String> aliases = this.repositorio.aliases();
            X509Certificate cert = new X509Certificate();
            while (aliases.hasMoreElements()) {
                cert = (X509Certificate)this.repositorio.getCertificate(aliases.nextElement());
                BasicConstraints bc = (BasicConstraints)cert.getExtension(BasicConstraints.oid);
                if (bc == null || !bc.ca()) continue;
                issuerOut.addElement(cert.getIssuerDN().toString());
                snOut.addElement(cert.getSerialNumber().toString());
            }
        }
        catch (KeyStoreException kse) {
            kse.printStackTrace();
        }
        catch (X509ExtensionInitException xeie) {
            xeie.printStackTrace();
        }
        return error;
    }

    public int getCertIssuer(X509Certificate cert, Vector cadena) {
        int error = 0;
        Vector<X509Certificate> v = new Vector<X509Certificate>();
        boolean encontrado = false;
        try {
            Enumeration<String> aliases = this.repositorio.aliases();
            X509Certificate certAux = new X509Certificate();
            v.addElement(new X509Certificate(cert.toByteArray()));
            while (aliases.hasMoreElements() && !encontrado) {
                String alias = aliases.nextElement();
                certAux = (X509Certificate)this.repositorio.getCertificate(alias);
                if (!certAux.getSubjectDN().equals(cert.getIssuerDN())) continue;
                ByteArrayOutputStream aki = this.getAuthorityKeyIdentifier(cert);
                ByteArrayOutputStream ski = this.getSubjectKeyIdentifier(certAux);
                if (aki != null && ski != null) {
                    if (aki.toString("ISO8859_1").equals(ski.toString("ISO8859_1"))) {
                        v.addElement(new X509Certificate(certAux.toByteArray()));
                        encontrado = true;
                    } else {
                        aliases = this.repositorio.aliases();
                        cert = certAux;
                    }
                    ((OutputStream)aki).close();
                } else {
                    v.addElement(new X509Certificate(certAux.toByteArray()));
                    encontrado = true;
                }
                ((OutputStream)ski).close();
            }
        }
        catch (KeyStoreException kse) {
            error = 26;
            int n = 26;
            return n;
        }
        catch (CertificateException ce) {
            error = 28;
            int n = 28;
            return n;
        }
        catch (IOException ioe) {
            error = 56;
            int n = 56;
            return n;
        }
        if (encontrado) {
            for (int j = 0; j < v.size(); ++j) {
                cadena.addElement((X509Certificate)v.elementAt(j));
            }
            return error;
        }
        error = 55;
        return 55;
    }

    private int getCertificate(String alias, ByteArrayOutputStream certOut) {
        int error = 0;
        X509Certificate x509cert = new X509Certificate();
        try {
            x509cert = (X509Certificate)this.repositorio.getCertificate(alias);
            if (x509cert != null) {
                certOut.write(x509cert.getEncoded());
            }
            ((OutputStream)certOut).close();
        }
        catch (KeyStoreException kse) {
            kse.printStackTrace();
            error = 26;
            int n = 26;
            return n;
        }
        catch (CertificateEncodingException cee) {
            error = 28;
            int n = 28;
            return n;
        }
        catch (IOException ioe) {
            error = 56;
            int n = 56;
            return n;
        }
        return error;
    }

    private PrivateKey getPrivateKey(String alias) {
        PrivateKey pKey = null;
        try {
            pKey = (PrivateKey)this.repositorio.getKey(alias, passContenedorSeguro.toCharArray());
        }
        catch (KeyStoreException keyStoreException) {
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (UnrecoverableKeyException unrecoverableKeyException) {
            // empty catch block
        }
        return pKey;
    }

    private KeyPair generateKeyPair(String algorithm, int bits) {
        KeyPairGenerator generator = null;
        try {
            generator = KeyPairGenerator.getInstance(algorithm, "IAIK");
            generator.initialize(bits);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (NoSuchProviderException noSuchProviderException) {
            // empty catch block
        }
        generator.initialize(bits);
        KeyPair kp = generator.generateKeyPair();
        return kp;
    }

    private int getAliasKeyStore(Vector listaElementos) {
        int error = 0;
        try {
            String elemento = "";
            Enumeration<String> listaCont = this.repositorio.aliases();
            while (listaCont.hasMoreElements()) {
                elemento = listaCont.nextElement();
                listaElementos.addElement(elemento);
            }
        }
        catch (KeyStoreException kse) {
            error = 12;
            int n = 12;
            return n;
        }
        catch (NullPointerException npe) {
            error = 6;
            int n = 6;
            return n;
        }
        return error;
    }

    private ByteArrayOutputStream getAuthorityKeyIdentifier(X509Certificate cert) {
        AuthorityKeyIdentifier aki = new AuthorityKeyIdentifier();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        boolean encontrado = false;
        try {
            aki = (AuthorityKeyIdentifier)cert.getExtension(AuthorityKeyIdentifier.oid);
            if (aki != null) {
                SubjectKeyIdentifier ski = new SubjectKeyIdentifier(aki.getKeyIdentifier());
                ByteArrayInputStream bais = new ByteArrayInputStream(ski.toString().getBytes("ISO8859_1"));
                StreamCopier sc = new StreamCopier((InputStream)bais, (OutputStream)baos);
                sc.copyStream();
                encontrado = true;
                ((InputStream)bais).close();
            }
            ((OutputStream)baos).close();
        }
        catch (X509ExtensionInitException ei) {
            ByteArrayOutputStream byteArrayOutputStream = null;
            return byteArrayOutputStream;
        }
        catch (IOException ioe) {
            ByteArrayOutputStream byteArrayOutputStream = null;
            return byteArrayOutputStream;
        }
        if (encontrado) {
            return baos;
        }
        return null;
    }

    private ByteArrayOutputStream getAuthorityKeyIdentifierCRL(X509CRL cert) {
        AuthorityKeyIdentifier aki = new AuthorityKeyIdentifier();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        boolean encontrado = false;
        try {
            aki = (AuthorityKeyIdentifier)cert.getExtension(AuthorityKeyIdentifier.oid);
            if (aki != null) {
                SubjectKeyIdentifier ski = new SubjectKeyIdentifier(aki.getKeyIdentifier());
                ByteArrayInputStream bais = new ByteArrayInputStream(ski.toString().getBytes("ISO8859_1"));
                StreamCopier sc = new StreamCopier((InputStream)bais, (OutputStream)baos);
                sc.copyStream();
                encontrado = true;
                ((InputStream)bais).close();
            }
            ((OutputStream)baos).close();
        }
        catch (X509ExtensionInitException ei) {
            ByteArrayOutputStream byteArrayOutputStream = null;
            return byteArrayOutputStream;
        }
        catch (IOException ioe) {
            ByteArrayOutputStream byteArrayOutputStream = null;
            return byteArrayOutputStream;
        }
        if (encontrado) {
            return baos;
        }
        return null;
    }

    private ByteArrayOutputStream getSubjectKeyIdentifier(X509Certificate cert) {
        SubjectKeyIdentifier ski = new SubjectKeyIdentifier();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        boolean encontrado = false;
        try {
            ski = (SubjectKeyIdentifier)cert.getExtension(SubjectKeyIdentifier.oid);
            if (ski != null) {
                ByteArrayInputStream bais = new ByteArrayInputStream(ski.toString().getBytes("ISO8859_1"));
                StreamCopier sc = new StreamCopier((InputStream)bais, (OutputStream)baos);
                sc.copyStream();
                encontrado = true;
                ((InputStream)bais).close();
            }
            ((OutputStream)baos).close();
        }
        catch (X509ExtensionInitException ei) {
            System.err.println((Object)ei);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        if (encontrado) {
            return baos;
        }
        return null;
    }

    public boolean existKeyStore() {
        boolean existe = false;
        File ficheroks = new File(String.valueOf(String.valueOf(pathContenedorSeguro)).concat("jce.keystore"));
        existe = ficheroks.exists();
        return existe;
    }
}

