/*
 * Decompiled with CFR 0.152.
 */
package com.izenpe.firmaelectronica;

import com.izenpe.gestioncontenedorseguro.GestionContenedorSeguro;
import iaik.asn1.structures.AlgorithmID;
import iaik.asn1.structures.Name;
import iaik.pkcs.PKCS7CertList;
import iaik.pkcs.PKCSException;
import iaik.pkcs.PKCSParsingException;
import iaik.pkcs.pkcs7.ContentInfoStream;
import iaik.pkcs.pkcs7.ContentStream;
import iaik.pkcs.pkcs7.IssuerAndSerialNumber;
import iaik.pkcs.pkcs7.SignedDataStream;
import iaik.pkcs.pkcs7.SignerInfo;
import iaik.security.provider.IAIK;
import iaik.utils.StreamCopier;
import iaik.x509.X509Certificate;
import iaik.x509.X509ExtensionInitException;
import iaik.x509.extensions.BasicConstraints;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.util.Vector;

public class FirmaElectronica {
    public FirmaElectronica() {
        IAIK iaik = new IAIK();
        Security.insertProviderAt((Provider)iaik, 2);
        IAIK.addAsProvider((boolean)false);
    }

    public int signDettached(String issuerIn, String snIn, AlgorithmID signAlgorithm, byte[] data, String pathCS, String password, byte[] p7In, ByteArrayOutputStream p7) {
        int error = 0;
        try {
            if (p7In != null) {
                ByteArrayInputStream p7Signed = new ByteArrayInputStream(data);
                ByteArrayInputStream p7In2 = new ByteArrayInputStream(p7In);
                ContentInfoStream cis2 = new ContentInfoStream((InputStream)p7In2);
                AlgorithmID[] aids = new AlgorithmID[]{AlgorithmID.sha1, AlgorithmID.md2, AlgorithmID.md5};
                SignedDataStream sds = new SignedDataStream((InputStream)p7Signed, aids);
                InputStream data2 = sds.getInputStream();
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                StreamCopier sc = new StreamCopier(data2, (OutputStream)os);
                sc.copyStream();
                sds.decode(cis2.getContentInputStream());
                GestionContenedorSeguro cs = GestionContenedorSeguro.getInstance(pathCS, password);
                Vector<Object> v = new Vector<Object>();
                X509Certificate[] certAux2 = sds.getCertificates();
                ByteArrayInputStream is3 = new ByteArrayInputStream(os.toByteArray());
                sds.setInputStream((InputStream)is3);
                for (int i = 0; i < certAux2.length; ++i) {
                    v.addElement(certAux2[i]);
                }
                ByteArrayInputStream is = new ByteArrayInputStream(data);
                ByteArrayOutputStream auxiliar = new ByteArrayOutputStream();
                error = cs.getCertCS(issuerIn, snIn, auxiliar);
                if (error != 0) {
                    int n = error;
                    return n;
                }
                PrivateKey pk = cs.getPrivateKeyFromKeyStore(issuerIn, snIn);
                if (pk != null) {
                    X509Certificate cert0 = new X509Certificate(auxiliar.toByteArray());
                    if (this.isDigitalSignature(cert0.toByteArray())) {
                        Vector vChain = new Vector();
                        error = cs.getCertificateChain(cert0, vChain);
                        if (error != 0) {
                            int n = error;
                            return n;
                        }
                        Object[] certAux = new X509Certificate[vChain.size()];
                        vChain.copyInto(certAux);
                        if (certAux != null) {
                            IssuerAndSerialNumber iasn = new IssuerAndSerialNumber((java.security.cert.X509Certificate)cert0);
                            SignerInfo si = new SignerInfo(iasn, signAlgorithm, pk);
                            sds.addSignerInfo(si);
                            for (int j = 0; j < certAux.length - 1; ++j) {
                                if (v.contains(certAux[j])) continue;
                                v.addElement(certAux[j]);
                            }
                            Object[] certsFinal = new X509Certificate[v.size()];
                            v.copyInto(certsFinal);
                            sds.setCertificates((X509Certificate[])certsFinal);
                            ByteArrayOutputStream textoPlano = new ByteArrayOutputStream();
                            InputStream is2 = sds.getInputStream();
                            StreamCopier sc2 = new StreamCopier(is2, (OutputStream)textoPlano);
                            sc2.copyStream();
                            p7.reset();
                            ContentInfoStream cis = new ContentInfoStream((ContentStream)sds);
                            cis.writeTo((OutputStream)p7);
                            ((OutputStream)textoPlano).close();
                            is2.close();
                        } else {
                            error = 404;
                        }
                    } else {
                        error = 401;
                    }
                    ((OutputStream)auxiliar).close();
                } else {
                    error = 407;
                }
                ((InputStream)p7Signed).close();
                ((InputStream)p7In2).close();
                ((OutputStream)os).close();
                ((InputStream)is3).close();
                ((InputStream)is).close();
            } else {
                error = this.sign(issuerIn, snIn, signAlgorithm, data, pathCS, password, p7, 2);
            }
        }
        catch (NoSuchAlgorithmException nsae) {
            error = 403;
        }
        catch (IOException ioe) {
            error = 412;
        }
        catch (CertificateException ce) {
            System.err.println(ce);
        }
        catch (PKCSParsingException pe) {
            error = 411;
        }
        catch (PKCSException pkcse) {
            pkcse.printStackTrace();
        }
        return error;
    }

    public int signAttached(String issuerIn, String snIn, AlgorithmID signAlgorithm, byte[] data, String pathCS, String password, ByteArrayOutputStream p7) {
        int error = 0;
        try {
            ByteArrayOutputStream auxiliar;
            ByteArrayInputStream bais = new ByteArrayInputStream(data);
            ContentInfoStream cis2 = new ContentInfoStream((InputStream)bais);
            SignedDataStream sds = (SignedDataStream)cis2.getContent();
            ByteArrayOutputStream contenido = new ByteArrayOutputStream();
            StreamCopier sc2 = new StreamCopier(sds.getInputStream(), (OutputStream)contenido);
            sc2.copyStream();
            X509Certificate[] certAux = sds.getCertificates();
            ByteArrayInputStream is2 = new ByteArrayInputStream(contenido.toByteArray());
            sds.setInputStream((InputStream)is2);
            Vector<Object> v = new Vector<Object>();
            for (int i = 0; i < certAux.length; ++i) {
                v.addElement(certAux[i]);
            }
            GestionContenedorSeguro cs = GestionContenedorSeguro.getInstance(pathCS, password);
            error = cs.getCertCS(issuerIn, snIn, auxiliar = new ByteArrayOutputStream());
            if (error != 0) {
                int n = error;
                return n;
            }
            PrivateKey pk = cs.getPrivateKeyFromKeyStore(issuerIn, snIn);
            if (pk != null) {
                X509Certificate cert0 = new X509Certificate(auxiliar.toByteArray());
                if (this.isDigitalSignature(cert0.toByteArray())) {
                    Vector vChain = new Vector();
                    error = cs.getCertificateChain(cert0, vChain);
                    if (error != 0) {
                        int n = error;
                        return n;
                    }
                    Object[] chain = new X509Certificate[vChain.size()];
                    vChain.copyInto(chain);
                    if (chain != null) {
                        for (int j = 0; j < chain.length - 1; ++j) {
                            if (v.contains(chain[j])) continue;
                            v.addElement(chain[j]);
                        }
                        Object[] certsFinal = new X509Certificate[v.size()];
                        v.copyInto(certsFinal);
                        sds.setCertificates((X509Certificate[])certsFinal);
                        IssuerAndSerialNumber isn = new IssuerAndSerialNumber((java.security.cert.X509Certificate)cert0);
                        SignerInfo si = new SignerInfo(isn, signAlgorithm, pk);
                        sds.addSignerInfo(si);
                        p7.reset();
                        ContentInfoStream cis = new ContentInfoStream((ContentStream)sds);
                        cis.writeTo((OutputStream)p7);
                    } else {
                        error = 404;
                    }
                } else {
                    error = 401;
                }
            } else {
                error = 407;
            }
            ((InputStream)bais).close();
            ((OutputStream)contenido).close();
            ((InputStream)is2).close();
            ((OutputStream)auxiliar).close();
        }
        catch (CertificateException ce) {
            System.err.println(ce);
        }
        catch (PKCSParsingException pe) {
            error = 411;
        }
        catch (IOException ioe) {
            try {
                ByteArrayInputStream bais = new ByteArrayInputStream(data);
                SignedDataStream sds4 = new SignedDataStream((InputStream)bais);
                ((InputStream)bais).close();
            }
            catch (PKCSParsingException ppe) {
                ppe.printStackTrace();
            }
            catch (IOException ioe2) {
                error = this.sign(issuerIn, snIn, signAlgorithm, data, pathCS, password, p7, 1);
            }
        }
        catch (NoSuchAlgorithmException nsae) {
            error = 403;
        }
        catch (PKCSException pkcse) {
            pkcse.printStackTrace();
        }
        return error;
    }

    private int sign(String issuerIn, String snIn, AlgorithmID signAlgorithm, byte[] data, String pathCS, String password, ByteArrayOutputStream p7, int mode) {
        int error = 0;
        try {
            GestionContenedorSeguro cs = GestionContenedorSeguro.getInstance(pathCS, password);
            ByteArrayInputStream is = new ByteArrayInputStream(data);
            SignedDataStream sds = new SignedDataStream((InputStream)is, mode);
            ByteArrayOutputStream aux = new ByteArrayOutputStream();
            error = cs.getCertCS(issuerIn, snIn, aux);
            if (error != 0) {
                int n = error;
                return n;
            }
            PrivateKey pk = cs.getPrivateKeyFromKeyStore(issuerIn, snIn);
            if (pk != null) {
                Vector vChain;
                X509Certificate cert0 = new X509Certificate(aux.toByteArray());
                error = cs.getCertificateChain(cert0, vChain = new Vector());
                if (error != 0) {
                    int n = error;
                    return n;
                }
                Object[] certAux = new X509Certificate[vChain.size()];
                vChain.copyInto(certAux);
                if (certAux != null) {
                    X509Certificate[] cert = new X509Certificate[certAux.length - 1];
                    for (int i = 0; i < cert.length; ++i) {
                        cert[i] = certAux[i];
                    }
                    if (this.isDigitalSignature(cert[0].toByteArray())) {
                        sds.setCertificates(cert);
                        IssuerAndSerialNumber iasn = new IssuerAndSerialNumber((java.security.cert.X509Certificate)cert[0]);
                        SignerInfo si = new SignerInfo(iasn, signAlgorithm, pk);
                        sds.addSignerInfo(si);
                        if (mode == 2) {
                            InputStream is2 = sds.getInputStream();
                            ByteArrayOutputStream textoPlano = new ByteArrayOutputStream();
                            StreamCopier sc3 = new StreamCopier(is2, (OutputStream)textoPlano);
                            sc3.copyStream();
                            is2.close();
                            ((OutputStream)textoPlano).close();
                        }
                        ContentInfoStream cis = new ContentInfoStream((ContentStream)sds);
                        cis.writeTo((OutputStream)p7);
                    } else {
                        error = 401;
                    }
                } else {
                    error = 404;
                }
                ((OutputStream)aux).close();
            } else {
                error = 407;
            }
            ((InputStream)is).close();
        }
        catch (NoSuchAlgorithmException nsae) {
            error = 403;
        }
        catch (IOException ioe) {
            System.err.println(ioe);
        }
        catch (CertificateException ce) {
            System.err.println(ce);
        }
        catch (PKCSException pkcse) {
            pkcse.printStackTrace();
        }
        return error;
    }

    public int verifySignDettached(byte[] p7, byte[] data, String pathCS, String password, Vector certOut, Vector certErrores) {
        int error = 0;
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(data);
            ByteArrayInputStream p7Signed = new ByteArrayInputStream(p7);
            ContentInfoStream cis = new ContentInfoStream((InputStream)p7Signed);
            AlgorithmID[] aids = new AlgorithmID[]{AlgorithmID.sha1, AlgorithmID.md2, AlgorithmID.md5};
            SignedDataStream sds = new SignedDataStream((InputStream)bais, aids);
            ByteArrayOutputStream datosFirmados = new ByteArrayOutputStream();
            StreamCopier sc2 = new StreamCopier(sds.getInputStream(), (OutputStream)datosFirmados);
            sc2.copyStream();
            sds.decode(cis.getContentInputStream());
            SignerInfo[] signerInfos = sds.getSignerInfos();
            X509Certificate cert = null;
            String certString = "";
            GestionContenedorSeguro cs = GestionContenedorSeguro.getInstance(pathCS, password);
            X509Certificate[] certP7 = sds.getCertificates();
            int errorC = 0;
            for (int i = 0; i < signerInfos.length; ++i) {
                try {
                    cert = sds.verify(i);
                    if (this.isDigitalSignature(cert.toByteArray())) {
                        X509Certificate[] certSigner = this.getCertificateChain(certP7, cert);
                        BasicConstraints BC = (BasicConstraints)cert.getExtension(BasicConstraints.oid);
                        if (certSigner.length == 1 && BC == null) {
                            Vector vChain = new Vector();
                            errorC = cs.getCertificateChain(cert, vChain);
                            if (errorC == 0) {
                                Object[] chain = new X509Certificate[vChain.size()];
                                vChain.copyInto(chain);
                                if (chain != null) {
                                    errorC = cs.comprobar((X509Certificate[])chain);
                                    if (errorC != 0) {
                                        certOut.addElement(cert);
                                        error = 420;
                                    }
                                } else {
                                    errorC = 404;
                                    error = 420;
                                }
                            } else {
                                error = 420;
                            }
                        } else {
                            X509Certificate[] certSignerPlusRaiz = new X509Certificate[certSigner.length + 1];
                            for (int j = 0; j < certSigner.length; ++j) {
                                certSignerPlusRaiz[j] = certSigner[j];
                            }
                            ByteArrayOutputStream baosRoot = new ByteArrayOutputStream();
                            errorC = cs.getRoot(certSigner[certSigner.length - 1], baosRoot);
                            if (errorC == 0) {
                                X509Certificate aliasRoot = new X509Certificate(baosRoot.toByteArray());
                                if (aliasRoot != null) {
                                    certSignerPlusRaiz[certSignerPlusRaiz.length - 1] = aliasRoot;
                                    errorC = cs.comprobar(certSignerPlusRaiz);
                                    if (errorC != 0) {
                                        error = 420;
                                    }
                                } else {
                                    errorC = 405;
                                    error = 420;
                                }
                            } else {
                                error = 420;
                            }
                            ((OutputStream)baosRoot).close();
                        }
                    } else {
                        errorC = 401;
                        error = 420;
                    }
                    certOut.addElement(cert);
                }
                catch (SignatureException se) {
                    IssuerAndSerialNumber ias = signerInfos[i].getIssuerAndSerialNumber();
                    Name is = ias.getIssuer();
                    BigInteger sn = ias.getSerialNumber();
                    X509Certificate falled = this.getCertificate((Principal)is, sn, certP7);
                    certOut.addElement(falled);
                    error = 420;
                    errorC = 402;
                }
                catch (X509ExtensionInitException eie) {
                    eie.printStackTrace();
                }
                catch (CertificateException ce) {
                    System.err.println(ce);
                }
                certErrores.addElement(new Integer(errorC));
            }
            ((InputStream)bais).close();
            ((InputStream)p7Signed).close();
            ((OutputStream)datosFirmados).close();
        }
        catch (IOException ioe) {
            error = 409;
        }
        catch (PKCSParsingException ppe) {
            error = 411;
        }
        return error;
    }

    public int verifySignAttached(byte[] p7, String pathCS, String password, ByteArrayOutputStream datosFirmados, Vector certOut, Vector certErrores) {
        int error = 0;
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(p7);
            ContentInfoStream cis = new ContentInfoStream((InputStream)bais);
            SignedDataStream sds = (SignedDataStream)cis.getContent();
            StreamCopier sc2 = new StreamCopier(sds.getInputStream(), (OutputStream)datosFirmados);
            sc2.copyStream();
            SignerInfo[] signerInfos = sds.getSignerInfos();
            X509Certificate cert = null;
            GestionContenedorSeguro cs = GestionContenedorSeguro.getInstance(pathCS, password);
            X509Certificate[] certP7 = sds.getCertificates();
            int errorC = 0;
            for (int i = 0; i < signerInfos.length; ++i) {
                try {
                    cert = sds.verify(i);
                    if (this.isDigitalSignature(cert.toByteArray())) {
                        X509Certificate[] certSigner = this.getCertificateChain(certP7, cert);
                        BasicConstraints BC = (BasicConstraints)cert.getExtension(BasicConstraints.oid);
                        if (certSigner.length == 1 && BC == null) {
                            Vector vChain = new Vector();
                            errorC = cs.getCertificateChain(cert, vChain);
                            if (errorC == 0) {
                                Object[] chain = new X509Certificate[vChain.size()];
                                vChain.copyInto(chain);
                                if (chain != null) {
                                    errorC = cs.comprobar((X509Certificate[])chain);
                                    if (errorC != 0) {
                                        error = 420;
                                    }
                                } else {
                                    error = 420;
                                    errorC = 404;
                                }
                            } else {
                                error = 420;
                            }
                        } else {
                            ByteArrayOutputStream baosRoot = new ByteArrayOutputStream();
                            errorC = cs.getRoot(certSigner[certSigner.length - 1], baosRoot);
                            if (errorC == 0) {
                                X509Certificate aliasRoot = new X509Certificate(baosRoot.toByteArray());
                                if (aliasRoot != null) {
                                    X509Certificate[] certSignerPlusRaiz = new X509Certificate[certSigner.length + 1];
                                    for (int j = 0; j < certSigner.length; ++j) {
                                        certSignerPlusRaiz[j] = certSigner[j];
                                    }
                                    certSignerPlusRaiz[certSignerPlusRaiz.length - 1] = aliasRoot;
                                    errorC = cs.comprobar(certSignerPlusRaiz);
                                    if (errorC != 0) {
                                        error = 420;
                                    }
                                } else {
                                    errorC = 405;
                                    error = 420;
                                }
                            } else {
                                error = 420;
                            }
                            ((OutputStream)baosRoot).close();
                        }
                    } else {
                        error = 420;
                        errorC = 401;
                    }
                    certOut.addElement(cert);
                }
                catch (SignatureException se) {
                    se.printStackTrace();
                    IssuerAndSerialNumber ias = signerInfos[i].getIssuerAndSerialNumber();
                    Name is = ias.getIssuer();
                    BigInteger sn = ias.getSerialNumber();
                    X509Certificate falled = this.getCertificate((Principal)is, sn, certP7);
                    certOut.addElement(falled);
                    error = 420;
                    errorC = 402;
                }
                catch (X509ExtensionInitException eie) {
                    eie.printStackTrace();
                }
                catch (CertificateException ce) {
                    ce.printStackTrace();
                }
                certErrores.addElement(new Integer(errorC));
            }
            ((InputStream)bais).close();
        }
        catch (PKCSParsingException ppe) {
            error = 411;
        }
        catch (IOException ioe) {
            error = 409;
        }
        return error;
    }

    public int extractCertsPKCS7(byte[] p7, Vector certificados) {
        int error = 0;
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(p7);
            ((InputStream)bais).close();
            PKCS7CertList p7List = new PKCS7CertList((InputStream)bais);
            X509Certificate[] certList = p7List.getCertificateList();
            BasicConstraints bc = null;
            for (int i = 0; i < certList.length; ++i) {
                bc = (BasicConstraints)certList[i].getExtension(BasicConstraints.oid);
                if (bc != null && bc.ca()) continue;
                certificados.addElement(certList[i]);
            }
        }
        catch (X509ExtensionInitException xeie) {
            xeie.printStackTrace();
        }
        catch (IOException ioe) {
            error = 409;
        }
        catch (PKCSParsingException pkcspe) {
            error = 411;
        }
        return error;
    }

    public int extractHead(byte[] headDataIn, ByteArrayOutputStream dataOut, ByteArrayOutputStream headOut) {
        int error = 0;
        try {
            boolean encontrado = false;
            for (int i = 0; i < headDataIn.length; ++i) {
                char letra = (char)headDataIn[i];
                if (letra == '#') {
                    encontrado = true;
                    continue;
                }
                if (encontrado) {
                    dataOut.write(headDataIn[i]);
                    continue;
                }
                headOut.write(headDataIn[i]);
            }
            ((OutputStream)dataOut).close();
            ((OutputStream)headOut).close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return error;
    }

    public int appendHead(byte[] dataIn, byte[] headIn, ByteArrayOutputStream headDataOut) {
        int error = 0;
        try {
            ByteArrayOutputStream salidaDatos = new ByteArrayOutputStream();
            ByteArrayOutputStream salidaCabecera = new ByteArrayOutputStream();
            salidaDatos.write(dataIn);
            salidaCabecera.write(headIn);
            ((OutputStream)salidaDatos).close();
            ((OutputStream)salidaCabecera).close();
            String todo = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(salidaCabecera.toString("ISO8859_1")))).append("#").append(salidaDatos.toString("ISO8859_1"))));
            headDataOut.write(todo.getBytes("ISO8859_1"));
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return error;
    }

    private boolean isDigitalSignature(byte[] certificado) {
        boolean digitalSignature = false;
        try {
            X509Certificate cert = new X509Certificate(certificado);
            boolean[] b = cert.getKeyUsage();
            digitalSignature = b[0];
        }
        catch (CertificateException ce) {
            System.err.println(ce);
        }
        return digitalSignature;
    }

    private X509Certificate[] getCertificateChain(X509Certificate[] cadenaIn, X509Certificate cert) {
        Vector<X509Certificate> v = new Vector<X509Certificate>();
        v.addElement(cert);
        try {
            int i = 0;
            while (i < cadenaIn.length) {
                X509Certificate certificado = new X509Certificate(cadenaIn[i].toByteArray());
                if (cert.getIssuerDN().equals(certificado.getSubjectDN())) {
                    v.addElement(new X509Certificate(certificado.toByteArray()));
                    if (certificado.getSubjectDN().equals(certificado.getIssuerDN())) {
                        v.removeElementAt(v.size() - 1);
                        break;
                    }
                    i = 0;
                    cert = new X509Certificate(certificado.toByteArray());
                    continue;
                }
                ++i;
            }
        }
        catch (CertificateException ce) {
            System.err.println(ce);
        }
        X509Certificate[] cadenaSalida = new X509Certificate[v.size()];
        for (int z = 0; z < v.size(); ++z) {
            cadenaSalida[z] = (X509Certificate)v.elementAt(z);
        }
        return cadenaSalida;
    }

    private X509Certificate getCertificate(Principal is, BigInteger sn, X509Certificate[] certP7) {
        boolean encontrado = false;
        X509Certificate salida = null;
        for (int i = 0; i < certP7.length && !encontrado; ++i) {
            salida = certP7[i];
            if (!salida.getIssuerDN().equals(is) || !salida.getSerialNumber().equals(sn)) continue;
            encontrado = true;
        }
        if (encontrado) {
            return salida;
        }
        return null;
    }

    private void saltarReturns(String entrada, ByteArrayOutputStream salida) {
        String temporal = "";
        int indice = 0;
        int i = 0;
        for (i = 0; i < entrada.length(); ++i) {
            if (entrada.charAt(i) != '\r') continue;
            temporal = String.valueOf(String.valueOf(temporal)).concat(String.valueOf(String.valueOf(entrada.substring(indice, i))));
            indice = i + 2;
        }
        temporal = String.valueOf(String.valueOf(temporal)).concat(String.valueOf(String.valueOf(entrada.substring(indice, i))));
        try {
            salida.write(temporal.getBytes("ISO8859_1"));
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }
}

