/*
 * Decompiled with CFR 0.152.
 */
package com.izenpe.firmacifradodatos;

import com.izenpe.gestioncontenedorseguro.GestionContenedorSeguro;
import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.PKCSException;
import iaik.pkcs.PKCSParsingException;
import iaik.pkcs.pkcs7.IssuerAndSerialNumber;
import iaik.pkcs.pkcs7.RecipientInfo;
import iaik.pkcs.pkcs7.SignedAndEnvelopedDataStream;
import iaik.pkcs.pkcs7.SignerInfo;
import iaik.security.provider.IAIK;
import iaik.x509.X509Certificate;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.util.Vector;

public class FirmaCifradoDatos {
    public FirmaCifradoDatos() {
        IAIK iaik = new IAIK();
        Security.insertProviderAt((Provider)iaik, 2);
        IAIK.addAsProvider((boolean)false);
    }

    public int encrypAndSignData(String issuerIn, String serialIn, AlgorithmID aFirma, AlgorithmID aDatos, byte[] certIn, byte[] dataIn, String path, String pass, ByteArrayOutputStream p7) {
        int error = 0;
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(dataIn);
            SignedAndEnvelopedDataStream signedandenvelopeddata = new SignedAndEnvelopedDataStream((InputStream)is, aDatos);
            signedandenvelopeddata.setBlockSize(2048);
            X509Certificate cert = new X509Certificate(certIn);
            if (this.canEncrypt(cert)) {
                GestionContenedorSeguro contenedor = GestionContenedorSeguro.getInstance(path, pass);
                Vector listacerts = new Vector();
                PrivateKey pKeyIn = contenedor.getPrivateKeyFromKeyStore(issuerIn, serialIn);
                if (pKeyIn != null) {
                    ByteArrayOutputStream aux = new ByteArrayOutputStream();
                    error = contenedor.getCertCS(issuerIn, serialIn, aux);
                    if (error == 0) {
                        X509Certificate certF = new X509Certificate(aux.toByteArray());
                        if (!this.canSign(certF)) {
                            error = 613;
                            int n = 613;
                            return n;
                        }
                        Vector chain = new Vector();
                        error = contenedor.getCertificateChain(certF, chain);
                        if (error == 0) {
                            Object[] cadenaCert1 = new X509Certificate[chain.size()];
                            chain.copyInto(cadenaCert1);
                            X509Certificate[] last = new X509Certificate[cadenaCert1.length - 1];
                            for (int z = 0; z < last.length; ++z) {
                                last[z] = cadenaCert1[z];
                            }
                            signedandenvelopeddata.setCertificates(last);
                            IssuerAndSerialNumber issuer = new IssuerAndSerialNumber((java.security.cert.X509Certificate)certF);
                            SignerInfo signerinfo = new SignerInfo(issuer, aFirma, pKeyIn);
                            signedandenvelopeddata.addSignerInfo(signerinfo);
                            RecipientInfo recipient = new RecipientInfo((java.security.cert.X509Certificate)cert, AlgorithmID.rsaEncryption);
                            signedandenvelopeddata.addRecipientInfo(recipient);
                            signedandenvelopeddata.writeTo((OutputStream)p7, signedandenvelopeddata.getBlockSize());
                        } else {
                            error = 611;
                        }
                    }
                    ((OutputStream)aux).close();
                } else {
                    error = 344;
                }
            } else {
                error = 606;
                int n = 606;
                return n;
            }
            ((InputStream)is).close();
            ((OutputStream)p7).close();
        }
        catch (NoSuchAlgorithmException nsae) {
            error = 601;
        }
        catch (CertificateException ce) {
            error = 602;
        }
        catch (IOException ioe) {
            error = 607;
        }
        return error;
    }

    public int verifyEncrypAndSign(byte[] p7, String pathIn, String passIn, ByteArrayOutputStream dataOut, ByteArrayOutputStream certOut) {
        int error = 0;
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(p7);
            SignedAndEnvelopedDataStream signedandenvelopeddata = new SignedAndEnvelopedDataStream((InputStream)is);
            int recipientInfoIndex = 0;
            RecipientInfo[] recipients = signedandenvelopeddata.getRecipientInfos();
            IssuerAndSerialNumber iasn = recipients[0].getIssuerAndSerialNumber();
            String issuer = iasn.getIssuer().toString();
            String sn = iasn.getSerialNumber().toString();
            PrivateKey pk = null;
            GestionContenedorSeguro cs = GestionContenedorSeguro.getInstance(pathIn, passIn);
            pk = cs.getPrivateKeyFromKeyStore(issuer, sn);
            if (pk != null) {
                int r;
                signedandenvelopeddata.setupCipher(pk, recipientInfoIndex);
                InputStream bisTemp = signedandenvelopeddata.getInputStream();
                byte[] buf = new byte[1024];
                while ((r = bisTemp.read(buf)) > 0) {
                    dataOut.write(buf, 0, r);
                }
                bisTemp.close();
                SignerInfo[] signer_infos = signedandenvelopeddata.getSignerInfos();
                for (int i = 0; i < signer_infos.length; ++i) {
                    X509Certificate cert = signedandenvelopeddata.verify(i);
                    if (!this.canSign(cert)) {
                        error = 613;
                        int n = 613;
                        return n;
                    }
                    Vector salida = new Vector();
                    error = cs.getCertificateChain(cert, salida);
                    if (error != 0) {
                        int n = error;
                        return n;
                    }
                    Object[] cadena = new X509Certificate[salida.size()];
                    salida.copyInto(cadena);
                    error = cs.comprobar((X509Certificate[])cadena);
                    if (error == 0) continue;
                    int n = error;
                    return n;
                }
            } else {
                error = 604;
            }
            ((OutputStream)dataOut).close();
            ((OutputStream)certOut).close();
            ((InputStream)is).close();
        }
        catch (SignatureException se) {
            se.printStackTrace();
            error = 605;
            int n = 605;
            return n;
        }
        catch (PKCSParsingException pkcspe) {
            error = 609;
            int n = 609;
            return n;
        }
        catch (PKCSException pkcse) {
            error = 610;
            int n = 610;
            return n;
        }
        catch (NoSuchAlgorithmException nsae) {
            error = 601;
            int n = 601;
            return n;
        }
        catch (InvalidKeyException ike) {
            error = 608;
            int n = 608;
            return n;
        }
        catch (IOException ioe) {
            error = 607;
            int n = 607;
            return n;
        }
        return error;
    }

    private boolean canSign(X509Certificate cert) {
        boolean can = false;
        boolean[] b = cert.getKeyUsage();
        if (b[0]) {
            can = true;
        }
        return can;
    }

    private boolean canEncrypt(X509Certificate cert) {
        boolean can = false;
        boolean[] b = cert.getKeyUsage();
        if (b[3]) {
            can = true;
        }
        return can;
    }
}

