/*
 * Decompiled with CFR 0.152.
 */
package com.izenpe.cifradodatos;

import com.izenpe.gestioncontenedorseguro.GestionContenedorSeguro;
import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.PKCSException;
import iaik.pkcs.PKCSParsingException;
import iaik.pkcs.pkcs7.EnvelopedData;
import iaik.pkcs.pkcs7.EnvelopedDataStream;
import iaik.pkcs.pkcs7.IssuerAndSerialNumber;
import iaik.pkcs.pkcs7.RecipientInfo;
import iaik.security.provider.IAIK;
import iaik.utils.StreamCopier;
import iaik.x509.X509Certificate;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateException;

public class CifradoDatos {
    public CifradoDatos() {
        IAIK iaik = new IAIK();
        Security.insertProviderAt((Provider)iaik, 2);
        IAIK.addAsProvider((boolean)false);
    }

    public int encryptingData(byte[] dataIn, byte[] certIn, AlgorithmID algoritmo, ByteArrayOutputStream p7, String path, String pass) {
        int error = 0;
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(certIn);
            X509Certificate x509cert = new X509Certificate(certIn);
            GestionContenedorSeguro contenedor = GestionContenedorSeguro.getInstance(path, pass);
            if (!this.canEncypt(x509cert)) {
                error = 510;
                int n = 510;
                return n;
            }
            EnvelopedData sobreDigital = new EnvelopedData(dataIn, algoritmo);
            RecipientInfo[] recipients = new RecipientInfo[]{new RecipientInfo((java.security.cert.X509Certificate)x509cert, AlgorithmID.rsaEncryption)};
            sobreDigital.setRecipientInfos(recipients);
            p7.write(sobreDigital.getEncoded());
            ((InputStream)bis).close();
            ((OutputStream)p7).close();
        }
        catch (IOException ioe) {
            error = 511;
            int n = 511;
            return n;
        }
        catch (NoSuchAlgorithmException nsae) {
            nsae.printStackTrace();
            error = 504;
            int n = 504;
            return n;
        }
        catch (PKCSException pe) {
            error = 505;
            int n = 505;
            return n;
        }
        catch (CertificateException ce) {
            error = 506;
            int n = 506;
            return n;
        }
        return error;
    }

    public int decryptingData(byte[] p7, ByteArrayOutputStream dataOut, String path, String pass) {
        int error = 0;
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(p7);
            EnvelopedDataStream sobreDigital = new EnvelopedDataStream((InputStream)bis);
            RecipientInfo[] recipients = sobreDigital.getRecipientInfos();
            IssuerAndSerialNumber issn = recipients[0].getIssuerAndSerialNumber();
            GestionContenedorSeguro contenedor = GestionContenedorSeguro.getInstance(path, pass);
            PrivateKey p = contenedor.getPrivateKeyFromKeyStore(issn.getIssuer().toString(), issn.getSerialNumber().toString());
            if (p != null) {
                sobreDigital.setupCipher(p, 0);
                InputStream descripcion = sobreDigital.getInputStream();
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                StreamCopier sc = new StreamCopier(descripcion, (OutputStream)dataOut);
                sc.copyStream();
                ((OutputStream)os).close();
                ((InputStream)bis).close();
                ((OutputStream)dataOut).close();
                descripcion.close();
            } else {
                error = 507;
            }
        }
        catch (IOException ioe) {
            error = 511;
            int n = 511;
            return n;
        }
        catch (PKCSParsingException ppe) {
            error = 508;
            int n = 508;
            return n;
        }
        catch (NoSuchAlgorithmException nsae) {
            error = 504;
            int n = 504;
            return n;
        }
        catch (InvalidKeyException ike) {
            error = 509;
            int n = 509;
            return n;
        }
        catch (PKCSException pe) {
            error = 505;
            int n = 505;
            return n;
        }
        return error;
    }

    private boolean canEncypt(X509Certificate cert) {
        boolean can = false;
        boolean[] b = cert.getKeyUsage();
        if (b[3]) {
            can = true;
        }
        return can;
    }
}

