/*
 * Decompiled with CFR 0.152.
 */
package com.izenpe.cargacrl;

import com.izenpe.AlgoritmosHash;
import com.izenpe.gestioncontenedorseguro.GestionContenedorSeguro;
import com.izenpe.miscelanea.Miscelanea;
import iaik.security.provider.IAIK;
import iaik.x509.X509CRL;
import iaik.x509.X509Certificate;
import iaik.x509.X509ExtensionInitException;
import iaik.x509.extensions.AuthorityKeyIdentifier;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.util.Hashtable;
import java.util.Vector;

public class CargaCRL {
    public CargaCRL() {
        IAIK iaik = new IAIK();
        Security.insertProviderAt((Provider)iaik, 2);
        IAIK.addAsProvider((boolean)false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int loadCRL(String URI2, String proxyhost, String proxyport, String proxylogin, String proxypass, String path, String pass) {
        int error = 0;
        try {
            URL conexion = new URL(URI2);
            if (proxyhost != null) {
                ((Hashtable)System.getProperties()).put("proxySet", "true");
                ((Hashtable)System.getProperties()).put("proxyHost", proxyhost);
                ((Hashtable)System.getProperties()).put("proxyPort", proxyport);
            }
            URLConnection conConexion = conexion.openConnection();
            if (proxyhost != null) {
                String logpass = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(proxylogin))).append(":").append(proxypass)));
                Miscelanea funciones = new Miscelanea();
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                funciones.binBase64(logpass.getBytes("ISO8859_1"), baos);
                conConexion.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.5; Windows NT 5.0)");
                conConexion.setRequestProperty("Accept", "text/html, image/*");
                conConexion.setDoInput(true);
                conConexion.setDoOutput(true);
                conConexion.setUseCaches(false);
                conConexion.setRequestProperty("Proxy-Authorization", "Basic ".concat(String.valueOf(String.valueOf(baos.toString("ISO8859_1")))));
            }
            InputStream is = conConexion.getInputStream();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int linea = 0;
            byte[] temp = new byte[4096];
            while ((linea = is.read(temp)) != -1) {
                baos.write(temp, 0, linea);
            }
            is.close();
            X509CRL x509crl = new X509CRL(baos.toByteArray());
            if (!path.endsWith(File.separator)) {
                path = String.valueOf(String.valueOf(path)).concat(String.valueOf(String.valueOf(File.separator)));
            }
            String issuer = x509crl.getIssuerDN().toString();
            AuthorityKeyIdentifier aki = new AuthorityKeyIdentifier();
            aki = (AuthorityKeyIdentifier)x509crl.getExtension(AuthorityKeyIdentifier.oid);
            ByteArrayOutputStream cacert = new ByteArrayOutputStream();
            GestionContenedorSeguro cs = GestionContenedorSeguro.getInstance(path, pass);
            if (aki != null) {
                byte[] authority = aki.getKeyIdentifier();
                error = cs.getCAFromKeyStore(issuer, authority, cacert);
            } else {
                error = cs.getCAFromKeyStore(issuer, null, cacert);
            }
            if (error != 0) return error;
            if (cacert.size() <= 0) return error;
            X509Certificate x509cert = new X509Certificate(cacert.toByteArray());
            x509crl.verify(x509cert.getPublicKey());
            Vector listacerts = new Vector();
            int errorcarga = cs.getCertificateChain(x509crl, listacerts);
            X509Certificate[] cadenacrl = new X509Certificate[listacerts.size()];
            for (int i = 0; i < listacerts.size(); ++i) {
                cadenacrl[i] = (X509Certificate)listacerts.elementAt(i);
            }
            if (errorcarga != 0) {
                error = errorcarga;
                return error;
            }
            error = cs.comprobar(cadenacrl);
            if (error != 0) return error;
            ByteArrayOutputStream hash = new ByteArrayOutputStream();
            ByteArrayOutputStream nuevohash64 = new ByteArrayOutputStream();
            String nombrecrl = String.valueOf(String.valueOf(x509cert.getIssuerDN().toString())).concat(String.valueOf(String.valueOf(x509cert.getSerialNumber().toString())));
            Miscelanea funciones = new Miscelanea();
            AlgoritmosHash alg = new AlgoritmosHash();
            alg.setAlgorithm("sha");
            funciones.newHash(alg.getAlgorithm(), nombrecrl.getBytes("ISO8859_1"), hash, true);
            funciones.binBase64(hash.toByteArray(), nuevohash64);
            String htemporal = nuevohash64.toString("ISO8859_1");
            htemporal = htemporal.replace('/', '_');
            String pathcompleto = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(path))).append(htemporal).append(".crl")));
            File crl = new File(pathcompleto);
            if (crl.exists()) {
                error = 201;
            }
            byte[] tempcrl = baos.toByteArray();
            ByteArrayInputStream bis = new ByteArrayInputStream(tempcrl);
            FileOutputStream fi = new FileOutputStream(crl);
            int linea2 = 0;
            byte[] temp2 = new byte[4096];
            while ((linea2 = bis.read(temp2)) != -1) {
                fi.write(temp2, 0, linea2);
            }
            fi.close();
            ((InputStream)bis).close();
            ((OutputStream)nuevohash64).close();
            ((OutputStream)hash).close();
            ((OutputStream)cacert).close();
            ((OutputStream)baos).close();
            return error;
        }
        catch (ConnectException ce) {
            return 202;
        }
        catch (SignatureException se) {
            return 205;
        }
        catch (NoSuchProviderException nspe) {
            return 206;
        }
        catch (InvalidKeyException ike) {
            return 207;
        }
        catch (NoSuchAlgorithmException nsae) {
            return 204;
        }
        catch (CRLException crle) {
            return 208;
        }
        catch (CertificateException ce) {
            return 203;
        }
        catch (X509ExtensionInitException xeie) {
            return 209;
        }
        catch (MalformedURLException mue) {
            return 210;
        }
        catch (FileNotFoundException fnfe) {
            return 211;
        }
        catch (UnknownHostException uhe) {
            return 212;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return error;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int loadCRLFile(String pathCrl, String fileCrl, String path, String pass) {
        int error = 0;
        try {
            if (!pathCrl.endsWith(File.separator)) {
                pathCrl = String.valueOf(String.valueOf(pathCrl)).concat(String.valueOf(String.valueOf(File.separator)));
            }
            File fcrl = new File(String.valueOf(String.valueOf(pathCrl)).concat(String.valueOf(String.valueOf(fileCrl))));
            FileInputStream ficrl = new FileInputStream(fcrl);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int leer = 0;
            byte[] temporal = new byte[4096];
            while ((leer = ficrl.read(temporal)) != -1) {
                baos.write(temporal, 0, leer);
            }
            ficrl.close();
            X509CRL x509crl = new X509CRL(baos.toByteArray());
            if (!path.endsWith(File.separator)) {
                path = String.valueOf(String.valueOf(path)).concat(String.valueOf(String.valueOf(File.separator)));
            }
            String issuer = x509crl.getIssuerDN().toString();
            AuthorityKeyIdentifier aki = new AuthorityKeyIdentifier();
            aki = (AuthorityKeyIdentifier)x509crl.getExtension(AuthorityKeyIdentifier.oid);
            ByteArrayOutputStream cacert = new ByteArrayOutputStream();
            GestionContenedorSeguro cs = GestionContenedorSeguro.getInstance(path, pass);
            if (aki != null) {
                byte[] authority = aki.getKeyIdentifier();
                error = cs.getCAFromKeyStore(issuer, authority, cacert);
            } else {
                error = cs.getCAFromKeyStore(issuer, null, cacert);
            }
            if (error != 0) return error;
            if (cacert.size() <= 0) return error;
            X509Certificate x509cert = new X509Certificate(cacert.toByteArray());
            x509crl.verify(x509cert.getPublicKey());
            Vector listacerts = new Vector();
            int errorcarga = cs.getCertificateChain(x509crl, listacerts);
            X509Certificate[] cadenacrl = new X509Certificate[listacerts.size()];
            for (int i = 0; i < listacerts.size(); ++i) {
                cadenacrl[i] = (X509Certificate)listacerts.elementAt(i);
            }
            if (errorcarga != 0) {
                error = errorcarga;
                return error;
            }
            error = cs.comprobar(cadenacrl);
            if (error != 0) return error;
            ByteArrayOutputStream hash = new ByteArrayOutputStream();
            ByteArrayOutputStream nuevohash64 = new ByteArrayOutputStream();
            String nombrecrl = String.valueOf(String.valueOf(x509cert.getIssuerDN().toString())).concat(String.valueOf(String.valueOf(x509cert.getSerialNumber().toString())));
            Miscelanea funciones = new Miscelanea();
            AlgoritmosHash alg = new AlgoritmosHash();
            alg.setAlgorithm("sha");
            funciones.newHash(alg.getAlgorithm(), nombrecrl.getBytes("ISO8859_1"), hash, true);
            funciones.binBase64(hash.toByteArray(), nuevohash64);
            String htemporal = nuevohash64.toString("ISO8859_1");
            htemporal = htemporal.replace('/', '_');
            String pathcompleto = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(path))).append(htemporal).append(".crl")));
            File crl = new File(pathcompleto);
            if (crl.exists()) {
                error = 201;
            }
            byte[] tempcrl = baos.toByteArray();
            ByteArrayInputStream bis = new ByteArrayInputStream(tempcrl);
            FileOutputStream fi = new FileOutputStream(crl);
            int linea2 = 0;
            byte[] temp2 = new byte[4096];
            while ((linea2 = bis.read(temp2)) != -1) {
                fi.write(temp2, 0, linea2);
            }
            fi.close();
            ((InputStream)bis).close();
            ((OutputStream)hash).close();
            ((OutputStream)nuevohash64).close();
            ((OutputStream)cacert).close();
            ((OutputStream)baos).close();
            return error;
        }
        catch (ConnectException ce) {
            return 202;
        }
        catch (SignatureException se) {
            return 205;
        }
        catch (NoSuchProviderException nspe) {
            return 206;
        }
        catch (InvalidKeyException ike) {
            return 207;
        }
        catch (NoSuchAlgorithmException nsae) {
            return 204;
        }
        catch (CRLException crle) {
            return 208;
        }
        catch (CertificateException ce) {
            return 203;
        }
        catch (X509ExtensionInitException xeie) {
            return 209;
        }
        catch (MalformedURLException mue) {
            return 210;
        }
        catch (FileNotFoundException fnfe) {
            return 211;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return error;
    }
}

