/*
 * Decompiled with CFR 0.152.
 */
package com.izenpe.autenticacionfuerte;

import iaik.asn1.CodingException;
import iaik.asn1.GeneralizedTime;
import iaik.asn1.ObjectID;
import iaik.asn1.structures.AccessDescription;
import iaik.asn1.structures.Attribute;
import iaik.asn1.structures.AttributeValue;
import iaik.asn1.structures.DistributionPoint;
import iaik.asn1.structures.GeneralName;
import iaik.asn1.structures.GeneralNames;
import iaik.asn1.structures.PolicyInformation;
import iaik.asn1.structures.PolicyQualifierInfo;
import iaik.security.provider.IAIK;
import iaik.utils.StreamCopier;
import iaik.x509.X509Certificate;
import iaik.x509.X509ExtensionInitException;
import iaik.x509.extensions.AuthorityInfoAccess;
import iaik.x509.extensions.AuthorityKeyIdentifier;
import iaik.x509.extensions.BasicConstraints;
import iaik.x509.extensions.CRLDistributionPoints;
import iaik.x509.extensions.CertificatePolicies;
import iaik.x509.extensions.ExtendedKeyUsage;
import iaik.x509.extensions.IssuerAltName;
import iaik.x509.extensions.KeyUsage;
import iaik.x509.extensions.SubjectAltName;
import iaik.x509.extensions.SubjectDirectoryAttributes;
import iaik.x509.extensions.SubjectInfoAccess;
import iaik.x509.extensions.SubjectKeyIdentifier;
import iaik.x509.extensions.netscape.NetscapeCertType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Principal;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class AutenticacionFuerte {
    static boolean critical;

    public AutenticacionFuerte() {
        IAIK iaik = new IAIK();
        Security.insertProviderAt((Provider)iaik, 2);
        IAIK.addAsProvider((boolean)false);
    }

    public int extractKeyUsage(byte[] certificado, ByteArrayOutputStream keyUsage) {
        int error = 0;
        try {
            X509Certificate cert = new X509Certificate(certificado);
            KeyUsage ku = (KeyUsage)cert.getExtension(KeyUsage.oid);
            if (ku != null) {
                critical = ku.isCritical();
                ByteArrayInputStream bais = new ByteArrayInputStream(ku.toString().getBytes("ISO8859_1"));
                StreamCopier sc = new StreamCopier((InputStream)bais, (OutputStream)keyUsage);
                sc.copyStream();
                ((InputStream)bais).close();
            } else {
                error = 301;
            }
        }
        catch (CertificateException ce) {
            error = 302;
        }
        catch (IOException ioe) {
            System.err.println(ioe);
        }
        catch (X509ExtensionInitException ei) {
            System.err.println((Object)ei);
        }
        return error;
    }

    public int extractExtendedKeyUsage(byte[] certificado, ByteArrayOutputStream extendedKeyUsage) {
        int error = 0;
        try {
            X509Certificate cert = new X509Certificate(certificado);
            String result = "";
            ExtendedKeyUsage eku = (ExtendedKeyUsage)cert.getExtension(ExtendedKeyUsage.oid);
            if (eku != null) {
                critical = eku.isCritical();
                ObjectID[] purposes = eku.getKeyPurposeIDs();
                for (int i = 0; i < purposes.length; ++i) {
                    result = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(result))).append(purposes[i].getName()).append(",")));
                }
                result = result.substring(0, result.length() - 1);
                ByteArrayInputStream bais = new ByteArrayInputStream(result.getBytes("ISO8859_1"));
                StreamCopier sc = new StreamCopier((InputStream)bais, (OutputStream)extendedKeyUsage);
                sc.copyStream();
                ((InputStream)bais).close();
            } else {
                error = 301;
            }
        }
        catch (CertificateException ce) {
            error = 302;
        }
        catch (IOException iOException) {
        }
        catch (X509ExtensionInitException x509ExtensionInitException) {
            // empty catch block
        }
        return error;
    }

    public int extractPolicy(byte[] certificado, ByteArrayOutputStream politicaOID, ByteArrayOutputStream userNotice) {
        int error = 0;
        try {
            X509Certificate cert = new X509Certificate(certificado);
            String result = "";
            String result1 = "";
            CertificatePolicies cp = (CertificatePolicies)cert.getExtension(CertificatePolicies.oid);
            if (cp != null) {
                critical = cp.isCritical();
                PolicyInformation[] pi = cp.getPolicyInformation();
                if (pi != null) {
                    ObjectID oid = pi[0].getPolicyIdentifier();
                    result1 = oid.getName();
                    PolicyQualifierInfo[] pq = pi[0].getPolicyQualifiers();
                    if (pq != null) {
                        for (int i = 0; i < pq.length; ++i) {
                            if (!pq[i].getPolicyQualifier().equals((Object)ObjectID.id_pkix_unotice)) continue;
                            result = pq[i].getExplicitTest().getValue().toString();
                            break;
                        }
                    }
                }
                ByteArrayInputStream bais = new ByteArrayInputStream(result.getBytes("ISO8859_1"));
                StreamCopier sc = new StreamCopier((InputStream)bais, (OutputStream)userNotice);
                sc.copyStream();
                ByteArrayInputStream bais2 = new ByteArrayInputStream(result1.getBytes("ISO8859_1"));
                StreamCopier sc2 = new StreamCopier((InputStream)bais2, (OutputStream)politicaOID);
                sc2.copyStream();
                ((InputStream)bais).close();
                ((InputStream)bais2).close();
            } else {
                error = 301;
            }
        }
        catch (CertificateException ce) {
            error = 302;
        }
        catch (IOException ioe) {
            System.err.println(ioe);
        }
        catch (X509ExtensionInitException ei) {
            System.err.println((Object)ei);
        }
        return error;
    }

    public int extractSubject(byte[] certificado, ByteArrayOutputStream subject) {
        int error = 0;
        try {
            X509Certificate cert = new X509Certificate(certificado);
            Principal p = cert.getSubjectDN();
            ByteArrayInputStream bais = new ByteArrayInputStream(p.getName().getBytes("ISO8859_1"));
            StreamCopier sc = new StreamCopier((InputStream)bais, (OutputStream)subject);
            sc.copyStream();
            ((InputStream)bais).close();
        }
        catch (CertificateException ce) {
            error = 302;
        }
        catch (IOException ioe) {
            System.err.println(ioe);
        }
        return error;
    }

    public int parseSubject(byte[] certificado, String nombreA, ByteArrayOutputStream valorA) {
        int error = 0;
        try {
            ByteArrayOutputStream subjectC = new ByteArrayOutputStream();
            error = this.extractSubject(certificado, subjectC);
            StringTokenizer st = new StringTokenizer(subjectC.toString("ISO8859_1"), ",");
            boolean encontrado = false;
            String resultado = "";
            while (st.hasMoreTokens() && !encontrado) {
                StringTokenizer st2 = new StringTokenizer(st.nextToken(), "=");
                if (!st2.nextToken().equals(nombreA)) continue;
                resultado = st2.nextToken();
                encontrado = true;
            }
            if (!encontrado) {
                error = 303;
            } else {
                try {
                    ByteArrayInputStream bais = new ByteArrayInputStream(resultado.getBytes("ISO8859_1"));
                    StreamCopier sc = new StreamCopier((InputStream)bais, (OutputStream)valorA);
                    sc.copyStream();
                    ((InputStream)bais).close();
                }
                catch (IOException ioe) {
                    System.err.println(ioe);
                }
            }
            ((OutputStream)subjectC).close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return error;
    }

    public int extractSubjectAltName(byte[] certificado, ByteArrayOutputStream subjectAlt) {
        int error = 0;
        X509Certificate cert = null;
        SubjectAltName san = null;
        try {
            cert = new X509Certificate(certificado);
            san = (SubjectAltName)cert.getExtension(SubjectAltName.oid);
            if (san != null) {
                critical = san.isCritical();
                String resultado = "";
                GeneralNames gn = san.getGeneralNames();
                Enumeration enu = gn.getNames();
                while (enu.hasMoreElements()) {
                    GeneralName gn1 = (GeneralName)enu.nextElement();
                    resultado = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(resultado))).append(gn1.getName()).append(",")));
                }
                resultado = resultado.substring(0, resultado.length() - 1);
                ByteArrayInputStream bais = new ByteArrayInputStream(resultado.getBytes("ISO8859_1"));
                StreamCopier sc = new StreamCopier((InputStream)bais, (OutputStream)subjectAlt);
                sc.copyStream();
                ((InputStream)bais).close();
            } else {
                error = 301;
            }
        }
        catch (CertificateException ce) {
            error = 302;
        }
        catch (X509ExtensionInitException ei) {
            System.err.println((Object)ei);
        }
        catch (IOException ce) {
            System.err.println(ce);
        }
        return error;
    }

    public int extractIssuerSerialNumber(byte[] certificado, ByteArrayOutputStream issuer, ByteArrayOutputStream serial) {
        int error = 0;
        try {
            X509Certificate cert = new X509Certificate(certificado);
            String p = cert.getIssuerDN().getName();
            String sn = cert.getSerialNumber().toString();
            ByteArrayInputStream bais1 = new ByteArrayInputStream(p.getBytes("ISO8859_1"));
            ByteArrayInputStream bais2 = new ByteArrayInputStream(sn.getBytes("ISO8859_1"));
            StreamCopier sc1 = new StreamCopier((InputStream)bais1, (OutputStream)issuer);
            StreamCopier sc2 = new StreamCopier((InputStream)bais2, (OutputStream)serial);
            sc1.copyStream();
            sc2.copyStream();
            ((InputStream)bais1).close();
            ((InputStream)bais2).close();
        }
        catch (CertificateException ce) {
            error = 302;
        }
        catch (IOException ioe) {
            System.err.println(ioe);
        }
        return error;
    }

    public int parseCert(byte[] certificado, String oid, ByteArrayOutputStream valor, ByteArrayOutputStream criticidad) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectID ext = new ObjectID(oid);
        int resultado = 0;
        if (ext.equals((Object)ExtendedKeyUsage.oid)) {
            resultado = this.extractExtendedKeyUsage(certificado, valor);
        } else if (ext.equals((Object)CertificatePolicies.oid)) {
            resultado = this.extractPolicy(certificado, valor, baos);
        } else if (ext.equals((Object)SubjectAltName.oid)) {
            resultado = this.extractSubjectAltName(certificado, valor);
        } else if (ext.equals((Object)KeyUsage.oid)) {
            resultado = this.extractKeyUsage(certificado, valor);
        } else if (ext.equals((Object)AuthorityKeyIdentifier.oid)) {
            resultado = this.getAuthorityKeyIdentifier(certificado, valor);
        } else if (ext.equals((Object)SubjectKeyIdentifier.oid)) {
            resultado = this.getSubjectKeyIdentifier(certificado, valor);
        } else if (ext.equals((Object)BasicConstraints.oid)) {
            resultado = this.getBasicConstraints(certificado, valor);
        } else if (ext.equals((Object)IssuerAltName.oid)) {
            resultado = this.getIssuerAltName(certificado, valor);
        } else if (ext.equals((Object)CRLDistributionPoints.oid)) {
            resultado = this.getCrlDP(certificado, valor);
        } else if (ext.equals((Object)NetscapeCertType.oid)) {
            resultado = this.getNetscapeCertType(certificado, valor);
        } else if (ext.equals((Object)AuthorityInfoAccess.oid)) {
            resultado = this.getAuthorityInfoAccess(certificado, valor);
        } else if (ext.equals((Object)SubjectDirectoryAttributes.oid)) {
            resultado = this.getSubjectDirectoryAttributes(certificado, valor);
        } else if (ext.equals((Object)SubjectInfoAccess.oid)) {
            resultado = this.getSubjectInfoAccess(certificado, valor);
        }
        try {
            Boolean b = new Boolean(critical);
            ByteArrayInputStream bais = new ByteArrayInputStream(b.toString().getBytes("ISO8859_1"));
            StreamCopier sc = new StreamCopier((InputStream)bais, (OutputStream)criticidad);
            sc.copyStream();
            ((InputStream)bais).close();
        }
        catch (IOException ioe) {
            System.err.println(ioe);
        }
        return resultado;
    }

    private int getCrlDP(byte[] certificado, ByteArrayOutputStream baos) {
        int error = 0;
        try {
            X509Certificate cert = new X509Certificate(certificado);
            CRLDistributionPoints dp = (CRLDistributionPoints)cert.getExtension(CRLDistributionPoints.oid);
            String uri = null;
            if (dp != null) {
                critical = dp.isCritical();
                Enumeration e = dp.getDistributionPoints();
                DistributionPoint dp1 = null;
                for (int i = 0; e.hasMoreElements() && i < 1; ++i) {
                    dp1 = (DistributionPoint)e.nextElement();
                    String uriC = dp1.getDistributionPointName().toString();
                    StringTokenizer st = new StringTokenizer(uriC, " ");
                    st.nextToken();
                    uri = st.nextToken();
                }
            } else {
                error = 301;
            }
            if (uri != null) {
                StreamCopier sc = new StreamCopier((InputStream)new ByteArrayInputStream(uri.getBytes("ISO8859_1")), (OutputStream)baos);
                sc.copyStream();
            } else {
                baos = null;
            }
        }
        catch (CertificateException ce) {
            error = 302;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (X509ExtensionInitException pe) {
            System.err.println((Object)pe);
        }
        return error;
    }

    private int getAuthorityKeyIdentifier(byte[] certi, ByteArrayOutputStream baos) {
        AuthorityKeyIdentifier aki = new AuthorityKeyIdentifier();
        int error = 0;
        try {
            X509Certificate cert = new X509Certificate(certi);
            aki = (AuthorityKeyIdentifier)cert.getExtension(AuthorityKeyIdentifier.oid);
            if (aki != null) {
                critical = aki.isCritical();
                SubjectKeyIdentifier ski = new SubjectKeyIdentifier(aki.getKeyIdentifier());
                StreamCopier sc = new StreamCopier((InputStream)new ByteArrayInputStream(ski.toString().getBytes("ISO8859_1")), (OutputStream)baos);
                sc.copyStream();
            } else {
                error = 301;
            }
        }
        catch (X509ExtensionInitException ei) {
            System.err.println((Object)ei);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (CertificateException ce) {
            error = 302;
        }
        return error;
    }

    private int getSubjectKeyIdentifier(byte[] certi, ByteArrayOutputStream baos) {
        SubjectKeyIdentifier ski = new SubjectKeyIdentifier();
        int error = 0;
        try {
            X509Certificate cert = new X509Certificate(certi);
            ski = (SubjectKeyIdentifier)cert.getExtension(SubjectKeyIdentifier.oid);
            if (ski != null) {
                StreamCopier sc = new StreamCopier((InputStream)new ByteArrayInputStream(ski.toString().getBytes("ISO8859_1")), (OutputStream)baos);
                sc.copyStream();
                critical = ski.isCritical();
            } else {
                error = 301;
            }
        }
        catch (X509ExtensionInitException ei) {
            System.err.println((Object)ei);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (CertificateException ce) {
            error = 302;
        }
        return error;
    }

    private int getBasicConstraints(byte[] certi, ByteArrayOutputStream baos) {
        BasicConstraints bc = null;
        int error = 0;
        try {
            X509Certificate cert = new X509Certificate(certi);
            bc = (BasicConstraints)cert.getExtension(BasicConstraints.oid);
            if (bc != null) {
                critical = bc.isCritical();
                Boolean b = new Boolean(bc.ca());
                StreamCopier sc = new StreamCopier((InputStream)new ByteArrayInputStream(b.toString().getBytes("ISO8859_1")), (OutputStream)baos);
                sc.copyStream();
            } else {
                error = 301;
            }
        }
        catch (CertificateException ce) {
            error = 302;
        }
        catch (X509ExtensionInitException ei) {
            System.err.println((Object)ei);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return error;
    }

    private int getIssuerAltName(byte[] certi, ByteArrayOutputStream baos) {
        IssuerAltName ian = null;
        int error = 0;
        try {
            X509Certificate cert = new X509Certificate(certi);
            ian = (IssuerAltName)cert.getExtension(IssuerAltName.oid);
            if (ian != null) {
                StreamCopier sc = new StreamCopier((InputStream)new ByteArrayInputStream(ian.getName().getBytes("ISO8859_1")), (OutputStream)baos);
                sc.copyStream();
                critical = ian.isCritical();
            } else {
                error = 301;
            }
        }
        catch (CertificateException ce) {
            error = 302;
        }
        catch (X509ExtensionInitException ei) {
            System.err.println((Object)ei);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return error;
    }

    private int getNetscapeCertType(byte[] certi, ByteArrayOutputStream baos) {
        int error = 0;
        NetscapeCertType nct = null;
        try {
            X509Certificate cert = new X509Certificate(certi);
            nct = (NetscapeCertType)cert.getExtension(NetscapeCertType.oid);
            if (nct != null) {
                critical = nct.isCritical();
                StringTokenizer st = new StringTokenizer(nct.toString(), ":");
                Vector<String> v = new Vector<String>();
                while (st.hasMoreTokens()) {
                    v.addElement(st.nextToken());
                }
                String def = (String)v.elementAt(1);
                String salida = def.substring(1, def.length());
                StreamCopier sc = new StreamCopier((InputStream)new ByteArrayInputStream(salida.getBytes("ISO8859_1")), (OutputStream)baos);
                sc.copyStream();
            } else {
                error = 301;
            }
        }
        catch (CertificateException ce) {
            error = 302;
        }
        catch (X509ExtensionInitException ei) {
            System.err.println((Object)ei);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return error;
    }

    private int getAuthorityInfoAccess(byte[] certi, ByteArrayOutputStream baos) {
        AuthorityInfoAccess aia = null;
        int error = 0;
        try {
            X509Certificate cert = new X509Certificate(certi);
            aia = (AuthorityInfoAccess)cert.getExtension(AuthorityInfoAccess.oid);
            if (aia != null) {
                critical = aia.isCritical();
                Enumeration enu = aia.getAccessDescriptions();
                String loc = null;
                while (enu.hasMoreElements()) {
                    AccessDescription ad = (AccessDescription)enu.nextElement();
                    loc = ad.getAccessLocation().getName().toString();
                }
                StreamCopier sc = new StreamCopier((InputStream)new ByteArrayInputStream(loc.getBytes("ISO8859_1")), (OutputStream)baos);
                sc.copyStream();
            } else {
                error = 301;
            }
        }
        catch (CertificateException ce) {
            error = 302;
        }
        catch (X509ExtensionInitException ei) {
            System.err.println((Object)ei);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return error;
    }

    private int getSubjectDirectoryAttributes(byte[] certi, ByteArrayOutputStream dateOfBirth) {
        int error = 0;
        SubjectDirectoryAttributes sda = null;
        try {
            X509Certificate cert = new X509Certificate(certi);
            sda = (SubjectDirectoryAttributes)cert.getExtension(SubjectDirectoryAttributes.oid);
            if (sda != null) {
                critical = sda.isCritical();
                Attribute[] atribs = sda.getAttributes();
                GeneralizedTime gt = null;
                if (atribs != null) {
                    AttributeValue atribV = null;
                    for (int i = 0; i < atribs.length; ++i) {
                        atribV = atribs[i].getAttributeValue();
                        if (!atribV.getAttributeType().equals((Object)ObjectID.dateOfBirth)) continue;
                        gt = new GeneralizedTime(atribV.toASN1Object().getValue().toString());
                    }
                }
                if (gt != null) {
                    dateOfBirth.write(gt.getValue().toString().getBytes("ISO8859_1"));
                } else {
                    error = 301;
                }
            } else {
                error = 301;
            }
        }
        catch (CertificateException ce) {
            error = 302;
        }
        catch (X509ExtensionInitException ei) {
            System.err.println((Object)ei);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (CodingException coe) {
            coe.printStackTrace();
        }
        return error;
    }

    private int getSubjectInfoAccess(byte[] certIn, ByteArrayOutputStream sia) {
        int error = 0;
        SubjectInfoAccess subjectInfoAccess = null;
        try {
            X509Certificate cert = new X509Certificate(certIn);
            subjectInfoAccess = (SubjectInfoAccess)cert.getExtension(SubjectInfoAccess.oid);
            GeneralName gn = null;
            if (subjectInfoAccess != null) {
                critical = subjectInfoAccess.isCritical();
                Enumeration accessDs = subjectInfoAccess.getAccessDescriptions();
                AccessDescription ad = null;
                while (accessDs.hasMoreElements()) {
                    ad = (AccessDescription)accessDs.nextElement();
                    gn = ad.getAccessLocation();
                }
                sia.write(gn.getName().toString().getBytes("ISO8859_1"));
            } else {
                error = 301;
            }
        }
        catch (CertificateException ce) {
            error = 302;
            ce.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (X509ExtensionInitException xeie) {
            xeie.printStackTrace();
        }
        return error;
    }
}

