/*
 * Decompiled with CFR 0.152.
 */
package com.izenpe.accesoocsp;

import com.izenpe.AlgoritmosHash;
import com.izenpe.autenticacionfuerte.AutenticacionFuerte;
import com.izenpe.constanteserrores.ConstantesErrores;
import com.izenpe.gestioncontenedorseguro.GestionContenedorSeguro;
import com.izenpe.miscelanea.Miscelanea;
import iaik.asn1.CodingException;
import iaik.asn1.ObjectID;
import iaik.asn1.structures.AlgorithmID;
import iaik.asn1.structures.GeneralName;
import iaik.asn1.structures.Name;
import iaik.pkcs.PKCSParsingException;
import iaik.pkcs.pkcs7.ContentInfoStream;
import iaik.pkcs.pkcs7.SignedDataStream;
import iaik.pkcs.pkcs7.SignerInfo;
import iaik.security.provider.IAIK;
import iaik.utils.StreamCopier;
import iaik.x509.X509Certificate;
import iaik.x509.X509ExtensionException;
import iaik.x509.X509ExtensionInitException;
import iaik.x509.extensions.BasicConstraints;
import iaik.x509.extensions.ExtendedKeyUsage;
import iaik.x509.ocsp.BasicOCSPResponse;
import iaik.x509.ocsp.CertID;
import iaik.x509.ocsp.OCSPException;
import iaik.x509.ocsp.OCSPRequest;
import iaik.x509.ocsp.OCSPResponse;
import iaik.x509.ocsp.ReqCert;
import iaik.x509.ocsp.Request;
import iaik.x509.ocsp.SingleResponse;
import iaik.x509.ocsp.UnknownResponseException;
import iaik.x509.ocsp.net.HttpOCSPRequest;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.NoRouteToHostException;
import java.net.URL;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.Vector;

public class AccesoOCSP {
    public AccesoOCSP() {
        IAIK iaik = new IAIK();
        Security.insertProviderAt((Provider)iaik, 2);
        IAIK.addAsProvider((boolean)false);
    }

    public int requestOCSP(byte[] certIn, String pathCS, String passCS, ByteArrayOutputStream responseOCSPOut, ByteArrayOutputStream responseDateOut, ByteArrayOutputStream responseValueOut) {
        int error;
        block24: {
            error = ConstantesErrores.OK;
            try {
                GestionContenedorSeguro cs = GestionContenedorSeguro.getInstance(pathCS, passCS);
                X509Certificate cert = new X509Certificate(certIn);
                Vector vChain = new Vector();
                error = cs.getCertIssuer(cert, vChain);
                if (error != ConstantesErrores.OK) {
                    int n = error;
                    return n;
                }
                X509Certificate caCert = (X509Certificate)vChain.elementAt(1);
                AlgoritmosHash ah = new AlgoritmosHash();
                ah.setAlgorithm("sha");
                CertID certID = new CertID(ah.getAlgorithm(), caCert, cert);
                ReqCert reqCert = new ReqCert(0, (Object)certID);
                Request request = new Request(reqCert);
                OCSPRequest ocspRequest = new OCSPRequest();
                ocspRequest.setRequestList(new Request[]{request});
                AutenticacionFuerte af = new AutenticacionFuerte();
                ByteArrayOutputStream servidorOCSP = new ByteArrayOutputStream();
                ByteArrayOutputStream crit = new ByteArrayOutputStream();
                error = af.parseCert(certIn, "1.3.6.1.5.5.7.1.1", servidorOCSP, crit);
                if (error != ConstantesErrores.OK) {
                    int n = error;
                    return n;
                }
                HttpOCSPRequest httpOCSPRequest = new HttpOCSPRequest(new URL(servidorOCSP.toString("ISO8859_1")));
                httpOCSPRequest.postRequest(ocspRequest);
                OCSPResponse ocspResponse = httpOCSPRequest.getOCSPResponse();
                BasicOCSPResponse basicResponse = (BasicOCSPResponse)ocspResponse.getResponse();
                SingleResponse singleResponse = basicResponse.getSingleResponse(reqCert);
                ocspResponse.writeTo((OutputStream)responseOCSPOut);
                StreamCopier scDate = new StreamCopier((InputStream)new ByteArrayInputStream(basicResponse.getProducedAt().toString().getBytes("ISO8859_1")), (OutputStream)responseDateOut);
                scDate.copyStream();
                StreamCopier scStatus = new StreamCopier((InputStream)new ByteArrayInputStream(singleResponse.getCertStatus().getCertStatusName().getBytes("ISO8859_1")), (OutputStream)responseValueOut);
                scStatus.copyStream();
                X509Certificate[] tempTodoCerts = basicResponse.getCertificates();
                X509Certificate[] todoCerts = new X509Certificate[]{tempTodoCerts[0], tempTodoCerts[1]};
                X509Certificate ocspCert = todoCerts[0];
                basicResponse.verify(todoCerts[0].getPublicKey());
                ExtendedKeyUsage eku = (ExtendedKeyUsage)ocspCert.getExtension(ExtendedKeyUsage.oid);
                boolean ocspSigning = false;
                if (eku != null) {
                    ObjectID[] purposes = eku.getKeyPurposeIDs();
                    for (int i = 0; i < purposes.length; ++i) {
                        if (!purposes[i].equals((Object)ExtendedKeyUsage.ocspSigning)) continue;
                        ocspSigning = true;
                        break;
                    }
                }
                if (ocspSigning) {
                    Vector<X509Certificate> vChainOcsp = new Vector<X509Certificate>();
                    error = cs.getCertificateChain(ocspCert, vChainOcsp);
                    if (error != 0) {
                        vChainOcsp.addElement(ocspCert);
                        X509Certificate[] certsResponse = basicResponse.getCertificates();
                        if (certsResponse.length > 1) {
                            for (int j = 1; j < certsResponse.length; ++j) {
                                vChainOcsp.addElement(certsResponse[j]);
                            }
                        }
                        ByteArrayOutputStream ocspRaiz = new ByteArrayOutputStream();
                        error = cs.getRoot((X509Certificate)vChainOcsp.elementAt(vChainOcsp.size() - 1), ocspRaiz);
                        if (error != ConstantesErrores.OK) {
                            int n = error = ConstantesErrores.NO_OCSPCHAIN;
                            return n;
                        }
                        vChainOcsp.addElement(new X509Certificate(ocspRaiz.toByteArray()));
                    }
                    Object[] chainOcsp = new X509Certificate[vChainOcsp.size()];
                    vChainOcsp.copyInto(chainOcsp);
                    error = cs.comprobar((X509Certificate[])chainOcsp);
                    if (error != ConstantesErrores.OK) {
                        if (error == 22) {
                            error = ConstantesErrores.NO_OCSP_CA_EN_KS;
                        }
                        if (error == 34) {
                            error = ConstantesErrores.FIRMA_CADENA_INC;
                        }
                        int n = error;
                        return n;
                    }
                    break block24;
                }
                int n = error = ConstantesErrores.NO_OCSPSIGNING;
                return n;
            }
            catch (ConnectException coex) {
                int n = error = ConstantesErrores.CONN_REFUSED;
                return n;
            }
            catch (NoRouteToHostException nrthe) {
                error = ConstantesErrores.CONN_REFUSED;
            }
            catch (CertificateException ce) {
                error = ConstantesErrores.CERT_ENTRADA_ERR;
            }
            catch (NoSuchAlgorithmException nsae) {
                nsae.printStackTrace();
            }
            catch (X509ExtensionException ee) {
                ee.printStackTrace();
            }
            catch (MalformedURLException mue) {
                error = ConstantesErrores.URL_INCORRECTA;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            catch (UnknownResponseException ure) {
                ure.printStackTrace();
            }
            catch (OCSPException oe) {
                error = ConstantesErrores.RESPONSE_INCORRECTA;
            }
            catch (InvalidKeyException ike) {
                ike.printStackTrace();
            }
            catch (SignatureException se) {
                error = ConstantesErrores.ERR_VERIFYING_OCSP_SIGN;
            }
        }
        return error;
    }

    public int signedRequestOCSP(byte[] certIn, String requestorIssuerIn, String requestorSnIn, String pathCS, String passCS, ByteArrayOutputStream responseOCSPOut, ByteArrayOutputStream responseDateOut, ByteArrayOutputStream responseValueOut) {
        int error;
        block28: {
            error = ConstantesErrores.OK;
            try {
                X509Certificate cert = new X509Certificate(certIn);
                GestionContenedorSeguro cs = GestionContenedorSeguro.getInstance(pathCS, passCS);
                Vector vChain = new Vector();
                error = cs.getCertIssuer(cert, vChain);
                if (error != ConstantesErrores.OK) {
                    int n = error;
                    return n;
                }
                X509Certificate caCert = (X509Certificate)vChain.elementAt(1);
                PrivateKey requestorPK = cs.getPrivateKeyFromKeyStore(requestorIssuerIn, requestorSnIn);
                if (requestorPK == null) {
                    int n = ConstantesErrores.PK_NOENC;
                    return n;
                }
                ByteArrayOutputStream requestorCertAux = new ByteArrayOutputStream();
                error = cs.getCertCS(requestorIssuerIn, requestorSnIn, requestorCertAux);
                if (error != ConstantesErrores.OK) {
                    int n = error;
                    return n;
                }
                X509Certificate requestorCert = new X509Certificate(requestorCertAux.toByteArray());
                if (!this.isDigitalSignature(requestorCert.toByteArray())) {
                    int n = error = ConstantesErrores.NO_FIRMADIGITAL;
                    return n;
                }
                Vector requestorVchain = new Vector();
                error = cs.getCertificateChain(requestorCert, requestorVchain);
                if (error != ConstantesErrores.OK) {
                    int n = error = ConstantesErrores.NO_REQCHAIN;
                    return n;
                }
                Object[] requestorChain = new X509Certificate[requestorVchain.size()];
                requestorVchain.copyInto(requestorChain);
                X509Certificate[] chainSinRoot = new X509Certificate[requestorChain.length - 1];
                for (int i = 0; i < chainSinRoot.length; ++i) {
                    chainSinRoot[i] = requestorChain[i];
                }
                AlgoritmosHash ah = new AlgoritmosHash();
                ah.setAlgorithm("sha");
                CertID certId = new CertID(ah.getAlgorithm(), caCert, cert);
                ReqCert reqCert = new ReqCert(0, (Object)certId);
                Request request = new Request(reqCert);
                OCSPRequest ocspRequest = new OCSPRequest();
                ocspRequest.setRequestList(new Request[]{request});
                ocspRequest.setRequestorName(new GeneralName(4, (Object)requestorChain[0].getSubjectDN()));
                ocspRequest.setCertificates(chainSinRoot);
                ocspRequest.sign(AlgorithmID.sha1WithRSAEncryption, requestorPK);
                AutenticacionFuerte af = new AutenticacionFuerte();
                ByteArrayOutputStream servidorOCSP = new ByteArrayOutputStream();
                ByteArrayOutputStream crit = new ByteArrayOutputStream();
                error = af.parseCert(certIn, "1.3.6.1.5.5.7.1.1", servidorOCSP, crit);
                if (error != ConstantesErrores.OK) {
                    int n = error;
                    return n;
                }
                HttpOCSPRequest httpOCSPRequest = new HttpOCSPRequest(new URL(servidorOCSP.toString("ISO8859_1")));
                httpOCSPRequest.postRequest(ocspRequest);
                OCSPResponse ocspResponse = httpOCSPRequest.getOCSPResponse();
                BasicOCSPResponse basicResponse = (BasicOCSPResponse)ocspResponse.getResponse();
                SingleResponse singleResponse = basicResponse.getSingleResponse(reqCert);
                ocspResponse.writeTo((OutputStream)responseOCSPOut);
                StreamCopier scDate = new StreamCopier((InputStream)new ByteArrayInputStream(basicResponse.getProducedAt().toString().getBytes("ISO8859_1")), (OutputStream)responseDateOut);
                scDate.copyStream();
                StreamCopier scStatus = new StreamCopier((InputStream)new ByteArrayInputStream(singleResponse.getCertStatus().getCertStatusName().getBytes("ISO8859_1")), (OutputStream)responseValueOut);
                scStatus.copyStream();
                X509Certificate[] tempTodoCerts = basicResponse.getCertificates();
                X509Certificate[] todoCerts = new X509Certificate[]{tempTodoCerts[0], tempTodoCerts[1]};
                X509Certificate ocspCert = todoCerts[0];
                basicResponse.verify(todoCerts[0].getPublicKey());
                ExtendedKeyUsage eku = (ExtendedKeyUsage)ocspCert.getExtension(ExtendedKeyUsage.oid);
                boolean ocspSigning = false;
                if (eku != null) {
                    ObjectID[] purposes = eku.getKeyPurposeIDs();
                    for (int i = 0; i < purposes.length; ++i) {
                        if (!purposes[i].equals((Object)ExtendedKeyUsage.ocspSigning)) continue;
                        ocspSigning = true;
                        break;
                    }
                }
                if (ocspSigning) {
                    Vector<X509Certificate> vChainOcsp = new Vector<X509Certificate>();
                    error = cs.getCertificateChain(ocspCert, vChainOcsp);
                    if (error != 0) {
                        vChainOcsp.addElement(ocspCert);
                        X509Certificate[] certsResponse = todoCerts;
                        if (certsResponse.length > 1) {
                            for (int j = 1; j < certsResponse.length; ++j) {
                                vChainOcsp.addElement(certsResponse[j]);
                            }
                        }
                        ByteArrayOutputStream ocspRaiz = new ByteArrayOutputStream();
                        error = cs.getRoot((X509Certificate)vChainOcsp.elementAt(vChainOcsp.size() - 1), ocspRaiz);
                        if (error != ConstantesErrores.OK) {
                            int n = error = ConstantesErrores.NO_OCSPCHAIN;
                            return n;
                        }
                        vChainOcsp.addElement(new X509Certificate(ocspRaiz.toByteArray()));
                    }
                    Object[] chainOcsp = new X509Certificate[vChainOcsp.size()];
                    vChainOcsp.copyInto(chainOcsp);
                    error = cs.comprobar((X509Certificate[])chainOcsp);
                    if (error != ConstantesErrores.OK) {
                        if (error == 22) {
                            error = ConstantesErrores.NO_OCSP_CA_EN_KS;
                        }
                        if (error == 34) {
                            error = ConstantesErrores.FIRMA_CADENA_INC;
                        }
                        int n = error;
                        return n;
                    }
                    break block28;
                }
                int n = error = ConstantesErrores.NO_OCSPSIGNING;
                return n;
            }
            catch (ConnectException coex) {
                int n = error = ConstantesErrores.CONN_REFUSED;
                return n;
            }
            catch (NoRouteToHostException nrthe) {
                error = ConstantesErrores.CONN_REFUSED;
            }
            catch (CertificateException ce) {
                ce.printStackTrace();
                error = ConstantesErrores.CERT_ENTRADA_ERR;
            }
            catch (NoSuchAlgorithmException nsae) {
                nsae.printStackTrace();
            }
            catch (OCSPException oe) {
                error = ConstantesErrores.RESPONSE_INCORRECTA;
            }
            catch (InvalidKeyException ike) {
                ike.printStackTrace();
            }
            catch (X509ExtensionException ee) {
                ee.printStackTrace();
            }
            catch (MalformedURLException mue) {
                error = ConstantesErrores.URL_INCORRECTA;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            catch (SignatureException se) {
                error = ConstantesErrores.ERR_VERIFYING_OCSP_SIGN;
            }
        }
        return error;
    }

    public int parseResponseOCSP(byte[] responseIn, ByteArrayOutputStream hashAlgorithmOut, ByteArrayOutputStream dnHashCAOut, ByteArrayOutputStream pkHashCAOut, ByteArrayOutputStream snCertOut, ByteArrayOutputStream responseDateOut, ByteArrayOutputStream responseValueOut) {
        int error = ConstantesErrores.OK;
        try {
            OCSPResponse ocspResponse = new OCSPResponse(responseIn);
            BasicOCSPResponse basicResponse = (BasicOCSPResponse)ocspResponse.getResponse();
            SingleResponse[] singleResponses = basicResponse.getSingleResponses();
            SingleResponse singleResponse = singleResponses[0];
            ReqCert reqCert = singleResponse.getReqCert();
            CertID certID = (CertID)reqCert.getReqCert();
            AlgorithmID hash = certID.getHashAlgorithm();
            Date fecha = basicResponse.getProducedAt();
            SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss'Z'");
            df.setTimeZone(TimeZone.getTimeZone("UTC"));
            String time = df.format(fecha);
            responseDateOut.write(time.getBytes("ISO8859_1"));
            responseValueOut.write(singleResponse.getCertStatus().getCertStatusName().getBytes("ISO8859_1"));
            dnHashCAOut.write(certID.getIssuerNameHash());
            pkHashCAOut.write(certID.getIssuerKeyHash());
            hashAlgorithmOut.write(hash.toString().getBytes("ISO8859_1"));
            snCertOut.write(certID.getSerialNumber().toByteArray());
            BigInteger snb = new BigInteger(snCertOut.toByteArray());
            snCertOut.reset();
            snCertOut.write(snb.toString().getBytes("ISO8859_1"));
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (CodingException ac) {
            error = ConstantesErrores.RESPONSE_INCORRECTA;
        }
        catch (UnknownResponseException ure) {
            ure.printStackTrace();
        }
        return error;
    }

    public int requestOCSP_NoVerify(byte[] certIn, String pathCS, String passCS, ByteArrayOutputStream responseOCSPOut, ByteArrayOutputStream responseDateOut, ByteArrayOutputStream responseValueOut) {
        int error = ConstantesErrores.OK;
        try {
            GestionContenedorSeguro cs = GestionContenedorSeguro.getInstance(pathCS, passCS);
            X509Certificate cert = new X509Certificate(certIn);
            Vector vChain = new Vector();
            error = cs.getCertIssuer(cert, vChain);
            if (error != ConstantesErrores.OK) {
                int n = error;
                return n;
            }
            X509Certificate caCert = (X509Certificate)vChain.elementAt(1);
            AlgoritmosHash ah = new AlgoritmosHash();
            ah.setAlgorithm("sha");
            CertID certID = new CertID(ah.getAlgorithm(), caCert, cert);
            ReqCert reqCert = new ReqCert(0, (Object)certID);
            Request request = new Request(reqCert);
            OCSPRequest ocspRequest = new OCSPRequest();
            ocspRequest.setRequestList(new Request[]{request});
            AutenticacionFuerte af = new AutenticacionFuerte();
            ByteArrayOutputStream servidorOCSP = new ByteArrayOutputStream();
            ByteArrayOutputStream crit = new ByteArrayOutputStream();
            error = af.parseCert(certIn, "1.3.6.1.5.5.7.1.1", servidorOCSP, crit);
            if (error != ConstantesErrores.OK) {
                int n = error;
                return n;
            }
            HttpOCSPRequest httpOCSPRequest = new HttpOCSPRequest(new URL(servidorOCSP.toString("ISO8859_1")));
            httpOCSPRequest.postRequest(ocspRequest);
            OCSPResponse ocspResponse = httpOCSPRequest.getOCSPResponse();
            BasicOCSPResponse basicResponse = (BasicOCSPResponse)ocspResponse.getResponse();
            SingleResponse singleResponse = basicResponse.getSingleResponse(reqCert);
            ocspResponse.writeTo((OutputStream)responseOCSPOut);
            StreamCopier scDate = new StreamCopier((InputStream)new ByteArrayInputStream(basicResponse.getProducedAt().toString().getBytes("ISO8859_1")), (OutputStream)responseDateOut);
            scDate.copyStream();
            StreamCopier scStatus = new StreamCopier((InputStream)new ByteArrayInputStream(singleResponse.getCertStatus().getCertStatusName().getBytes("ISO8859_1")), (OutputStream)responseValueOut);
            scStatus.copyStream();
            X509Certificate[] tempTodoCerts = basicResponse.getCertificates();
            X509Certificate[] todoCerts = new X509Certificate[]{tempTodoCerts[0], tempTodoCerts[1]};
            X509Certificate ocspCert = todoCerts[0];
            basicResponse.verify(todoCerts[0].getPublicKey());
        }
        catch (ConnectException coex) {
            int n = error = ConstantesErrores.CONN_REFUSED;
            return n;
        }
        catch (NoRouteToHostException nrthe) {
            error = ConstantesErrores.CONN_REFUSED;
        }
        catch (CertificateException ce) {
            ce.printStackTrace();
            error = ConstantesErrores.CERT_ENTRADA_ERR;
        }
        catch (NoSuchAlgorithmException nsae) {
            nsae.printStackTrace();
        }
        catch (MalformedURLException mue) {
            error = ConstantesErrores.URL_INCORRECTA;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (OCSPException oe) {
            error = ConstantesErrores.RESPONSE_INCORRECTA;
        }
        catch (InvalidKeyException ike) {
            ike.printStackTrace();
        }
        catch (SignatureException se) {
            error = ConstantesErrores.ERR_VERIFYING_OCSP_SIGN;
        }
        return error;
    }

    public int signedRequestOCSP_NoVerify(byte[] certIn, String requestorIssuerIn, String requestorSnIn, String pathCS, String passCS, ByteArrayOutputStream responseOCSPOut, ByteArrayOutputStream responseDateOut, ByteArrayOutputStream responseValueOut) {
        int error = ConstantesErrores.OK;
        try {
            X509Certificate cert = new X509Certificate(certIn);
            GestionContenedorSeguro cs = GestionContenedorSeguro.getInstance(pathCS, passCS);
            Vector vChain = new Vector();
            error = cs.getCertIssuer(cert, vChain);
            if (error != ConstantesErrores.OK) {
                int n = error;
                return n;
            }
            X509Certificate caCert = (X509Certificate)vChain.elementAt(1);
            PrivateKey requestorPK = cs.getPrivateKeyFromKeyStore(requestorIssuerIn, requestorSnIn);
            if (requestorPK == null) {
                int n = ConstantesErrores.PK_NOENC;
                return n;
            }
            ByteArrayOutputStream requestorCertAux = new ByteArrayOutputStream();
            error = cs.getCertCS(requestorIssuerIn, requestorSnIn, requestorCertAux);
            if (error != ConstantesErrores.OK) {
                int n = error;
                return n;
            }
            X509Certificate requestorCert = new X509Certificate(requestorCertAux.toByteArray());
            if (!this.isDigitalSignature(requestorCert.toByteArray())) {
                int n = error = ConstantesErrores.NO_FIRMADIGITAL;
                return n;
            }
            Vector requestorVchain = new Vector();
            error = cs.getCertificateChain(requestorCert, requestorVchain);
            if (error != ConstantesErrores.OK) {
                int n = error = ConstantesErrores.NO_REQCHAIN;
                return n;
            }
            Object[] requestorChain = new X509Certificate[requestorVchain.size()];
            requestorVchain.copyInto(requestorChain);
            X509Certificate[] chainSinRoot = new X509Certificate[requestorChain.length - 1];
            for (int i = 0; i < chainSinRoot.length; ++i) {
                chainSinRoot[i] = requestorChain[i];
            }
            AlgoritmosHash ah = new AlgoritmosHash();
            ah.setAlgorithm("sha");
            CertID certId = new CertID(ah.getAlgorithm(), caCert, cert);
            ReqCert reqCert = new ReqCert(0, (Object)certId);
            Request request = new Request(reqCert);
            OCSPRequest ocspRequest = new OCSPRequest();
            ocspRequest.setRequestList(new Request[]{request});
            ocspRequest.setRequestorName(new GeneralName(4, (Object)requestorChain[0].getSubjectDN()));
            ocspRequest.setCertificates(chainSinRoot);
            ocspRequest.sign(AlgorithmID.sha1WithRSAEncryption, requestorPK);
            AutenticacionFuerte af = new AutenticacionFuerte();
            ByteArrayOutputStream servidorOCSP = new ByteArrayOutputStream();
            ByteArrayOutputStream crit = new ByteArrayOutputStream();
            error = af.parseCert(certIn, "1.3.6.1.5.5.7.1.1", servidorOCSP, crit);
            if (error != ConstantesErrores.OK) {
                int n = error;
                return n;
            }
            HttpOCSPRequest httpOCSPRequest = new HttpOCSPRequest(new URL(servidorOCSP.toString("ISO8859_1")));
            httpOCSPRequest.postRequest(ocspRequest);
            OCSPResponse ocspResponse = httpOCSPRequest.getOCSPResponse();
            BasicOCSPResponse basicResponse = (BasicOCSPResponse)ocspResponse.getResponse();
            SingleResponse singleResponse = basicResponse.getSingleResponse(reqCert);
            ocspResponse.writeTo((OutputStream)responseOCSPOut);
            StreamCopier scDate = new StreamCopier((InputStream)new ByteArrayInputStream(basicResponse.getProducedAt().toString().getBytes("ISO8859_1")), (OutputStream)responseDateOut);
            scDate.copyStream();
            StreamCopier scStatus = new StreamCopier((InputStream)new ByteArrayInputStream(singleResponse.getCertStatus().getCertStatusName().getBytes("ISO8859_1")), (OutputStream)responseValueOut);
            scStatus.copyStream();
            X509Certificate[] tempTodoCerts = basicResponse.getCertificates();
            X509Certificate[] todoCerts = new X509Certificate[]{tempTodoCerts[0], tempTodoCerts[1]};
            X509Certificate ocspCert = todoCerts[0];
            basicResponse.verify(todoCerts[0].getPublicKey());
        }
        catch (ConnectException coex) {
            int n = error = ConstantesErrores.CONN_REFUSED;
            return n;
        }
        catch (NoRouteToHostException nrthe) {
            error = ConstantesErrores.CONN_REFUSED;
        }
        catch (CertificateException ce) {
            ce.printStackTrace();
            error = ConstantesErrores.CERT_ENTRADA_ERR;
        }
        catch (NoSuchAlgorithmException nsae) {
            nsae.printStackTrace();
        }
        catch (OCSPException oe) {
            error = ConstantesErrores.RESPONSE_INCORRECTA;
        }
        catch (InvalidKeyException ike) {
            ike.printStackTrace();
        }
        catch (MalformedURLException mue) {
            error = ConstantesErrores.URL_INCORRECTA;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (SignatureException se) {
            error = ConstantesErrores.ERR_VERIFYING_OCSP_SIGN;
        }
        return error;
    }

    public int checkOCSPResponse(Vector vecOcspresponses, byte[] pkcs7, Vector vecCertificados, Vector vecDates, Vector vecErrores) {
        int error = 0;
        Miscelanea funciones = new Miscelanea();
        try {
            ByteArrayInputStream baisP7 = new ByteArrayInputStream(pkcs7);
            ContentInfoStream cis = new ContentInfoStream((InputStream)baisP7);
            SignedDataStream p7entrada = (SignedDataStream)cis.getContent();
            ByteArrayOutputStream certstream = new ByteArrayOutputStream();
            InputStream is2 = p7entrada.getInputStream();
            if (is2 != null) {
                StreamCopier scp = new StreamCopier(is2, (OutputStream)certstream);
                scp.copyStream();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(certstream.toByteArray());
            }
            X509Certificate[] cadenacert = p7entrada.getCertificates();
            SignerInfo[] signeres = p7entrada.getSignerInfos();
            Vector<X509Certificate> vectorCertificados = new Vector<X509Certificate>();
            for (int k = 0; k < cadenacert.length; ++k) {
                X509Certificate certPrueba = new X509Certificate();
                certPrueba = cadenacert[k];
                BasicConstraints bc = (BasicConstraints)certPrueba.getExtension(BasicConstraints.oid);
                if (bc != null && bc.ca()) continue;
                vectorCertificados.addElement(certPrueba);
            }
            for (int i = 0; i < vecOcspresponses.size(); ++i) {
                ByteArrayOutputStream valueOut;
                ByteArrayOutputStream dateOut;
                ByteArrayOutputStream snCert;
                ByteArrayOutputStream pbkHash;
                ByteArrayOutputStream hasCA;
                ByteArrayOutputStream hashAlg;
                ByteArrayOutputStream dateSalida = new ByteArrayOutputStream();
                byte[] ocspresponse = (byte[])vecOcspresponses.elementAt(i);
                error = this.parseResponseOCSP(ocspresponse, hashAlg = new ByteArrayOutputStream(), hasCA = new ByteArrayOutputStream(), pbkHash = new ByteArrayOutputStream(), snCert = new ByteArrayOutputStream(), dateOut = new ByteArrayOutputStream(), valueOut = new ByteArrayOutputStream());
                if (error != 0) {
                    int n = error;
                    return n;
                }
                dateSalida.write(dateOut.toByteArray());
                ByteArrayOutputStream hasCAB64 = new ByteArrayOutputStream();
                error = funciones.binBase64(hasCA.toByteArray(), hasCAB64);
                if (error != 0) {
                    int n = error;
                    return n;
                }
                boolean encontrado = false;
                for (int j = 0; j < vectorCertificados.size(); ++j) {
                    X509Certificate cert = new X509Certificate();
                    cert = (X509Certificate)vectorCertificados.elementAt(j);
                    AlgoritmosHash algm = new AlgoritmosHash();
                    algm.setAlgorithm("SHA");
                    Name issuerName = (Name)cert.getIssuerDN();
                    byte[] encodedIssuerName = issuerName.getEncoded();
                    ByteArrayOutputStream salidaHash = new ByteArrayOutputStream();
                    error = funciones.newHash(algm.getAlgorithm(), encodedIssuerName, salidaHash);
                    if (error != 0) {
                        int n = error;
                        return n;
                    }
                    if (!salidaHash.toString("ISO8859_1").equals(hasCAB64.toString("ISO8859_1")) || !cert.getSerialNumber().toString().equals(snCert.toString("ISO8859_1"))) continue;
                    encontrado = true;
                    if (valueOut.toString("ISO8859_1").equalsIgnoreCase("REVOKED")) {
                        vecErrores.addElement("1022");
                    }
                    if (valueOut.toString("ISO8859_1").equalsIgnoreCase("UNKNOWN")) {
                        vecErrores.addElement("1023");
                    }
                    if (valueOut.toString("ISO8859_1").equalsIgnoreCase("GOOD")) {
                        vecErrores.addElement("0");
                    }
                    vecDates.addElement(dateSalida);
                    vecCertificados.addElement(cert);
                }
                if (encontrado) continue;
                vecErrores.addElement("1018");
                vecDates.addElement(dateSalida);
                vecCertificados.addElement("-1");
            }
            if (vectorCertificados.size() != vecOcspresponses.size()) {
                error = 1021;
            }
            for (int h = 0; h < vecErrores.size(); ++h) {
                if (vecErrores.elementAt(h).toString().equals("0")) continue;
                error = 1019;
                int n = 1019;
                return n;
            }
        }
        catch (X509ExtensionInitException xe) {
            error = 1020;
            int n = 1020;
            return n;
        }
        catch (PKCSParsingException pkcspe) {
            error = 1020;
            int n = 1020;
            return n;
        }
        catch (IOException coe) {
            error = 1019;
            int n = 1019;
            return n;
        }
        return error;
    }

    private boolean isDigitalSignature(byte[] certificado) {
        boolean digitalSignature = false;
        try {
            X509Certificate cert = new X509Certificate(certificado);
            boolean[] b = cert.getKeyUsage();
            digitalSignature = b[0];
        }
        catch (CertificateException ce) {
            System.err.println(ce);
        }
        return digitalSignature;
    }
}

