//    Openbravo POS is a point of sales application designed for touch screens.
//    Copyright (C) 2007-2008 Openbravo, S.L.
//    http://sourceforge.net/projects/openbravopos
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

report = new com.openbravo.pos.reports.PanelReportBean();

report.setTitleKey("Menu.CustomersDiary");
report.setReport("/com/openbravo/reports/customersdiary");
report.setResourceBundle("com/openbravo/reports/customersdiary_messages");

report.setSentence("SELECT RECEIPTS.DATENEW, TICKETS.TICKETID, PAYMENTS.PAYMENT, PAYMENTS.TOTAL, CUSTOMERS.TAXID, CUSTOMERS.NAME " +
                 "FROM RECEIPTS, TICKETS, CUSTOMERS, PAYMENTS WHERE RECEIPTS.ID = TICKETS.ID AND RECEIPTS.ID = PAYMENTS.RECEIPT " +
                 "AND TICKETS.CUSTOMER = CUSTOMERS.ID AND (PAYMENTS.PAYMENT = 'debt' OR PAYMENTS.PAYMENT = 'debtpaid') AND ?(QBF_FILTER) " +
                 "ORDER BY CUSTOMERS.NAME");
report.addParameter("CUSTOMERS.ID");
report.addParameter("CUSTOMERS.NAME");
report.addQBFFilter(new com.openbravo.pos.reports.JParamsCustomer());

report.addParameter("RECEIPTS.DATENEW");
report.addParameter("RECEIPTS.DATENEW");
report.addQBFFilter(new com.openbravo.pos.reports.JParamsDatesInterval());

report.addField("DATENEW", com.openbravo.data.loader.Datas.TIMESTAMP);
report.addField("TICKETID", com.openbravo.data.loader.Datas.STRING);
report.addField("PAYMENT", com.openbravo.data.loader.Datas.STRING);
report.addField("TOTAL", com.openbravo.data.loader.Datas.DOUBLE);
report.addField("TAXID", com.openbravo.data.loader.Datas.STRING);
report.addField("NAME", com.openbravo.data.loader.Datas.STRING);

return report;

