/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.utils.icon;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.jvnet.lafwidget.animation.FadeKind;
import org.jvnet.lafwidget.animation.FadeTracker;
import org.jvnet.substance.utils.SubstanceColorUtilities;
import org.jvnet.substance.utils.SubstanceCoreUtilities;

public class GlowingIcon
implements Icon {
    protected Icon delegate;
    protected Component component;
    protected Map<Float, Icon> iconMap;

    public GlowingIcon(Icon delegate, Component component) {
        this.delegate = delegate;
        this.component = component;
        this.iconMap = new HashMap<Float, Icon>();
    }

    public Icon getDelegate() {
        return this.delegate;
    }

    public int getIconHeight() {
        if (this.delegate == null) {
            return 0;
        }
        return this.delegate.getIconHeight();
    }

    public int getIconWidth() {
        if (this.delegate == null) {
            return 0;
        }
        return this.delegate.getIconWidth();
    }

    public synchronized void paintIcon(Component c, Graphics g, int x, int y) {
        if (this.delegate == null) {
            return;
        }
        float fadePos = FadeTracker.getInstance().getFade10(this.component, FadeKind.ICON_GLOW);
        Icon toPaint = this.iconMap.get(Float.valueOf(fadePos));
        if (toPaint == null) {
            int width = this.getIconWidth();
            int height = this.getIconHeight();
            BufferedImage image = SubstanceCoreUtilities.getBlankImage(width, height);
            Graphics2D graphics = (Graphics2D)image.getGraphics();
            this.delegate.paintIcon(c, graphics, 0, 0);
            for (int i = 0; i < width; ++i) {
                for (int j = 0; j < height; ++j) {
                    int rgba = image.getRGB(i, j);
                    int transp = rgba >>> 24 & 0xFF;
                    double coef = Math.sin(Math.PI * 2 * (double)fadePos / 20.0) / 3.0;
                    Color newColor = coef >= 0.0 ? SubstanceColorUtilities.getLighterColor(new Color(rgba), coef) : SubstanceColorUtilities.getDarkerColor(new Color(rgba), -coef);
                    image.setRGB(i, j, transp << 24 | newColor.getRed() << 16 | newColor.getGreen() << 8 | newColor.getBlue());
                }
            }
            toPaint = new ImageIcon(image);
            this.iconMap.put(Float.valueOf(fadePos), toPaint);
        }
        toPaint.paintIcon(c, g, x, y);
    }
}

