/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.fonts;

import java.awt.Font;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import javax.swing.UIDefaults;
import org.jvnet.substance.fonts.FontPolicy;
import org.jvnet.substance.fonts.FontSet;
import org.jvnet.substance.fonts.FontSets;

public class DefaultKDEFontPolicy
implements FontPolicy {
    private static final String SANS_SERIF = "sans";
    private static FontSet fontSet = null;

    public static boolean isKDERunning() {
        return "true".equals(System.getenv("KDE_FULL_SESSION"));
    }

    public synchronized FontSet getFontSet(String lafName, UIDefaults table) {
        if (fontSet == null) {
            String titleFamily;
            String menuFamily;
            String commonFamily;
            int titleStyle;
            int menuStyle;
            int commonStyle;
            int titleSize;
            int menuSize;
            int commonSize;
            block19: {
                commonSize = 10;
                menuSize = 10;
                titleSize = 10;
                commonStyle = 0;
                menuStyle = 0;
                titleStyle = 1;
                commonFamily = SANS_SERIF;
                menuFamily = SANS_SERIF;
                titleFamily = SANS_SERIF;
                try {
                    boolean italic;
                    boolean bold;
                    String[] params;
                    String font;
                    String kdeglobals = this.getFileContent(".kde/share/config/kdeglobals");
                    try {
                        font = this.getIniParam(kdeglobals, "[General]", "font");
                        params = font.split(",");
                        commonSize = Integer.parseInt(params[1]);
                        bold = "75".equals(params[4]);
                        italic = "1".equals(params[5]);
                        commonStyle = bold && italic ? 3 : (italic ? 2 : (bold ? 1 : 0));
                    }
                    catch (Exception fontReadingException) {
                        commonStyle = 0;
                        commonSize = 10;
                        commonFamily = SANS_SERIF;
                    }
                    try {
                        font = this.getIniParam(kdeglobals, "[General]", "menuFont");
                        params = font.split(",");
                        menuSize = Integer.parseInt(params[1]);
                        bold = "75".equals(params[4]);
                        italic = "1".equals(params[5]);
                        menuStyle = bold && italic ? 3 : (italic ? 2 : (bold ? 1 : 0));
                    }
                    catch (Exception menuFontException) {
                        menuSize = 10;
                        menuStyle = 0;
                        menuFamily = SANS_SERIF;
                    }
                    try {
                        font = this.getIniParam(kdeglobals, "[WM]", "activeFont");
                        params = font.split(",");
                        titleSize = Integer.parseInt(params[1]);
                        bold = "75".equals(params[4]);
                        italic = "1".equals(params[5]);
                        if (bold && italic) {
                            titleStyle = 3;
                            break block19;
                        }
                        if (italic) {
                            titleStyle = 2;
                            break block19;
                        }
                        if (bold) {
                            titleStyle = 1;
                            break block19;
                        }
                        titleStyle = 0;
                    }
                    catch (Exception titleFontException) {
                        titleSize = 10;
                        titleStyle = 1;
                        titleFamily = SANS_SERIF;
                    }
                }
                catch (Exception kdeglobalsReadingException) {
                    commonSize = 10;
                    menuSize = 10;
                    titleSize = 10;
                    commonStyle = 0;
                    menuStyle = 0;
                    titleStyle = 1;
                    commonFamily = SANS_SERIF;
                    menuFamily = SANS_SERIF;
                    titleFamily = SANS_SERIF;
                }
            }
            double dcommonSize = commonSize;
            double dmenuSize = menuSize;
            double dtitleSize = titleSize;
            int dpi = 96;
            try {
                String dpiParam = this.getIniParam(this.getFileContent(".kde/share/config/kcmfonts"), "[General]", "forceFontDPI");
                dpi = Integer.parseInt(dpiParam);
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (dpi < 0) {
                dpi = 96;
            }
            if (dpi < 50) {
                dpi = 50;
            }
            dcommonSize = (double)(commonSize * dpi) / 72.0;
            dmenuSize = (double)(menuSize * dpi) / 72.0;
            dtitleSize = (double)(titleSize * dpi) / 72.0;
            commonSize = (int)(dcommonSize + 0.5);
            if (commonSize < 1) {
                commonSize = 1;
            }
            if ((menuSize = (int)(dmenuSize + 0.5)) < 1) {
                menuSize = 1;
            }
            if ((titleSize = (int)(dtitleSize + 0.5)) < 1) {
                titleSize = 1;
            }
            Font commonFont = new Font(commonFamily, commonStyle, commonSize);
            Font menuFont = new Font(menuFamily, menuStyle, menuSize);
            Font titleFont = new Font(titleFamily, titleStyle, titleSize);
            fontSet = FontSets.createDefaultFontSet(commonFont, menuFont, commonFont, commonFont, commonFont, titleFont);
        }
        return fontSet;
    }

    private String getIniParam(String content, String category, String param) throws Exception {
        int paramIndex;
        int categoryIndex = content.indexOf(category);
        int nextCategoryIndex = content.indexOf(91, categoryIndex + 1);
        if (nextCategoryIndex < 0) {
            nextCategoryIndex = content.length();
        }
        if ((paramIndex = content.indexOf(param, categoryIndex)) >= 0 && paramIndex < nextCategoryIndex) {
            String paramString = content.substring(paramIndex, content.indexOf(System.getProperty("line.separator"), paramIndex)).trim();
            int equalityIndex = paramString.indexOf(61);
            return paramString.substring(equalityIndex + 1);
        }
        throw new Exception("No such param in current category");
    }

    private String getFileContent(String filePath) throws IOException {
        String fileSeparator = System.getProperty("file.separator");
        if (!"/".equals(fileSeparator)) {
            filePath = filePath.replace("/", fileSeparator);
        }
        BufferedReader in = new BufferedReader(new FileReader(System.getProperty("user.home") + fileSeparator + filePath));
        StringBuilder sb = new StringBuilder();
        char[] buffer = new char[8192];
        int read = 0;
        while ((read = in.read(buffer)) >= 0) {
            sb.append(buffer, 0, read);
        }
        in.close();
        return sb.toString();
    }
}

