/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JSeparator;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicPopupMenuSeparatorUI;
import org.jvnet.lafwidget.LafWidget;
import org.jvnet.lafwidget.LafWidgetRepository;
import org.jvnet.lafwidget.layout.TransitionLayout;
import org.jvnet.lafwidget.utils.RenderingUtils;
import org.jvnet.substance.SubstanceFillBackgroundDelegate;
import org.jvnet.substance.color.ColorScheme;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.utils.ComponentState;
import org.jvnet.substance.utils.SubstanceConstants;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceSizeUtils;
import org.jvnet.substance.utils.SubstanceThemeUtilities;
import org.jvnet.substance.utils.menu.MenuUtilities;

public class SubstancePopupMenuSeparatorUI
extends BasicPopupMenuSeparatorUI {
    protected Set lafWidgets;
    private SubstanceFillBackgroundDelegate fillBackgroundDelegate = new SubstanceFillBackgroundDelegate();

    public void __org__jvnet__substance__SubstancePopupMenuSeparatorUI__update(Graphics graphics, JComponent jComponent) {
        super.update(graphics, jComponent);
    }

    public void update(Graphics graphics, JComponent jComponent) {
        Object object;
        Graphics2D graphics2D = (Graphics2D)graphics;
        Composite composite = graphics2D.getComposite();
        float f = 1.0f;
        if (composite instanceof AlphaComposite && ((AlphaComposite)(object = (AlphaComposite)composite)).getRule() == 3) {
            f = ((AlphaComposite)object).getAlpha();
        }
        graphics2D.setComposite(TransitionLayout.getAlphaComposite((Component)jComponent, f));
        object = RenderingUtils.installDesktopHints(graphics2D);
        this.__org__jvnet__substance__SubstancePopupMenuSeparatorUI__update(graphics2D, jComponent);
        graphics2D.setComposite(composite);
        if (object != null) {
            graphics2D.addRenderingHints((Map<?, ?>)object);
        }
    }

    public void __org__jvnet__substance__SubstancePopupMenuSeparatorUI__installUI(JComponent jComponent) {
        super.installUI(jComponent);
    }

    public void installUI(JComponent jComponent) {
        this.lafWidgets = LafWidgetRepository.getRepository().getMatchingWidgets(jComponent);
        this.__org__jvnet__substance__SubstancePopupMenuSeparatorUI__installUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installUI();
        }
    }

    public void __org__jvnet__substance__SubstancePopupMenuSeparatorUI__uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
    }

    public void uninstallUI(JComponent jComponent) {
        this.__org__jvnet__substance__SubstancePopupMenuSeparatorUI__uninstallUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallUI();
        }
    }

    public void __org__jvnet__substance__SubstancePopupMenuSeparatorUI__installListeners(JSeparator jSeparator) {
        super.installListeners(jSeparator);
    }

    public void installListeners(JSeparator jSeparator) {
        this.__org__jvnet__substance__SubstancePopupMenuSeparatorUI__installListeners(jSeparator);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installListeners();
        }
    }

    public void __org__jvnet__substance__SubstancePopupMenuSeparatorUI__installDefaults(JSeparator jSeparator) {
        super.installDefaults(jSeparator);
    }

    public void installDefaults(JSeparator jSeparator) {
        this.__org__jvnet__substance__SubstancePopupMenuSeparatorUI__installDefaults(jSeparator);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installDefaults();
        }
    }

    public void __org__jvnet__substance__SubstancePopupMenuSeparatorUI__uninstallListeners(JSeparator jSeparator) {
        super.uninstallListeners(jSeparator);
    }

    public void uninstallListeners(JSeparator jSeparator) {
        this.__org__jvnet__substance__SubstancePopupMenuSeparatorUI__uninstallListeners(jSeparator);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallListeners();
        }
    }

    public void __org__jvnet__substance__SubstancePopupMenuSeparatorUI__uninstallDefaults(JSeparator jSeparator) {
        super.uninstallDefaults(jSeparator);
    }

    public void uninstallDefaults(JSeparator jSeparator) {
        this.__org__jvnet__substance__SubstancePopupMenuSeparatorUI__uninstallDefaults(jSeparator);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallDefaults();
        }
    }

    public static ComponentUI createUI(JComponent c) {
        return new SubstancePopupMenuSeparatorUI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g, JComponent c) {
        Graphics2D graphics = (Graphics2D)g.create();
        SubstanceTheme theme = SubstanceThemeUtilities.getTheme(c).getDefaultTheme();
        boolean isDark = SubstanceCoreUtilities.isThemeDark(theme.getActiveTheme());
        ColorScheme colorScheme = theme.getColorScheme();
        try {
            JSeparator sep = (JSeparator)c;
            this.fillBackgroundDelegate.updateIfOpaque(graphics, c);
            int xOffset = MenuUtilities.getTextOffset(sep, sep.getParent());
            Dimension s = c.getSize();
            int startX = 0;
            int width = s.width;
            if (c.getComponentOrientation().isLeftToRight()) {
                SubstanceConstants.MenuGutterFillKind fillKind = SubstanceCoreUtilities.getMenuGutterFillKind();
                if (fillKind != SubstanceConstants.MenuGutterFillKind.NONE) {
                    ColorScheme scheme = SubstanceThemeUtilities.getTheme(sep, ComponentState.DEFAULT).getColorScheme();
                    Color leftColor = fillKind == SubstanceConstants.MenuGutterFillKind.SOFT_FILL || fillKind == SubstanceConstants.MenuGutterFillKind.HARD ? scheme.getUltraLightColor() : scheme.getLightColor();
                    Color rightColor = fillKind == SubstanceConstants.MenuGutterFillKind.SOFT_FILL || fillKind == SubstanceConstants.MenuGutterFillKind.SOFT ? scheme.getUltraLightColor() : scheme.getLightColor();
                    GradientPaint gp = new GradientPaint(0.0f, 0.0f, leftColor, xOffset, 0.0f, rightColor);
                    graphics.setComposite(TransitionLayout.getAlphaComposite(sep, 0.7f, g));
                    graphics.setPaint(gp);
                    graphics.fillRect(0, 0, xOffset - 2, c.getHeight());
                }
                startX = xOffset - 2;
                width = s.width - startX;
            } else {
                SubstanceConstants.MenuGutterFillKind fillKind = SubstanceCoreUtilities.getMenuGutterFillKind();
                if (fillKind != SubstanceConstants.MenuGutterFillKind.NONE) {
                    ColorScheme scheme = SubstanceThemeUtilities.getTheme(sep, ComponentState.DEFAULT).getColorScheme();
                    Color leftColor = fillKind == SubstanceConstants.MenuGutterFillKind.HARD_FILL || fillKind == SubstanceConstants.MenuGutterFillKind.HARD ? scheme.getLightColor() : scheme.getUltraLightColor();
                    Color rightColor = fillKind == SubstanceConstants.MenuGutterFillKind.HARD_FILL || fillKind == SubstanceConstants.MenuGutterFillKind.SOFT ? scheme.getLightColor() : scheme.getUltraLightColor();
                    GradientPaint gp = new GradientPaint(xOffset, 0.0f, leftColor, s.width, 0.0f, rightColor);
                    graphics.setComposite(TransitionLayout.getAlphaComposite(sep, 0.7f, g));
                    graphics.setPaint(gp);
                    graphics.fillRect(xOffset - 2, 0, s.width, c.getHeight());
                }
                startX = 0;
                width = xOffset - 4;
            }
            graphics.translate(startX, 0);
            graphics.setComposite(TransitionLayout.getAlphaComposite(sep));
            SubstanceCoreUtilities.paintSeparator(sep, graphics, colorScheme, isDark, width, s.height, sep.getOrientation(), true, 2);
        }
        finally {
            graphics.dispose();
        }
    }

    public Dimension getPreferredSize(JComponent c) {
        float borderStrokeWidth = SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(c));
        int prefSize = (int)Math.ceil(2.0 * (double)borderStrokeWidth);
        return new Dimension(0, prefSize);
    }
}

