/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.lafwidget.menu;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import org.jvnet.lafwidget.LafWidgetAdapter;
import org.jvnet.lafwidget.LafWidgetRepository;
import org.jvnet.lafwidget.LafWidgetSupport;
import org.jvnet.lafwidget.LafWidgetUtilities;
import org.jvnet.lafwidget.Resettable;

public class MenuSearchWidget
extends LafWidgetAdapter
implements Resettable {
    protected JMenuBar jmb;
    private boolean inEvent = false;
    protected PropertyChangeListener propertyListener;
    private SearchPanel searchPanel;

    private static int getMenuItemCount(JMenuItem menuItem) {
        int result = 1;
        if (menuItem instanceof JMenu) {
            JMenu menu = (JMenu)menuItem;
            for (int i = 0; i < menu.getMenuComponentCount(); ++i) {
                Component child = menu.getMenuComponent(i);
                if (!(child instanceof JMenuItem)) continue;
                result += MenuSearchWidget.getMenuItemCount((JMenuItem)child);
            }
        }
        return result;
    }

    public static int getMenuItemCount(JMenuBar menuBar) {
        int result = 0;
        for (int i = 0; i < menuBar.getMenuCount(); ++i) {
            JMenu menu = menuBar.getMenu(i);
            if (menu == null) continue;
            result += MenuSearchWidget.getMenuItemCount(menu);
        }
        return result;
    }

    private static void hideSearchPanels(Component comp, boolean toRepaint) {
        JInternalFrame jif;
        SearchPanel sPanel;
        int j;
        JMenuBar menuBar;
        JFrame jf;
        if (comp instanceof JFrame && (jf = (JFrame)comp).getRootPane() != null && (menuBar = jf.getJMenuBar()) != null) {
            for (j = 0; j < menuBar.getComponentCount(); ++j) {
                if (!(menuBar.getComponent(j) instanceof SearchPanel)) continue;
                sPanel = (SearchPanel)menuBar.getComponent(j);
                menuBar.remove(sPanel);
                if (!toRepaint) break;
                menuBar.repaint();
                break;
            }
        }
        if (comp instanceof JInternalFrame && (jif = (JInternalFrame)comp).getRootPane() != null && (menuBar = jif.getJMenuBar()) != null) {
            for (j = 0; j < menuBar.getComponentCount(); ++j) {
                if (!(menuBar.getComponent(j) instanceof SearchPanel)) continue;
                sPanel = (SearchPanel)menuBar.getComponent(j);
                menuBar.remove(sPanel);
                if (!toRepaint) break;
                menuBar.repaint();
                break;
            }
        }
        if (comp instanceof Container) {
            Container cont = (Container)comp;
            for (int i = 0; i < cont.getComponentCount(); ++i) {
                Component child = cont.getComponent(i);
                if (child instanceof JInternalFrame.JDesktopIcon) {
                    child = ((JInternalFrame.JDesktopIcon)child).getInternalFrame();
                }
                MenuSearchWidget.hideSearchPanels(child, toRepaint);
            }
        }
    }

    public static void hideSearchPanels(final boolean toRepaint) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Frame[] frames = Frame.getFrames();
                for (int i = 0; i < frames.length; ++i) {
                    MenuSearchWidget.hideSearchPanels(frames[i], toRepaint);
                }
            }
        });
    }

    protected static void showSearchPanels(Component comp) {
        if (comp instanceof JDesktopPane) {
            JDesktopPane desktop = (JDesktopPane)comp;
            JInternalFrame[] iFrames = desktop.getAllFrames();
            for (int i = 0; i < iFrames.length; ++i) {
                JMenuBar menuBar;
                JInternalFrame jif = iFrames[i];
                if (jif.getRootPane() == null || (menuBar = jif.getJMenuBar()) == null) continue;
                SwingUtilities.updateComponentTreeUI(menuBar);
            }
            return;
        }
        if (comp instanceof Container) {
            Container cont = (Container)comp;
            for (int i = 0; i < cont.getComponentCount(); ++i) {
                MenuSearchWidget.showSearchPanels(cont.getComponent(i));
            }
        }
    }

    public static void showSearchPanels() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Frame[] frames = Frame.getFrames();
                for (int i = 0; i < frames.length; ++i) {
                    JMenuBar menuBar;
                    JFrame jf;
                    Frame frame = frames[i];
                    if (frame instanceof JFrame && (jf = (JFrame)frame).getRootPane() != null && (menuBar = jf.getJMenuBar()) != null) {
                        SwingUtilities.updateComponentTreeUI(menuBar);
                    }
                    MenuSearchWidget.showSearchPanels(frame);
                }
            }
        });
    }

    public void setComponent(JComponent jcomp) {
        super.setComponent(jcomp);
        this.jmb = (JMenuBar)jcomp;
    }

    public void installUI() {
        final LafWidgetSupport lafSupport = LafWidgetRepository.getRepository().getLafSupport();
        this.searchPanel = new SearchPanel(this.jmb);
        this.jmb.add((Component)this.searchPanel, this.jmb.getComponentCount());
        this.searchPanel.setVisible(lafSupport.toInstallMenuSearch(this.jmb));
        this.jmb.addContainerListener(new ContainerAdapter(){

            public void componentAdded(ContainerEvent e) {
                if (!(e.getChild() instanceof JMenu)) {
                    return;
                }
                if (!MenuSearchWidget.this.inEvent) {
                    MenuSearchWidget.this.inEvent = true;
                    Component removed = null;
                    for (int i = 0; i < MenuSearchWidget.this.jmb.getComponentCount(); ++i) {
                        if (!(MenuSearchWidget.this.jmb.getComponent(i) instanceof SearchPanel)) continue;
                        removed = MenuSearchWidget.this.jmb.getComponent(i);
                        break;
                    }
                    if (removed != null) {
                        MenuSearchWidget.this.jmb.remove(removed);
                        MenuSearchWidget.this.jmb.add(removed, MenuSearchWidget.this.jmb.getComponentCount());
                        if (lafSupport.toInstallMenuSearch(MenuSearchWidget.this.jmb)) {
                            removed.setVisible(true);
                        } else {
                            removed.setVisible(false);
                        }
                    }
                    MenuSearchWidget.this.inEvent = false;
                }
            }
        });
        this.searchPanel.applyComponentOrientation(this.jmb.getComponentOrientation());
    }

    public void uninstallUI() {
        this.jmb.remove(this.searchPanel);
        super.uninstallUI();
    }

    public void installListeners() {
        super.installListeners();
        this.propertyListener = new PropertyChangeListener(){

            public void propertyChange(final PropertyChangeEvent evt) {
                if ("componentOrientation".equals(evt.getPropertyName())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            if (MenuSearchWidget.this.searchPanel != null) {
                                MenuSearchWidget.this.searchPanel.applyComponentOrientation((ComponentOrientation)evt.getNewValue());
                            }
                            MenuSearchWidget.this.reset();
                        }
                    });
                }
                if ("locale".equals(evt.getPropertyName())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            MenuSearchWidget.this.reset();
                        }
                    });
                }
            }
        };
        this.jmb.addPropertyChangeListener(this.propertyListener);
    }

    public void uninstallListeners() {
        this.jmb.removePropertyChangeListener(this.propertyListener);
        this.propertyListener = null;
    }

    public void reset() {
        LafWidgetSupport support = LafWidgetRepository.getRepository().getLafSupport();
        if (this.searchPanel == null) {
            return;
        }
        for (Map.Entry entry : this.searchPanel.resultButtons.entrySet()) {
            int index = (Integer)entry.getKey();
            JButton button = (JButton)entry.getValue();
            Icon markerIcon = support == null ? LafWidgetUtilities.getHexaMarker(index) : support.getNumberIcon(index);
            button.setIcon(markerIcon);
        }
        int iconDim = support.getLookupIconSize();
        Icon searchIcon = support == null ? LafWidgetUtilities.getSearchIcon(iconDim, this.searchPanel.getComponentOrientation().isLeftToRight()) : support.getSearchIcon(iconDim, this.searchPanel.getComponentOrientation());
        this.searchPanel.searchButton.setIcon(searchIcon);
        ResourceBundle bundle = LafWidgetUtilities.getResourceBundle(this.jmb);
        this.searchPanel.searchButton.setToolTipText(bundle.getString("Tooltip.menuSearchButton"));
        this.searchPanel.searchStringField.setToolTipText(bundle.getString("Tooltip.menuSearchField"));
    }

    public boolean requiresCustomLafSupport() {
        return false;
    }

    private class SearchResultsLayout
    implements LayoutManager {
        private SearchPanel searchPanel;

        public SearchResultsLayout(SearchPanel searchPanel) {
            this.searchPanel = searchPanel;
        }

        public void addLayoutComponent(String name, Component c) {
        }

        public void removeLayoutComponent(Component c) {
        }

        public Dimension preferredLayoutSize(Container c) {
            if (this.searchPanel.searchButton.isSelected()) {
                return c.getSize();
            }
            int buttonSize = LafWidgetRepository.getRepository().getLafSupport().getLookupButtonSize();
            return new Dimension(buttonSize, buttonSize);
        }

        public Dimension minimumLayoutSize(Container c) {
            int buttonSize = LafWidgetRepository.getRepository().getLafSupport().getLookupButtonSize();
            return new Dimension(buttonSize, buttonSize);
        }

        public void layoutContainer(Container c) {
            block5: {
                int width;
                int height;
                block4: {
                    height = c.getHeight();
                    width = c.getWidth();
                    if (!this.searchPanel.searchButton.isVisible()) {
                        return;
                    }
                    boolean leftToRight = MenuSearchWidget.this.jmb.getComponentOrientation().isLeftToRight();
                    if (!leftToRight) break block4;
                    int x = 2;
                    int sbWidth = ((SearchPanel)this.searchPanel).searchButton.getPreferredSize().width;
                    int sbHeight = ((SearchPanel)this.searchPanel).searchButton.getPreferredSize().height;
                    this.searchPanel.searchButton.setBounds(x, (height - sbHeight) / 2, sbWidth, sbHeight);
                    x += sbWidth + 4;
                    if (!this.searchPanel.isVisible()) break block5;
                    int tbWidth = ((SearchPanel)this.searchPanel).searchStringField.getPreferredSize().width;
                    int tbHeight = ((SearchPanel)this.searchPanel).searchStringField.getPreferredSize().height;
                    tbHeight = Math.min(tbHeight, height - 2);
                    this.searchPanel.searchStringField.setBounds(x, (height - tbHeight) / 2, tbWidth, tbHeight);
                    x += tbWidth + 2;
                    int buttonCount = this.searchPanel.resultButtons.size();
                    for (int i = 1; i <= buttonCount; ++i) {
                        JButton button = (JButton)this.searchPanel.resultButtons.get(i);
                        int bw = button.getPreferredSize().width;
                        int bh = button.getPreferredSize().height;
                        button.setBounds(x, (height - bh) / 2, bw, bh);
                        x += bw + 1;
                    }
                    break block5;
                }
                int x = width - 2;
                int sbWidth = ((SearchPanel)this.searchPanel).searchButton.getPreferredSize().width;
                int sbHeight = ((SearchPanel)this.searchPanel).searchButton.getPreferredSize().height;
                this.searchPanel.searchButton.setBounds(x - sbWidth, (height - sbHeight) / 2, sbWidth, sbHeight);
                x -= sbWidth + 4;
                if (this.searchPanel.isVisible()) {
                    int tbWidth = ((SearchPanel)this.searchPanel).searchStringField.getPreferredSize().width;
                    int tbHeight = ((SearchPanel)this.searchPanel).searchStringField.getPreferredSize().height;
                    tbHeight = Math.min(tbHeight, height - 2);
                    this.searchPanel.searchStringField.setBounds(x - tbWidth, (height - tbHeight) / 2, tbWidth, tbHeight);
                    x -= tbWidth + 2;
                    int buttonCount = this.searchPanel.resultButtons.size();
                    for (int i = 1; i <= buttonCount; ++i) {
                        JButton button = (JButton)this.searchPanel.resultButtons.get(i);
                        int bw = button.getPreferredSize().width;
                        int bh = button.getPreferredSize().height;
                        button.setBounds(x - bw, (height - bh) / 2, bw, bh);
                        x -= bw + 1;
                    }
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SearchResult {
        private MenuElement[] menuElements;

        public SearchResult(JMenuBar menuBar, LinkedList<JMenu> menuPath, JMenuItem menuLeaf) {
            int count = 1;
            if (menuPath != null) {
                count += 2 * menuPath.size();
            }
            if (menuLeaf != null) {
                ++count;
            }
            this.menuElements = new MenuElement[count];
            count = 0;
            this.menuElements[count++] = menuBar;
            if (menuPath != null) {
                for (JMenu menu : menuPath) {
                    this.menuElements[count++] = menu;
                    this.menuElements[count++] = menu.getPopupMenu();
                }
            }
            if (menuLeaf != null) {
                this.menuElements[count] = menuLeaf;
            }
        }

        public MenuElement[] getMenuElements() {
            return this.menuElements;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            if (this.menuElements != null) {
                String sep = "";
                for (int i = 0; i < this.menuElements.length; ++i) {
                    MenuElement menuElem = this.menuElements[i];
                    if (!(menuElem instanceof JMenuItem)) continue;
                    sb.append(sep);
                    sep = " -> ";
                    sb.append(((JMenuItem)menuElem).getText());
                }
            }
            return sb.toString();
        }

        public boolean isEnabled() {
            for (int i = 0; i < this.menuElements.length; ++i) {
                JMenuItem menuItem;
                MenuElement menuElem = this.menuElements[i];
                if (!(menuElem instanceof JMenuItem) || (menuItem = (JMenuItem)menuElem).isEnabled()) continue;
                return false;
            }
            return true;
        }
    }

    private static class SearchResultListener
    implements ActionListener {
        private SearchResult searchResult;

        public SearchResultListener(SearchResult searchResult) {
            this.searchResult = searchResult;
        }

        public void actionPerformed(ActionEvent e) {
            MenuElement[] menuElements = this.searchResult.menuElements;
            MenuSelectionManager.defaultManager().setSelectedPath(menuElements);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SearchPanel
    extends JPanel {
        private JToggleButton searchButton;
        private JTextField searchStringField;
        private Map<Integer, JButton> resultButtons;

        public SearchPanel(final JMenuBar menuBar) {
            this.setLayout(new SearchResultsLayout(this));
            LafWidgetSupport support = LafWidgetRepository.getRepository().getLafSupport();
            int iconDim = support.getLookupIconSize();
            int buttonDim = support.getLookupButtonSize();
            Icon searchIcon = support == null ? LafWidgetUtilities.getSearchIcon(iconDim, MenuSearchWidget.this.jmb.getComponentOrientation().isLeftToRight()) : support.getSearchIcon(iconDim, MenuSearchWidget.this.jmb.getComponentOrientation());
            this.searchButton = new JToggleButton(searchIcon);
            this.searchButton.setPreferredSize(new Dimension(buttonDim, buttonDim));
            ResourceBundle bundle = LafWidgetUtilities.getResourceBundle(menuBar);
            this.searchButton.setToolTipText(bundle.getString("Tooltip.menuSearchButton"));
            this.searchButton.setFocusable(false);
            if (support != null) {
                support.markButtonAsFlat(this.searchButton);
            }
            this.add(this.searchButton);
            this.searchButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            boolean toShow = SearchPanel.this.searchButton.isSelected();
                            SearchPanel.this.searchStringField.setVisible(toShow);
                            SearchPanel.this.searchStringField.requestFocus();
                            for (JButton resultButton : SearchPanel.this.resultButtons.values()) {
                                resultButton.setVisible(toShow);
                            }
                            SearchPanel.this.repaint();
                            SearchPanel.this.revalidate();
                        }
                    });
                }
            });
            this.searchButton.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent e) {
                    if ((e.getModifiers() & 2) != 0) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                SearchPanel.this.removeAll();
                                SearchPanel.this.repaint();
                                MenuSearchWidget.this.jmb.revalidate();
                            }
                        });
                    }
                }
            });
            this.searchStringField = new JTextField();
            this.searchStringField.setColumns(10);
            this.add(this.searchStringField);
            this.searchStringField.setVisible(false);
            this.searchStringField.setToolTipText(bundle.getString("Tooltip.menuSearchField"));
            this.resultButtons = new HashMap<Integer, JButton>();
            this.searchStringField.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    String searchString = SearchPanel.this.searchStringField.getText().toLowerCase();
                    if (searchString.trim().length() == 0) {
                        return;
                    }
                    for (JButton toRemove : SearchPanel.this.resultButtons.values()) {
                        SearchPanel.this.remove(toRemove);
                    }
                    SearchPanel.this.resultButtons.clear();
                    LinkedList searchResults = SearchPanel.this.findOccurences(searchString);
                    int count = 0;
                    for (SearchResult searchResult : searchResults) {
                        if (count == 16) break;
                        LafWidgetSupport support = LafWidgetRepository.getRepository().getLafSupport();
                        Icon markerIcon = support.getNumberIcon(count + 1);
                        JButton resultButton = new JButton(markerIcon);
                        resultButton.addActionListener(new SearchResultListener(searchResult));
                        resultButton.setEnabled(searchResult.isEnabled());
                        SearchPanel.this.add(resultButton);
                        SearchPanel.this.resultButtons.put(new Integer(count + 1), resultButton);
                        resultButton.setToolTipText("<html><body><b>" + searchResult.toString() + "</b><br>" + LafWidgetUtilities.getResourceBundle(menuBar).getString("Tooltip.menuSearchTooltip") + "</html>");
                        if (support != null) {
                            support.markButtonAsFlat(resultButton);
                        }
                        ++count;
                    }
                    SearchPanel.this.repaint();
                    MenuSearchWidget.this.jmb.revalidate();
                }
            });
        }

        private LinkedList<SearchResult> findOccurences(String searchPattern) {
            LinkedList<SearchResult> result = new LinkedList<SearchResult>();
            LinkedList<JMenu> currentPath = new LinkedList<JMenu>();
            for (int i = 0; i < MenuSearchWidget.this.jmb.getComponentCount(); ++i) {
                Component component = MenuSearchWidget.this.jmb.getComponent(i);
                if (!(component instanceof JMenu)) continue;
                JMenu menu = (JMenu)component;
                this.checkMenu(currentPath, menu, searchPattern, result);
            }
            return result;
        }

        private void checkMenu(LinkedList<JMenu> currentPath, JMenuItem menuItem, String searchPattern, LinkedList<SearchResult> matchingResults) {
            String menuItemText = menuItem.getText();
            if (menuItemText.toLowerCase().indexOf(searchPattern) >= 0) {
                matchingResults.addLast(new SearchResult(MenuSearchWidget.this.jmb, currentPath, menuItem));
            }
            if (menuItem instanceof JMenu) {
                JMenu menu = (JMenu)menuItem;
                currentPath.addLast(menu);
                for (int i = 0; i < menu.getMenuComponentCount(); ++i) {
                    Component menuComponent = menu.getMenuComponent(i);
                    if (!(menuComponent instanceof JMenuItem)) continue;
                    JMenuItem childItem = (JMenuItem)menuComponent;
                    this.checkMenu(currentPath, childItem, searchPattern, matchingResults);
                }
                currentPath.removeLast();
            }
        }

        @Override
        public void setVisible(boolean aFlag) {
            super.setVisible(aFlag);
            if (aFlag) {
                this.searchStringField.requestFocus();
            }
        }
    }
}

