/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.swingx;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicLookAndFeel;
import org.jdesktop.swingx.JXMonthView;
import org.jdesktop.swingx.calendar.DateSelectionModel;
import org.jdesktop.swingx.event.DateSelectionEvent;
import org.jdesktop.swingx.event.DateSelectionListener;
import org.jdesktop.swingx.plaf.basic.BasicMonthViewUI;
import org.jvnet.lafwidget.LafWidget;
import org.jvnet.lafwidget.LafWidgetRepository;
import org.jvnet.lafwidget.LafWidgetUtilities;
import org.jvnet.lafwidget.animation.FadeConfigurationManager;
import org.jvnet.lafwidget.animation.FadeKind;
import org.jvnet.lafwidget.animation.FadeState;
import org.jvnet.lafwidget.animation.FadeTracker;
import org.jvnet.lafwidget.animation.FadeTrackerAdapter;
import org.jvnet.lafwidget.animation.FadeTrackerCallback;
import org.jvnet.lafwidget.layout.TransitionLayout;
import org.jvnet.lafwidget.utils.RenderingUtils;
import org.jvnet.substance.SubstanceFillBackgroundDelegate;
import org.jvnet.substance.SubstanceImageCreator;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.color.ColorScheme;
import org.jvnet.substance.painter.highlight.SubstanceHighlightUtils;
import org.jvnet.substance.painter.text.SubstanceTextPainter;
import org.jvnet.substance.theme.SubstanceShiftTheme;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.utils.ComponentState;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceFadeUtilities;
import org.jvnet.substance.utils.SubstanceThemeUtilities;
import org.jvnet.substance.utils.Trackable;

public class SubstanceMonthViewUI
extends BasicMonthViewUI
implements Trackable {
    protected Set lafWidgets;
    protected int headerHeight;
    protected DayRolloverFadeListener substanceFadeRolloverListener;
    protected int rolloverDayId = -1;
    protected int rolloverMonthId = -1;
    protected int rolloverYearId = -1;
    protected Set<String> selectedIndices;
    protected DateSelectionListener substanceFadeSelectionListener;
    private Map<String, ComponentState> prevDayStateMap = new HashMap<String, ComponentState>();
    private Map<String, ComponentState> nextDayStateMap = new HashMap<String, ComponentState>();
    private Map<String, ComponentState> prevMonthStateMap = new HashMap<String, ComponentState>();
    private Map<String, ComponentState> nextMonthStateMap = new HashMap<String, ComponentState>();

    public void installDefaults() {
        this.__org__jvnet__substance__swingx__SubstanceMonthViewUI__installDefaults();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installDefaults();
        }
    }

    public void __org__jvnet__substance__swingx__SubstanceMonthViewUI__uninstallComponents() {
        super.uninstallComponents();
    }

    public void uninstallComponents() {
        this.__org__jvnet__substance__swingx__SubstanceMonthViewUI__uninstallComponents();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallComponents();
        }
    }

    public void uninstallDefaults() {
        this.__org__jvnet__substance__swingx__SubstanceMonthViewUI__uninstallDefaults();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallDefaults();
        }
    }

    public void __org__jvnet__substance__swingx__SubstanceMonthViewUI__update(Graphics graphics, JComponent jComponent) {
        super.update(graphics, jComponent);
    }

    public void update(Graphics graphics, JComponent jComponent) {
        Object object;
        Graphics2D graphics2D = (Graphics2D)graphics;
        Composite composite = graphics2D.getComposite();
        float f = 1.0f;
        if (composite instanceof AlphaComposite && ((AlphaComposite)(object = (AlphaComposite)composite)).getRule() == 3) {
            f = ((AlphaComposite)object).getAlpha();
        }
        graphics2D.setComposite(TransitionLayout.getAlphaComposite((Component)jComponent, (float)f));
        object = RenderingUtils.installDesktopHints((Graphics2D)graphics2D);
        this.__org__jvnet__substance__swingx__SubstanceMonthViewUI__update(graphics2D, jComponent);
        graphics2D.setComposite(composite);
        if (object != null) {
            graphics2D.addRenderingHints((Map<?, ?>)object);
        }
    }

    public void __org__jvnet__substance__swingx__SubstanceMonthViewUI__uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
    }

    public void uninstallUI(JComponent jComponent) {
        this.__org__jvnet__substance__swingx__SubstanceMonthViewUI__uninstallUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallUI();
        }
    }

    public void uninstallListeners() {
        this.__org__jvnet__substance__swingx__SubstanceMonthViewUI__uninstallListeners();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallListeners();
        }
    }

    public void __org__jvnet__substance__swingx__SubstanceMonthViewUI__installUI(JComponent jComponent) {
        super.installUI(jComponent);
    }

    public void installUI(JComponent jComponent) {
        this.lafWidgets = LafWidgetRepository.getRepository().getMatchingWidgets(jComponent);
        this.__org__jvnet__substance__swingx__SubstanceMonthViewUI__installUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installUI();
        }
    }

    public void __org__jvnet__substance__swingx__SubstanceMonthViewUI__installComponents() {
        super.installComponents();
    }

    public void installComponents() {
        this.__org__jvnet__substance__swingx__SubstanceMonthViewUI__installComponents();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installComponents();
        }
    }

    public void installListeners() {
        this.__org__jvnet__substance__swingx__SubstanceMonthViewUI__installListeners();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installListeners();
        }
    }

    public static ComponentUI createUI(JComponent c) {
        return new SubstanceMonthViewUI();
    }

    public SubstanceMonthViewUI() {
        this.selectedIndices = new HashSet<String>();
    }

    protected void __org__jvnet__substance__swingx__SubstanceMonthViewUI__installDefaults() {
        super.installDefaults();
        this.monthDownImage = SubstanceImageCreator.getArrowIcon((int)this.monthView.getFont().getSize(), (int)7, (SubstanceTheme)SubstanceThemeUtilities.getTheme((Component)this.monthView, (ComponentState)ComponentState.ACTIVE));
        this.monthUpImage = SubstanceImageCreator.getArrowIcon((int)this.monthView.getFont().getSize(), (int)3, (SubstanceTheme)SubstanceThemeUtilities.getTheme((Component)this.monthView, (ComponentState)ComponentState.ACTIVE));
        BasicLookAndFeel.installColors((JComponent)this.monthView, "JXMonthView.background", "JXMonthView.foreground");
        Calendar cal = this.monthView.getCalendar();
        if (cal != null) {
            for (Date selected : this.getSelection()) {
                cal.setTime(selected);
                int day = cal.get(5);
                int month = cal.get(2);
                int year = cal.get(1);
                this.selectedIndices.add(day + ":" + month + ":" + year);
            }
        }
    }

    protected void __org__jvnet__substance__swingx__SubstanceMonthViewUI__installListeners() {
        super.installListeners();
        this.substanceFadeRolloverListener = new DayRolloverFadeListener();
        this.monthView.addMouseMotionListener((MouseMotionListener)this.substanceFadeRolloverListener);
        this.monthView.addMouseListener((MouseListener)this.substanceFadeRolloverListener);
        this.substanceFadeSelectionListener = new DateSelectionListener(){

            protected void cancelFades(Set<Long> initiatedFadeSequences) {
                FadeTracker fadeTrackerInstance = FadeTracker.getInstance();
                for (long fadeId : initiatedFadeSequences) {
                    fadeTrackerInstance.cancelFadeInstance(fadeId);
                }
            }

            public void valueChanged(DateSelectionEvent ev) {
                if (LafWidgetUtilities.hasNoFades((Component)SubstanceMonthViewUI.this.monthView, (FadeKind)FadeKind.SELECTION)) {
                    return;
                }
                HashSet<Long> initiatedFadeSequences = new HashSet<Long>();
                boolean fadeCanceled = false;
                Calendar cal = SubstanceMonthViewUI.this.monthView.getCalendar();
                cal.set(5, 1);
                int month = cal.get(2);
                DateSelectionModel selectionModel = SubstanceMonthViewUI.this.monthView.getSelectionModel();
                FadeTracker fadeTrackerInstance = FadeTracker.getInstance();
                while (cal.get(2) == month) {
                    long fadeId;
                    int dayIndex = cal.get(5);
                    int monthIndex = cal.get(2);
                    int yearIndex = cal.get(1);
                    String index = dayIndex + ":" + monthIndex + ":" + yearIndex;
                    if (selectionModel.isSelected(cal.getTime())) {
                        if (!SubstanceMonthViewUI.this.selectedIndices.contains(dayIndex)) {
                            if (!fadeCanceled) {
                                fadeId = fadeTrackerInstance.trackFadeIn(FadeKind.SELECTION, (Component)SubstanceMonthViewUI.this.monthView, (Comparable)((Object)index), false, (FadeTrackerCallback)new DayRepaintCallback(SubstanceMonthViewUI.this.monthView, dayIndex, monthIndex, yearIndex));
                                initiatedFadeSequences.add(fadeId);
                                if (initiatedFadeSequences.size() > 25) {
                                    this.cancelFades(initiatedFadeSequences);
                                    initiatedFadeSequences.clear();
                                    fadeCanceled = true;
                                }
                            }
                            SubstanceMonthViewUI.this.selectedIndices.add(index);
                        }
                    } else if (SubstanceMonthViewUI.this.selectedIndices.contains(dayIndex)) {
                        if (!fadeCanceled) {
                            fadeId = fadeTrackerInstance.trackFadeOut(FadeKind.SELECTION, (Component)SubstanceMonthViewUI.this.monthView, (Comparable)((Object)index), false, (FadeTrackerCallback)new DayRepaintCallback(SubstanceMonthViewUI.this.monthView, dayIndex, monthIndex, yearIndex));
                            initiatedFadeSequences.add(fadeId);
                            if (initiatedFadeSequences.size() > 25) {
                                this.cancelFades(initiatedFadeSequences);
                                initiatedFadeSequences.clear();
                                fadeCanceled = true;
                            }
                        }
                        SubstanceMonthViewUI.this.selectedIndices.remove(dayIndex);
                    }
                    cal.add(5, 1);
                }
            }
        };
        this.monthView.getSelectionModel().addDateSelectionListener(this.substanceFadeSelectionListener);
    }

    protected void __org__jvnet__substance__swingx__SubstanceMonthViewUI__uninstallListeners() {
        this.monthView.getSelectionModel().removeDateSelectionListener(this.substanceFadeSelectionListener);
        this.substanceFadeSelectionListener = null;
        this.monthView.removeMouseListener((MouseListener)this.substanceFadeRolloverListener);
        this.monthView.removeMouseMotionListener((MouseMotionListener)this.substanceFadeRolloverListener);
        this.substanceFadeRolloverListener = null;
        super.uninstallListeners();
    }

    protected void __org__jvnet__substance__swingx__SubstanceMonthViewUI__uninstallDefaults() {
        this.selectedIndices.clear();
        super.uninstallDefaults();
    }

    protected void paintMonthStringBackground(Graphics g, final int x, final int y, final int width, final int height, final Calendar cal) {
        this.headerHeight = height;
        SubstanceTextPainter textPainter = SubstanceLookAndFeel.getCurrentTextPainter();
        textPainter.init((JComponent)this.monthView, null, true);
        SubstanceTextPainter.BackgroundPaintingCallback callback = new SubstanceTextPainter.BackgroundPaintingCallback(){

            public void paintBackground(Graphics g) {
                Graphics2D g2d = (Graphics2D)g.create();
                ComponentState componentState = SubstanceMonthViewUI.this.monthView.isEnabled() ? ComponentState.DEFAULT : ComponentState.DISABLED_UNSELECTED;
                SubstanceTheme fillTheme = SubstanceThemeUtilities.getTheme((Component)SubstanceMonthViewUI.this.monthView, (ComponentState)componentState);
                float fillAlpha = SubstanceThemeUtilities.getTheme((Component)SubstanceMonthViewUI.this.monthView, (ComponentState)componentState).getThemeAlpha((Component)SubstanceMonthViewUI.this.monthView, componentState);
                g2d.setComposite(TransitionLayout.getAlphaComposite((Component)SubstanceMonthViewUI.this.monthView, (float)fillAlpha, (Graphics)g));
                SubstanceHighlightUtils.paintHighlight((Graphics)g2d, (Component)SubstanceMonthViewUI.this.monthView, (Rectangle)new Rectangle(x, y, width, height), (float)0.5f, null, (ColorScheme)fillTheme.getColorScheme(), (ColorScheme)fillTheme.getColorScheme(), (float)0.0f);
                g2d.setComposite(TransitionLayout.getAlphaComposite((Component)SubstanceMonthViewUI.this.monthView, (Graphics)g));
                ComponentState prevState = SubstanceMonthViewUI.this.getPrevMonthState(cal.get(2), cal.get(1));
                ComponentState currState = SubstanceMonthViewUI.this.getMonthState(cal.get(2), cal.get(1));
                float startAlpha = SubstanceThemeUtilities.getHighlightAlpha((Component)SubstanceMonthViewUI.this.monthView, (ComponentState)prevState);
                float endAlpha = SubstanceThemeUtilities.getHighlightAlpha((Component)SubstanceMonthViewUI.this.monthView, (ComponentState)currState);
                FadeState state = SubstanceFadeUtilities.getFadeState((Component)SubstanceMonthViewUI.this.monthView, (Comparable)((Object)(cal.get(2) + ":" + cal.get(1))), (FadeKind[])new FadeKind[]{FadeKind.ROLLOVER});
                float totalAlpha = endAlpha;
                float fadeCoef = 0.0f;
                if (state != null) {
                    fadeCoef = state.getFadePosition();
                    totalAlpha = state.isFadingIn() ? startAlpha + (endAlpha - startAlpha) * fadeCoef / 10.0f : startAlpha + (endAlpha - startAlpha) * (10.0f - fadeCoef) / 10.0f;
                    if (state.isFadingIn()) {
                        fadeCoef = 10.0f - fadeCoef;
                    }
                }
                SubstanceTheme prevTheme = SubstanceThemeUtilities.getHighlightTheme((Component)SubstanceMonthViewUI.this.monthView, (ComponentState)prevState);
                SubstanceTheme currTheme = SubstanceThemeUtilities.getHighlightTheme((Component)SubstanceMonthViewUI.this.monthView, (ComponentState)currState);
                if (totalAlpha > 0.0f) {
                    g2d.setComposite(TransitionLayout.getAlphaComposite((Component)SubstanceMonthViewUI.this.monthView, (float)totalAlpha, (Graphics)g));
                    SubstanceHighlightUtils.paintHighlight((Graphics)g2d, (Component)SubstanceMonthViewUI.this.monthView, (Rectangle)new Rectangle(x, y, width, height), (float)0.5f, null, (ColorScheme)currTheme.getColorScheme(), (ColorScheme)prevTheme.getColorScheme(), (float)fadeCoef);
                    g2d.setComposite(TransitionLayout.getAlphaComposite((Component)SubstanceMonthViewUI.this.monthView, (Graphics)g));
                }
                g2d.dispose();
            }
        };
        if (textPainter.needsBackgroundImage()) {
            textPainter.attachCallback(callback);
        } else {
            callback.paintBackground(g);
        }
    }

    protected void paintDayOfTheWeekBackground(Graphics g, int x, int y, int width, int height, Calendar cal) {
        int boxPaddingX = this.monthView.getBoxPaddingX();
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.translate(x + boxPaddingX, y + height - 1);
        SubstanceTheme theme = SubstanceThemeUtilities.getTheme((Component)this.monthView).getDefaultTheme();
        SubstanceCoreUtilities.paintSeparator((Component)this.monthView, (Graphics2D)graphics, (ColorScheme)theme.getColorScheme(), (boolean)SubstanceCoreUtilities.isThemeDark((SubstanceTheme)theme), (int)width, (int)1, (int)0, (boolean)true, (int)0);
        graphics.dispose();
    }

    protected void paintWeekOfYearBackground(Graphics g, int x, int y, int width, int height, Calendar cal) {
        int boxPaddingY = this.monthView.getBoxPaddingY();
        x = this.monthView.getComponentOrientation().isLeftToRight() ? x + width - 1 : x;
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.translate(x, y + boxPaddingY);
        SubstanceTheme theme = SubstanceThemeUtilities.getTheme((Component)this.monthView).getDefaultTheme();
        SubstanceCoreUtilities.paintSeparator((Component)this.monthView, (Graphics2D)graphics, (ColorScheme)theme.getColorScheme(), (boolean)SubstanceCoreUtilities.isThemeDark((SubstanceTheme)theme), (int)1, (int)height, (int)1, (boolean)true, (int)0);
        graphics.dispose();
    }

    protected void paintBackground(Rectangle clip, Graphics graphics) {
        SubstanceFillBackgroundDelegate.GLOBAL_INSTANCE.update(graphics, (Component)this.monthView, false);
    }

    protected void paintDayBackground(Graphics g, int x, int y, int width, int height, Calendar cal) {
        Graphics2D graphics = (Graphics2D)g.create();
        Rectangle area = new Rectangle(x, y, width, height);
        int day = cal.get(5);
        int month = cal.get(2);
        int year = cal.get(1);
        if (month != cal.get(2)) {
            return;
        }
        if (this.isToday(cal.getTime())) {
            graphics.setColor(this.monthView.getTodayBackground());
            graphics.drawRect(x, y, width - 1, height - 1);
        }
        ComponentState prevState = this.getPrevDayState(day, month, year);
        ComponentState currState = this.getDayState(day, month, year);
        float startAlpha = SubstanceThemeUtilities.getHighlightAlpha((Component)this.monthView, (ComponentState)prevState);
        float endAlpha = SubstanceThemeUtilities.getHighlightAlpha((Component)this.monthView, (ComponentState)currState);
        FadeState state = SubstanceFadeUtilities.getFadeState((Component)this.monthView, (Comparable)((Object)(day + ":" + month + ":" + year)), (FadeKind[])new FadeKind[]{FadeKind.SELECTION, FadeKind.ROLLOVER});
        float totalAlpha = endAlpha;
        float fadeCoef = 0.0f;
        if (state != null) {
            fadeCoef = state.getFadePosition();
            totalAlpha = state.isFadingIn() ? startAlpha + (endAlpha - startAlpha) * fadeCoef / 10.0f : startAlpha + (endAlpha - startAlpha) * (10.0f - fadeCoef) / 10.0f;
            if (state.isFadingIn()) {
                fadeCoef = 10.0f - fadeCoef;
            }
        }
        SubstanceTheme prevTheme = SubstanceThemeUtilities.getHighlightTheme((Component)this.monthView, (ComponentState)prevState);
        SubstanceTheme currTheme = SubstanceThemeUtilities.getHighlightTheme((Component)this.monthView, (ComponentState)currState);
        if (totalAlpha > 0.0f) {
            graphics.setComposite(TransitionLayout.getAlphaComposite((Component)this.monthView, (float)totalAlpha, (Graphics)g));
            SubstanceHighlightUtils.paintHighlight((Graphics)graphics, (Component)this.monthView, (Rectangle)area, (float)0.5f, null, (ColorScheme)currTheme.getColorScheme(), (ColorScheme)prevTheme.getColorScheme(), (float)fadeCoef);
            graphics.setComposite(TransitionLayout.getAlphaComposite((Component)this.monthView, (Graphics)g));
        }
        graphics.dispose();
    }

    protected void paintDayForeground(Graphics g, String numericDay, int x, int y, Calendar cal) {
        Graphics2D g2d = (Graphics2D)g.create();
        int day = Integer.parseInt(numericDay);
        ComponentState state = this.getDayState(day, cal.get(2), cal.get(1));
        ComponentState prevState = this.getPrevDayState(day, cal.get(2), cal.get(1));
        Color customFgColor = this.monthView.getDayForeground(cal.get(7));
        boolean isColorized = SubstanceCoreUtilities.hasColorization((Component)this.monthView);
        boolean isForegroundUiResource = customFgColor instanceof UIResource;
        SubstanceTheme theme = SubstanceThemeUtilities.getTheme((Component)this.monthView, (ComponentState)state);
        if (isColorized && !isForegroundUiResource) {
            double colorizationFactor = SubstanceCoreUtilities.getColorizationFactor((Component)this.monthView);
            theme = SubstanceShiftTheme.getShiftedTheme((SubstanceTheme)theme, (Color)customFgColor, (double)colorizationFactor, (Color)customFgColor, (double)colorizationFactor);
        }
        Color fgColor = customFgColor;
        if (isColorized || !isColorized && isForegroundUiResource) {
            fgColor = SubstanceCoreUtilities.getInterpolatedForegroundColor((Component)this.monthView, (Comparable)Integer.valueOf(day), (SubstanceTheme)theme, (ComponentState)state, (ComponentState)prevState, (FadeKind[])new FadeKind[]{FadeKind.ROLLOVER, FadeKind.SELECTION});
        }
        g2d.setColor(fgColor);
        FontMetrics fm = g2d.getFontMetrics();
        g2d.drawString(numericDay, x - fm.stringWidth(numericDay), y + fm.getAscent());
        g2d.dispose();
    }

    protected void paintMonthStringForeground(Graphics g, String monthName, int monthX, int monthY, String yearName, int yearX, int yearY, Calendar cal) {
        Graphics2D g2d = (Graphics2D)g.create();
        ComponentState state = this.getMonthState(cal.get(2), cal.get(1));
        ComponentState prevState = this.getPrevMonthState(cal.get(2), cal.get(1));
        Color fg = SubstanceCoreUtilities.getInterpolatedForegroundColor((Component)this.monthView, null, (SubstanceTheme)SubstanceThemeUtilities.getTheme((Component)this.monthView, (ComponentState)state), (ComponentState)state, (ComponentState)prevState, (FadeKind[])new FadeKind[]{FadeKind.ROLLOVER, FadeKind.SELECTION});
        SubstanceTextPainter textPainter = SubstanceLookAndFeel.getCurrentTextPainter();
        SubstanceCoreUtilities.paintTextWithDropShadow((JComponent)this.monthView, (Graphics)g2d, (Color)fg, (String)monthName, (int)this.monthView.getWidth(), (int)this.headerHeight, (int)monthX, (int)monthY);
        SubstanceCoreUtilities.paintTextWithDropShadow((JComponent)this.monthView, (Graphics)g2d, (Color)fg, (String)yearName, (int)this.monthView.getWidth(), (int)this.headerHeight, (int)yearX, (int)yearY);
        textPainter.renderSurface((Graphics)g2d);
        g2d.dispose();
    }

    public boolean isInside(MouseEvent me) {
        return true;
    }

    public ComponentState getDayState(int dayIndex, int monthIndex, int yearIndex) {
        DefaultButtonModel synthModel = new DefaultButtonModel();
        synthModel.setEnabled(this.monthView.isEnabled());
        synthModel.setRollover(this.rolloverDayId >= 0 && this.rolloverDayId == dayIndex && this.rolloverMonthId >= 0 && this.rolloverMonthId == monthIndex && this.rolloverYearId >= 0 && this.rolloverYearId == yearIndex);
        Calendar cal = this.monthView.getCalendar();
        cal.set(5, dayIndex);
        cal.set(2, monthIndex);
        cal.set(1, yearIndex);
        synthModel.setSelected(this.monthView.isSelected(cal.getTime()));
        return ComponentState.getState((ButtonModel)synthModel, null);
    }

    public ComponentState getMonthState(int monthIndex, int yearIndex) {
        DefaultButtonModel synthModel = new DefaultButtonModel();
        synthModel.setEnabled(this.monthView.isEnabled());
        synthModel.setRollover(this.rolloverMonthId >= 0 && this.rolloverMonthId == monthIndex && this.rolloverYearId >= 0 && this.rolloverYearId == yearIndex);
        return ComponentState.getState((ButtonModel)synthModel, null);
    }

    public ComponentState getPrevDayState(int dayIndex, int monthIndex, int yearIndex) {
        String key = dayIndex + ":" + monthIndex + ":" + yearIndex;
        if (this.prevDayStateMap.containsKey(key)) {
            return this.prevDayStateMap.get(key);
        }
        return ComponentState.DEFAULT;
    }

    public ComponentState getPrevMonthState(int monthIndex, int yearIndex) {
        String key = monthIndex + ":" + yearIndex;
        if (this.prevMonthStateMap.containsKey(key)) {
            return this.prevMonthStateMap.get(key);
        }
        return ComponentState.DEFAULT;
    }

    protected void resetRolloverIndex() {
        this.rolloverDayId = -1;
        this.rolloverMonthId = -1;
        this.rolloverYearId = -1;
    }

    protected class DayRepaintCallback
    extends FadeTrackerAdapter {
        protected JXMonthView monthView;
        protected int dayIndex;
        protected int monthIndex;
        protected int yearIndex;

        public DayRepaintCallback(JXMonthView monthView, int dayIndex, int monthIndex, int yearIndex) {
            this.monthView = monthView;
            this.dayIndex = dayIndex;
            this.monthIndex = monthIndex;
            this.yearIndex = yearIndex;
        }

        public void fadeEnded(FadeKind fadeKind) {
            String key = this.dayIndex + ":" + this.monthIndex + ":" + this.yearIndex;
            if (this.monthView == SubstanceMonthViewUI.this.monthView) {
                ComponentState currState = SubstanceMonthViewUI.this.getDayState(this.dayIndex, this.monthIndex, this.yearIndex);
                if (currState == ComponentState.DEFAULT) {
                    SubstanceMonthViewUI.this.prevDayStateMap.remove(key);
                    SubstanceMonthViewUI.this.nextDayStateMap.remove(key);
                } else {
                    SubstanceMonthViewUI.this.prevDayStateMap.put(key, currState);
                    SubstanceMonthViewUI.this.nextDayStateMap.put(key, currState);
                }
            }
            this.repaintCell();
        }

        public void fadeReversed(FadeKind fadeKind, boolean isFadingIn, float fadeCycle10) {
            if (this.monthView == SubstanceMonthViewUI.this.monthView) {
                String key = this.dayIndex + ":" + this.monthIndex + ":" + this.yearIndex;
                ComponentState nextState = (ComponentState)SubstanceMonthViewUI.this.nextDayStateMap.get(key);
                if (nextState == null) {
                    SubstanceMonthViewUI.this.prevDayStateMap.remove(key);
                } else {
                    SubstanceMonthViewUI.this.prevDayStateMap.put(key, nextState);
                }
            }
            this.repaintCell();
        }

        public void fadePerformed(FadeKind fadeKind, float fade10) {
            if (this.monthView == SubstanceMonthViewUI.this.monthView) {
                String key = this.dayIndex + ":" + this.monthIndex + ":" + this.yearIndex;
                SubstanceMonthViewUI.this.nextDayStateMap.put(key, SubstanceMonthViewUI.this.getDayState(this.dayIndex, this.monthIndex, this.yearIndex));
            }
            this.repaintCell();
        }

        private void repaintCell() {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (DayRepaintCallback.this.monthView != SubstanceMonthViewUI.this.monthView) {
                        return;
                    }
                    Calendar cal = DayRepaintCallback.this.monthView.getCalendar();
                    cal.set(5, DayRepaintCallback.this.dayIndex);
                    cal.set(2, DayRepaintCallback.this.monthIndex);
                    cal.set(1, DayRepaintCallback.this.yearIndex);
                    Rectangle dayBounds = SubstanceMonthViewUI.this.getDayBounds(cal.getTime());
                    if (dayBounds != null) {
                        DayRepaintCallback.this.monthView.repaint(dayBounds);
                    }
                }
            });
        }
    }

    protected class MonthRepaintCallback
    extends FadeTrackerAdapter {
        protected JXMonthView monthView;
        protected int monthIndex;
        protected int yearIndex;

        public MonthRepaintCallback(JXMonthView monthView, int monthIndex, int yearIndex) {
            this.monthView = monthView;
            this.monthIndex = monthIndex;
            this.yearIndex = yearIndex;
        }

        public void fadeEnded(FadeKind fadeKind) {
            if (this.monthView == SubstanceMonthViewUI.this.monthView) {
                String key = this.monthIndex + ":" + this.yearIndex;
                ComponentState currState = SubstanceMonthViewUI.this.getMonthState(this.monthIndex, this.yearIndex);
                if (currState == ComponentState.DEFAULT) {
                    SubstanceMonthViewUI.this.prevMonthStateMap.remove(key);
                    SubstanceMonthViewUI.this.nextMonthStateMap.remove(key);
                } else {
                    SubstanceMonthViewUI.this.prevMonthStateMap.put(key, currState);
                    SubstanceMonthViewUI.this.nextMonthStateMap.put(key, currState);
                }
            }
            this.repaintCell();
        }

        public void fadeReversed(FadeKind fadeKind, boolean isFadingIn, float fadeCycle10) {
            if (this.monthView == SubstanceMonthViewUI.this.monthView) {
                String key = this.monthIndex + ":" + this.yearIndex;
                ComponentState nextState = (ComponentState)SubstanceMonthViewUI.this.nextMonthStateMap.get(key);
                if (nextState == null) {
                    SubstanceMonthViewUI.this.prevMonthStateMap.remove(key);
                } else {
                    SubstanceMonthViewUI.this.prevMonthStateMap.put(key, nextState);
                }
            }
            this.repaintCell();
        }

        public void fadePerformed(FadeKind fadeKind, float fade10) {
            if (this.monthView == SubstanceMonthViewUI.this.monthView) {
                String key = this.monthIndex + ":" + this.yearIndex;
                SubstanceMonthViewUI.this.nextMonthStateMap.put(key, SubstanceMonthViewUI.this.getMonthState(this.monthIndex, this.yearIndex));
            }
            this.repaintCell();
        }

        private void repaintCell() {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (MonthRepaintCallback.this.monthView != SubstanceMonthViewUI.this.monthView) {
                        return;
                    }
                    Calendar cal = MonthRepaintCallback.this.monthView.getCalendar();
                    cal.set(2, MonthRepaintCallback.this.monthIndex);
                    cal.set(1, MonthRepaintCallback.this.yearIndex);
                    Rectangle monthBounds = SubstanceMonthViewUI.this.getMonthBounds(cal.getTime());
                    if (monthBounds != null) {
                        MonthRepaintCallback.this.monthView.repaint(monthBounds);
                    }
                }
            });
        }
    }

    private class DayRolloverFadeListener
    implements MouseListener,
    MouseMotionListener {
        private DayRolloverFadeListener() {
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
            this.fadeOutDay();
            this.fadeOutMonth();
            SubstanceMonthViewUI.this.resetRolloverIndex();
        }

        public void mouseMoved(MouseEvent e) {
            if (!SubstanceMonthViewUI.this.monthView.isEnabled()) {
                return;
            }
            this.handleMove(e);
        }

        public void mouseDragged(MouseEvent e) {
            if (!SubstanceMonthViewUI.this.monthView.isEnabled()) {
                return;
            }
            this.handleMove(e);
        }

        private void handleMove(MouseEvent e) {
            boolean fadeAllowed = FadeConfigurationManager.getInstance().fadeAllowed(FadeKind.ROLLOVER, (Component)SubstanceMonthViewUI.this.monthView);
            if (!fadeAllowed) {
                this.fadeOutDay();
                this.fadeOutMonth();
                SubstanceMonthViewUI.this.resetRolloverIndex();
                return;
            }
            Date matchingDay = SubstanceMonthViewUI.this.monthView.getDayAtLocation(e.getX(), e.getY());
            if (matchingDay == null) {
                this.fadeOutDay();
                this.fadeOutMonth();
                SubstanceMonthViewUI.this.resetRolloverIndex();
            } else {
                Rectangle monthBounds = SubstanceMonthViewUI.this.getMonthBounds(matchingDay);
                if (monthBounds == null || !monthBounds.contains(e.getPoint())) {
                    this.fadeOutDay();
                    this.fadeOutMonth();
                    SubstanceMonthViewUI.this.resetRolloverIndex();
                } else {
                    boolean isDifferentMonth;
                    Calendar cal = SubstanceMonthViewUI.this.monthView.getCalendar();
                    cal.setTime(matchingDay);
                    int roIndexDay = cal.get(5);
                    int roIndexMonth = cal.get(2);
                    int roIndexYear = cal.get(1);
                    if (SubstanceMonthViewUI.this.rolloverDayId >= 0 && SubstanceMonthViewUI.this.rolloverDayId == roIndexDay && SubstanceMonthViewUI.this.rolloverMonthId >= 0 && SubstanceMonthViewUI.this.rolloverMonthId == roIndexMonth && SubstanceMonthViewUI.this.rolloverYearId >= 0 && SubstanceMonthViewUI.this.rolloverYearId == roIndexYear) {
                        return;
                    }
                    this.fadeOutDay();
                    boolean bl = isDifferentMonth = SubstanceMonthViewUI.this.rolloverMonthId != roIndexMonth;
                    if (isDifferentMonth) {
                        this.fadeOutMonth();
                    }
                    SubstanceMonthViewUI.this.rolloverDayId = roIndexDay;
                    SubstanceMonthViewUI.this.rolloverMonthId = roIndexMonth;
                    SubstanceMonthViewUI.this.rolloverYearId = roIndexYear;
                    FadeTracker.getInstance().trackFadeIn(FadeKind.ROLLOVER, (Component)SubstanceMonthViewUI.this.monthView, (Comparable)((Object)(SubstanceMonthViewUI.this.rolloverDayId + ":" + SubstanceMonthViewUI.this.rolloverMonthId + ":" + SubstanceMonthViewUI.this.rolloverYearId)), false, (FadeTrackerCallback)new DayRepaintCallback(SubstanceMonthViewUI.this.monthView, SubstanceMonthViewUI.this.rolloverDayId, SubstanceMonthViewUI.this.rolloverMonthId, SubstanceMonthViewUI.this.rolloverYearId));
                    if (isDifferentMonth) {
                        FadeTracker.getInstance().trackFadeIn(FadeKind.ROLLOVER, (Component)SubstanceMonthViewUI.this.monthView, (Comparable)((Object)(SubstanceMonthViewUI.this.rolloverMonthId + ":" + SubstanceMonthViewUI.this.rolloverYearId)), false, (FadeTrackerCallback)new MonthRepaintCallback(SubstanceMonthViewUI.this.monthView, SubstanceMonthViewUI.this.rolloverMonthId, SubstanceMonthViewUI.this.rolloverYearId));
                    }
                }
            }
        }

        private void fadeOutDay() {
            if (SubstanceMonthViewUI.this.rolloverDayId < 0 || SubstanceMonthViewUI.this.rolloverMonthId < 0 || SubstanceMonthViewUI.this.rolloverYearId < 0) {
                return;
            }
            FadeTracker.getInstance().trackFadeOut(FadeKind.ROLLOVER, (Component)SubstanceMonthViewUI.this.monthView, (Comparable)((Object)(SubstanceMonthViewUI.this.rolloverDayId + ":" + SubstanceMonthViewUI.this.rolloverMonthId + ":" + SubstanceMonthViewUI.this.rolloverYearId)), false, (FadeTrackerCallback)new DayRepaintCallback(SubstanceMonthViewUI.this.monthView, SubstanceMonthViewUI.this.rolloverDayId, SubstanceMonthViewUI.this.rolloverMonthId, SubstanceMonthViewUI.this.rolloverYearId));
        }

        private void fadeOutMonth() {
            if (SubstanceMonthViewUI.this.rolloverMonthId < 0 || SubstanceMonthViewUI.this.rolloverYearId < 0) {
                return;
            }
            FadeTracker.getInstance().trackFadeOut(FadeKind.ROLLOVER, (Component)SubstanceMonthViewUI.this.monthView, (Comparable)((Object)(SubstanceMonthViewUI.this.rolloverMonthId + ":" + SubstanceMonthViewUI.this.rolloverYearId)), false, (FadeTrackerCallback)new MonthRepaintCallback(SubstanceMonthViewUI.this.monthView, SubstanceMonthViewUI.this.rolloverMonthId, SubstanceMonthViewUI.this.rolloverYearId));
        }
    }
}

