/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jdesktop.swingx.JXEditorPane;
import org.jdesktop.swingx.LinkModel;

public class EditorPaneLinkVisitor
implements ActionListener {
    private JXEditorPane editorPane;
    private HyperlinkListener hyperlinkListener;
    private LinkModel internalLink;

    public EditorPaneLinkVisitor() {
        this(null);
    }

    public EditorPaneLinkVisitor(JXEditorPane pane) {
        if (pane == null) {
            pane = this.createDefaultEditorPane();
        }
        this.editorPane = pane;
        pane.addHyperlinkListener(this.getHyperlinkListener());
    }

    public JXEditorPane getOutputComponent() {
        return this.editorPane;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof LinkModel) {
            final LinkModel link = (LinkModel)e.getSource();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    EditorPaneLinkVisitor.this.visit(link);
                }
            });
        }
    }

    public void visit(LinkModel link) {
        try {
            this.editorPane.getDocument().putProperty("stream", null);
            this.editorPane.setPage(link.getURL());
            link.setVisited(true);
        }
        catch (IOException e1) {
            this.editorPane.setText("<html>Error 404: couldn't show " + link.getURL() + " </html>");
        }
    }

    protected JXEditorPane createDefaultEditorPane() {
        JXEditorPane editorPane = new JXEditorPane();
        editorPane.setEditable(false);
        editorPane.setContentType("text/html");
        return editorPane;
    }

    protected HyperlinkListener getHyperlinkListener() {
        if (this.hyperlinkListener == null) {
            this.hyperlinkListener = this.createHyperlinkListener();
        }
        return this.hyperlinkListener;
    }

    protected HyperlinkListener createHyperlinkListener() {
        return new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (HyperlinkEvent.EventType.ACTIVATED == e.getEventType()) {
                    EditorPaneLinkVisitor.this.visitInternal(e.getURL());
                }
            }
        };
    }

    protected LinkModel getInternalLink() {
        if (this.internalLink == null) {
            this.internalLink = new LinkModel("internal");
        }
        return this.internalLink;
    }

    protected void visitInternal(URL url) {
        try {
            this.getInternalLink().setURL(url);
            this.visit(this.getInternalLink());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

