/*
 * Decompiled with CFR 0.152.
 */
package jpos.config.simple.xml;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import jpos.config.JposConfigException;
import jpos.config.JposEntry;
import jpos.config.simple.SimpleEntry;
import jpos.config.simple.xml.AbstractXercesRegPopulator;
import jpos.util.JposEntryUtility;
import jpos.util.tracing.Tracer;
import jpos.util.tracing.TracerFactory;
import org.apache.xerces.jaxp.SAXParserFactoryImpl;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class Xerces2RegPopulator
extends AbstractXercesRegPopulator {
    private XMLReader xmlReader = null;
    private SAXParser saxParser = null;
    private ErrorHandler errorHandler = new JposErrorHandler();
    private ContentHandler contentHandler = new JposContentHandler();
    private EntityResolver entityResolver = new JposEntityResolver();
    private List jposEntryList = new LinkedList();
    private Tracer tracer = TracerFactory.getInstance().createTracer("Xerces2RegPopulator", true);
    public static final String XERCES2_REG_POPULATOR_NAME_STRING = "JCL XML Entries Populator 2";
    static /* synthetic */ Class class$jpos$config$simple$xml$XercesRegPopulator;
    static /* synthetic */ Class class$jpos$config$simple$xml$Xerces2RegPopulator;

    public Xerces2RegPopulator() {
        super((class$jpos$config$simple$xml$XercesRegPopulator == null ? (class$jpos$config$simple$xml$XercesRegPopulator = Xerces2RegPopulator.class$("jpos.config.simple.xml.XercesRegPopulator")) : class$jpos$config$simple$xml$XercesRegPopulator).getName());
    }

    public Xerces2RegPopulator(String string) {
        super(string);
    }

    public String getClassName() {
        return (class$jpos$config$simple$xml$Xerces2RegPopulator == null ? (class$jpos$config$simple$xml$Xerces2RegPopulator = Xerces2RegPopulator.class$("jpos.config.simple.xml.Xerces2RegPopulator")) : class$jpos$config$simple$xml$Xerces2RegPopulator).getName();
    }

    public void load() {
        try {
            InputStream inputStream = this.getPopulatorFileIS();
            this.load(this.getPopulatorFileName());
        }
        catch (Exception exception) {
            this.tracer.println("Error while loading populator file Exception.message: " + exception.getMessage());
            this.lastLoadException = exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(String string) {
        Reader reader = null;
        try {
            reader = new FileReader(new File(string));
            InputSource inputSource = new InputSource(reader);
            XMLReader xMLReader = this.getSAXParser().getXMLReader();
            this.initXMLReader(xMLReader);
            xMLReader.setErrorHandler(this.errorHandler);
            xMLReader.setContentHandler(this.contentHandler);
            xMLReader.setEntityResolver(this.entityResolver);
            this.jposEntryList.clear();
            this.lastLoadException = null;
            xMLReader.parse(inputSource);
            Iterator iterator = this.jposEntryList.iterator();
            while (iterator.hasNext()) {
                JposEntry jposEntry = (JposEntry)iterator.next();
                this.getJposEntries().put(jposEntry.getLogicalName(), jposEntry);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.tracer.println("Could not find file: " + string);
            this.lastLoadException = fileNotFoundException;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            this.tracer.println("Could not create and configure SAX parser/factory" + parserConfigurationException.getMessage());
            this.lastLoadException = parserConfigurationException;
        }
        catch (IOException iOException) {
            this.tracer.println("Error while parsing XML file:IOException.msg=" + iOException.getMessage());
            this.lastLoadException = iOException;
        }
        catch (SAXException sAXException) {
            this.tracer.println("Error creating or using the SAXParser:SAXException.message=" + sAXException.getMessage());
            this.lastLoadException = sAXException;
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {
                this.tracer.println("load( " + string + ") IOException.msg=" + iOException.getMessage());
            }
        }
    }

    public String getName() {
        return XERCES2_REG_POPULATOR_NAME_STRING;
    }

    protected SAXParser getSAXParser() throws ParserConfigurationException, SAXException {
        if (this.saxParser == null) {
            SAXParserFactoryImpl sAXParserFactoryImpl = new SAXParserFactoryImpl();
            this.saxParser = sAXParserFactoryImpl.newSAXParser();
        }
        return this.saxParser;
    }

    protected void initXMLReader(XMLReader xMLReader) throws SAXException {
        xMLReader.setFeature("http://xml.org/sax/features/namespaces", true);
        xMLReader.setFeature("http://xml.org/sax/features/validation", true);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class JposErrorHandler
    implements ErrorHandler {
        protected JposErrorHandler() {
        }

        private String createMessage(String string, SAXParseException sAXParseException) {
            return string + "parsing XML file:SAXParseException.message = " + sAXParseException.getMessage();
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            String string = this.createMessage("JposErrorHandler:Error:", sAXParseException);
            Xerces2RegPopulator.this.tracer.print(string);
            throw new SAXException(string);
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            String string = this.createMessage("JposErrorHandler:FatalError:", sAXParseException);
            Xerces2RegPopulator.this.tracer.print(string);
            throw new SAXException(string);
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
            String string = this.createMessage("JposErrorHandler:Warning:", sAXParseException);
            Xerces2RegPopulator.this.tracer.print(string);
            throw new SAXException(string);
        }
    }

    public class JposEntityResolver
    implements EntityResolver {
        public InputSource resolveEntity(String string, String string2) {
            InputStream inputStream;
            Xerces2RegPopulator.this.tracer.println("JposEntityResolver:resolveEntity:publicId=" + string);
            Xerces2RegPopulator.this.tracer.println("JposEntityResolver:resolveEntity:systemId=" + string2);
            if (string.equals(Xerces2RegPopulator.this.getDoctypeValue()) && (inputStream = this.getClass().getResourceAsStream(Xerces2RegPopulator.this.getDoctypeValue())) != null) {
                return new InputSource(new InputStreamReader(inputStream));
            }
            return null;
        }
    }

    protected class JposContentHandler
    extends DefaultHandler
    implements ContentHandler {
        private JposEntry currentEntry = null;

        protected JposContentHandler() {
        }

        public void startDocument() throws SAXException {
            Xerces2RegPopulator.this.tracer.println("<startDocument/>");
        }

        public void endDocument() throws SAXException {
            Xerces2RegPopulator.this.tracer.println("<endDocument/>");
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            Xerces2RegPopulator.this.tracer.println("<startElement qName=\"" + string3 + "\"/>");
            if (string3.equals("JposEntries")) {
                Xerces2RegPopulator.this.jposEntryList.clear();
                this.currentEntry = null;
            } else if (string3.equals("JposEntry")) {
                this.currentEntry = this.createEntry(attributes);
            } else if (string3.equals("creation")) {
                this.addCreationProp(this.currentEntry, attributes);
            } else if (string3.equals("vendor")) {
                this.addVendorProp(this.currentEntry, attributes);
            } else if (string3.equals("jpos")) {
                this.addJposProp(this.currentEntry, attributes);
            } else if (string3.equals("product")) {
                this.addProductProp(this.currentEntry, attributes);
            } else if (string3.equals("prop")) {
                this.addProp(this.currentEntry, attributes);
            } else {
                Xerces2RegPopulator.this.tracer.println("Invalid qName=" + string3);
                throw new SAXException("Invalid qName=" + string3);
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            Xerces2RegPopulator.this.tracer.println("<endElement qName=\"" + string3 + "\"/>");
            if (string3.equals("JposEntry")) {
                Xerces2RegPopulator.this.jposEntryList.add(this.currentEntry);
            }
        }

        protected JposEntry createEntry(Attributes attributes) throws SAXException {
            String string = attributes.getValue("logicalName");
            return new SimpleEntry(string, Xerces2RegPopulator.this);
        }

        protected void addCreationProp(JposEntry jposEntry, Attributes attributes) throws SAXException {
            String string = attributes.getValue("factoryClass");
            String string2 = attributes.getValue("serviceClass");
            this.currentEntry.addProperty("serviceInstanceFactoryClass", string);
            this.currentEntry.addProperty("serviceClass", string2);
        }

        protected void addVendorProp(JposEntry jposEntry, Attributes attributes) throws SAXException {
            String string = attributes.getValue("name");
            String string2 = attributes.getValue("url");
            this.currentEntry.addProperty("vendorName", string);
            this.currentEntry.addProperty("vendorURL", string2);
        }

        protected void addJposProp(JposEntry jposEntry, Attributes attributes) throws SAXException {
            String string = attributes.getValue("category");
            String string2 = attributes.getValue("version");
            this.currentEntry.addProperty("deviceCategory", string);
            this.currentEntry.addProperty("jposVersion", string2);
        }

        protected void addProductProp(JposEntry jposEntry, Attributes attributes) throws SAXException {
            String string = attributes.getValue("description");
            String string2 = attributes.getValue("name");
            String string3 = attributes.getValue("url");
            this.currentEntry.addProperty("productDescription", string);
            this.currentEntry.addProperty("productName", string2);
            this.currentEntry.addProperty("productURL", string3);
        }

        protected void addProp(JposEntry jposEntry, Attributes attributes) throws SAXException {
            String string = attributes.getValue("name");
            String string2 = attributes.getValue("value");
            String string3 = attributes.getValue("type");
            if (string3 == null || string3.equals("")) {
                string3 = "String";
            }
            try {
                Class clazz = JposEntryUtility.propTypeFromString(attributes.getValue("type"));
                Object object = JposEntryUtility.parsePropValue(string2, clazz);
                JposEntry.Prop prop = this.currentEntry.createProp(string, object, clazz);
                this.currentEntry.add(prop);
            }
            catch (JposConfigException jposConfigException) {
                String string4 = "Invalid prop: name=" + string + ":value=" + string2;
                Xerces2RegPopulator.this.tracer.println(string4);
                throw new SAXException(string4);
            }
        }
    }
}

